Group: Development/Tools
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           xa
Version:        2.3.11
Release:        alt1_4
Summary:        6502/65816 cross-assembler

License:        GPLv2+
URL:            http://www.floodgap.com/retrotech/xa/
Source0:        http://www.floodgap.com/retrotech/%{name}/dists/%{name}-%{version}.tar.gz
# update the build system, reported in private email
Patch0:         %{name}-2.3.7-make.patch
BuildRequires:  gcc
# Perl needed for test-suite
BuildRequires:  rpm-build-perl
Source44: import.info


%description
xa is a high-speed, two-pass portable cross-assembler. It understands
mnemonics and generates code for NMOS 6502s (such as 6502A, 6504, 6507,
6510, 7501, 8500, 8501, 8502 ...), CMOS 6502s (65C02 and Rockwell R65C02)
and the 65816.

Key amongst its features:

    * C-like preprocessor (and understands cpp for additional feature support)
    * rich expression syntax and pseudo-op vocabulary
    * multiple character sets
    * binary linking
    * supports o65 relocatable objects with a full linker and relocation suite, 
      as well as "bare" plain binary object files
    * block structure for label scoping 


%prep
%setup -q
%patch0 -p1


# fix encoding
for f in ChangeLog doc/fileformat.txt
do
    iconv -f ISO-8859-1 -t UTF-8 < $f > $f.new
    touch -r $f $f.new
    mv $f.new $f
done


%build
%make_build CFLAGS="$RPM_OPT_FLAGS"


%check
make test


%install
%makeinstall_std PREFIX=%{_prefix}


%files
%doc COPYING ChangeLog README.1st doc/fileformat.txt
%{_bindir}/*
%{_mandir}/man1/*


%changelog
