Name: xboard
Version: 4.9.1
Release: alt2

Summary: An X Window System graphical chessboard
License: GPLv3+
Group: Games/Boards

# git://git.savannah.gnu.org/xboard.git
Url: http://www.gnu.org/software/xboard/
Source0: ftp://ftp.gnu.org/pub/gnu/xboard/%name-%version.tar
Source1: xboard-16x16.png
Source2: xboard-32x32.png
Source3: xboard-48x48.png
Source4: xboard.desktop
Source5: xboard.ad
Packager: Stanislav Ievlev <inger@altlinux.org>

Requires: %name-theme
# xboard 4.4 uses fairymax as default engine,
# special runtime configuration needed for GNU Chess
Requires: fairymax

# needs helvetica: #30634
Requires: fonts-bitmap-100dpi

# Automatically added by buildreq on Sun Apr 10 2016
# optimized out: fontconfig fontconfig-devel glib2-devel libX11-devel libatk-devel libcairo-devel libfreetype-devel libgdk-pixbuf libgdk-pixbuf-devel libgio-devel libpango-devel libwayland-client libwayland-server perl-Encode perl-Text-Unidecode perl-Unicode-EastAsianWidth perl-Unicode-Normalize perl-libintl perl-unicore pkg-config python-base python-modules xorg-xproto-devel xz
BuildRequires: groff-base libgtk+2-devel librsvg-devel makeinfo

%set_verify_info_method none

%description
Xboard is an X Window System based graphical chessboard which can be
used with the GNUchess and Crafty chess programs, with Internet Chess
Servers (ICSs), with chess via email, or with your own saved games.

%package theme-default
Summary: default theme for xboard
Group: Graphics
License: GPL
Provides: %name-theme
Requires: %name
Conflicts: xboard-theme-eyes xboard-theme-fantasy xboard-theme-freak
Conflicts: xboard-theme-prmi xboard-theme-skulls xboard-theme-spatial
BuildArch: noarch

%description theme-default
default theme for xboard

%prep
%setup

%build
%add_optflags -fcommon
%autoreconf
%configure --with-gtk
%make_build

%install
%makeinstall

#icon
install -Dpm644 %SOURCE1 %buildroot%_miconsdir/%name.png
install -Dpm644 %SOURCE2 %buildroot%_niconsdir/%name.png
install -Dpm644 %SOURCE3 %buildroot%_liconsdir/%name.png
install -Dpm644 %SOURCE4 %buildroot%_desktopdir/%name.desktop
install -Dpm644 %SOURCE5 %buildroot%_sysconfdir/X11/app-defaults/XBoard

#default theme
install -d %buildroot%_datadir/%name/theme
#cp -a pixmaps/*.xpm %buildroot%_datadir/%name/theme

%find_lang %name

%files -f %name.lang
%doc AUTHORS COPYING COPYRIGHT ChangeLog* NEWS TODO
%doc FAQ.html README
%config(noreplace) %_sysconfdir/X11/app-defaults/*
%config(noreplace) %_sysconfdir/%name.conf
%_bindir/*
%_man6dir/*
%_infodir/*.info*
%_datadir/mime/*/*.xml
%_gamesdatadir/%name/pixmaps/
%_gamesdatadir/%name/sounds/
%_desktopdir/*
%_miconsdir/*.png
%_niconsdir/*.png
%_liconsdir/*.png
%_iconsdir/*/*/*/*.svg

%files theme-default
%_gamesdatadir/%name/themes/

%changelog
