# vim: set ft=spec: -*- rpm-spec -*-

%ifarch aarch64 ppc64le
%def_disable check
%else
%def_enable check
%endif

Name: xca
Version: 2.8.0
Release: alt2.p10.1

Summary: A GUI for handling X509 certificates, RSA keys, PKCS#10 Requests
Group: Security/Networking
License: BSD
Url: https://hohnstaedt.de/xca/
# sources: https://github.com/chris2511/xca/

Source: %name-%version.tar

Patch0: alt-test_asn1time-do-not-force-TZ.patch
Patch1: 0001-Fix-GOST-Certificate-view.patch
Patch2: 0002-Add-support-for-GOST-key-generation-and-certificate-.patch
Patch3: 0003-Add-fallback-handling-if-GOST-engine-is-not-loaded.patch
Patch4: 0004-backport-to-p10-branch-and-minor-improvements.patch

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake gcc-c++
BuildRequires: qt5-base-devel qt5-tools-devel
BuildRequires: qt5-sql-interbase qt5-sql-mysql qt5-sql-odbc qt5-sql-postgresql
BuildRequires: python3-module-sphinx-sphinx-build-symlink
BuildRequires: ctest

%description
Graphical certification authority is an interface for managing RSA
keys and certificates, and the creation and signing of PKCS#10
requests. It uses the OpenSSL library and a Berkeley DB for key and
certificate storage. It supports importing and exporting keys and PEM
DER PKCS8 certificates, signing and revoking of PEM DER PKCS12, and
the selection of x509v3 extensions. A tree view of certificates is
presented.

%prep
%setup
%patch0 -p1
%patch1 -p2
%patch2 -p2
%patch3 -p2
%patch4 -p2

%build
%cmake
%cmake_build

%check
%cmake_build -t tests
LANG="C.UTF-8" TZ="GMT" \
    %ctest -L console

%install
%cmake_install

%files
%doc AUTHORS README.md
%_datadir/xca
%_datadir/doc/xca
%_datadir/metainfo/*.xml
%_desktopdir/*xca*
%_datadir/bash-completion/completions/xca
%_datadir/mime/packages/xca.xml
%_man1dir/xca*.1*
%_iconsdir/hicolor/*/*/*
%_bindir/*

%changelog
