%def_disable static

Name: xfsprogs
Version: 5.12.0
Release: alt1

Summary: Utilities for managing the XFS filesystem
License: LGPL-2.1 and GPL-2.0
Group: System/Kernel and hardware

Url: http://xfs.org
Source: %name-%version-%release.tar
Patch0: %name-%version-alt.patch

Requires: libxfs = %version-%release
Conflicts: xfsdump < 3.0.0-alt1

BuildPreReq: rpm-build >= 4.0.4-alt96.11

# makefiles are buggy
BuildConflicts: libxfs-devel

BuildRequires: libuuid-devel libblkid-devel 
BuildRequires: libsystemd-devel rpm-build-python3
BuildRequires: libinih-devel

%description
XFS is a high performance journaling filesystem which originated
on the SGI IRIX platform.  It is completely multi-threaded, can
support large files and large filesystems, extended attributes,
variable block sizes, is extent based, and makes extensive use of
Btrees (directories, extents, free space) to aid both performance
and scalability.

Refer to the documentation at http://oss.sgi.com/projects/xfs/
for complete details.  This implementation is on-disk compatible
with the IRIX version of XFS.

This package contains a set of commands to use the XFS filesystem,
including mkfs.xfs.

%package -n libxfs
Summary: XFS filesystem-specific libraries
Group: System/Libraries

%description -n libxfs
This package contains the library needed to run programs dynamically
linked with libxfs.

%package -n libxfs-devel
Summary: XFS filesystem-specific devel libraries and headers
Group: Development/C
Requires: libxfs = %version-%release

%description -n libxfs-devel
libxfs-devel contains the libraries and header files needed to
develop XFS filesystem-specific programs.

You should install libxfs-devel if you want to develop XFS
filesystem-specific programs, If you install libxfs-devel, you'll
also want to install xfsprogs.

%if_enabled static
%package -n libxfs-devel-static
Summary: XFS filesystem-specific static libraries
Group: Development/C
Requires: libxfs-devel = %version-%release

%description -n libxfs-devel-static
libxfs-devel-static contains the static libraries needed to
develop XFS filesystem-specific programs.

You should install libxfs-devel-static if you want to develop XFS
filesystem-specific programs.

If you install libxfs-devel-static, you'll also want to install xfsprogs.
%endif

%prep
%setup
%patch0 -p1

%build
make configure
%configure \
	--libdir=/%_lib \
	--libexecdir=%_libdir
make DEBUG=-DNDEBUG LIBTOOL="`pwd`/libtool"

%install
make DIST_ROOT=%buildroot install install-dev
mkdir -p %buildroot%_libdir

for f in %buildroot/%_lib/*.so; do
	t=`objdump -p "$f" |awk '/SONAME/ {print $2}'`
	[ -n "$t" ]
	ln -nsf ../../%_lib/"$t" "%buildroot%_libdir/${f##*/}"
done
# don't use crontab 
rm -f %buildroot/%_lib/xfsprogs/xfs_scrub_all.cron
# Workaround bug in makefiles
rm -f %buildroot/%_lib/*.{so,*a}
rm -rf %buildroot%_datadir/doc/%name

%find_lang %name

%files -f %name.lang
/sbin/*
%_sbindir/*
%_unitdir/*.service
%_unitdir/*.timer
/%_lib/xfsprogs/xfs_scrub_fail
%_mandir/man[85]/*
%doc doc/CHANGES.gz doc/CREDITS README

%files -n libxfs
/%_lib/*.so.*

%files -n libxfs-devel
%_libdir/*.so
%dir %_includedir/xfs
%_includedir/xfs/handle.h
%_includedir/xfs/jdm.h
%_includedir/xfs/linux.h
%_includedir/xfs/xfs.h
%_includedir/xfs/xfs_fs.h
%_includedir/xfs/xfs_arch.h
%_includedir/xfs/xfs_da_format.h
%_includedir/xfs/xfs_format.h
%_includedir/xfs/xfs_log_format.h
%_includedir/xfs/xfs_fs_compat.h
%_includedir/xfs/xfs_types.h
%_includedir/xfs/xqm.h
%_man2dir/*
%_man3dir/*

%if_enabled static
%files -n libxfs-devel-static
%_libdir/*.a
%endif

%changelog
