Name: xinetd
Version: 2.3.15
Release: alt5

Summary: xinetd is a powerful replacement for inetd
Group: System/Base
License: BSD-style
Url: http://www.xinetd.org/

# http://www.xinetd.org/xinetd-%version.tar.gz
Source: xinetd-%version.tar
Source1: xinetd.init
Source2: xinetd.conf
Source3: xinetd.service
Source4: xinetd.sysconf
Source5: xinetd.logrotate
Source6: convert.pl
Source7: faq.html
Source8: xinetd-tutorial.html

Source10: chargen-tcp.xinetd
Source11: chargen-udp.xinetd
Source12: daytime-tcp.xinetd
Source13: daytime-udp.xinetd
Source14: discard-tcp.xinetd
Source15: discard-udp.xinetd
Source16: echo-tcp.xinetd
Source17: echo-udp.xinetd
Source18: time-tcp.xinetd
Source19: time-udp.xinetd

Patch1: xinetd-2.3.15-owl-bad_port_check.patch
Patch2: xinetd-2.3.15-owl-fixes.patch
Patch3: xinetd-2.3.15-owl-man.patch

Patch11: xinetd-2.3.12-alt-skipfiles.patch
Patch12: xinetd-2.3.15-alt-remlock.patch
Patch13: xinetd-2.3.12-alt-configure-nsl.patch
Patch14: xinetd-2.3.13-alt-pidfile.patch
Patch15: xinetd-2.3.12-alt-record.patch
Patch16: xinetd-2.3.13-alt-parse_inet_addresses.patch

Patch21: xinetd-2.3.14-rh-man.patch
Patch22: xinetd-2.3.15-rh-pie.patch
Patch23: xinetd-2.3.14-rh-ident-bind.patch
Patch24: xinetd-2.3.14-rh-readable-debuginfo.patch
Patch25: xinetd-2.3.14-rh-ident-ipv6confusion.patch
Patch26: xinetd-2.3.14-rh-signal-log-hang.patch
Patch27: xinetd-2.3.15-rh-context-exepath.patch
Patch28: xinetd-2.3.15-up-CVE-2013-4342.patch

Provides: %_sysconfdir/%name.d

BuildRequires: libtirpc-devel

%package devel
Summary: Libraries and header files for developing xinetd-aware applications
Group: Development/C
Requires: %name = %version-%release

%description
xinetd performs the same function as inetd: it starts programs that
provide Internet services.  Instead of having such servers started at
system initialization time, and be dormant until a connection request
arrives, xinetd is the only daemon process started and it listens on
all service ports for the services listed in its configuration file.
When a request comes in, xinetd starts the appropriate server.  Because
of the way it operates, xinetd (as well as inetd) is also referred to
as a super-server.

xinetd has access control machanisms, extensive logging capabilities,
the ability to make services available based on time, and can place
limits on the number of servers that can be started, among other things.

%description devel
This package contains development libraries and header files
required for building xinetd-aware applications.

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1

%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1
%patch16 -p1

%patch21 -p1
%patch22 -p1
%patch23 -p1
%patch24 -p1
%patch25 -p1
%patch26 -p1
%patch27 -p1
%patch28 -p1

install -p -m644 %_sourcedir/{faq.html,xinetd-tutorial.html} .
find -type f -name \*.orig -delete

%build
%{expand:%%add_optflags -Wno-unused -Wno-switch %(pkg-config --cflags libtirpc)}
%def_without libwrap
%def_with loadavg
autoconf
export ac_cv_header_DNSServiceDiscovery_DNSServiceDiscovery_h=no
export LDFLAGS="${LDFLAGS-} $(pkg-config --libs libtirpc)"
%configure \
	%{subst_with libwrap} \
	%{subst_with loadavg} \
	#

%make_build

for f in libs/src/*/README; do
	d="${f%%/*}"
	install -p -m644 "$f" "README.${d##*/}"
done

%install
mkdir -p %buildroot{%_libdir/%name,%_includedir/%name,%_mandir/man{3,5,8}}

install -pD -m755 %_sourcedir/xinetd.init %buildroot%_initdir/%name
install -pD -m644 %_sourcedir/xinetd.service %buildroot%_unitdir/%name.service
install -pD -m640 %_sourcedir/xinetd.conf %buildroot%_sysconfdir/%name.conf
install -pD -m640 %_sourcedir/xinetd.sysconf %buildroot%_sysconfdir/sysconfig/%name
install -pD -m755 %_sourcedir/convert.pl %buildroot%_sbindir/inetdconvert
install -pD -m640 %_sourcedir/%name.logrotate %buildroot%_sysconfdir/logrotate.d/%name
for i in chargen daytime discard echo time; do
	install -pD -m640 %_sourcedir/$i-tcp.%name %buildroot%_sysconfdir/%name.d/$i-tcp
	install -pD -m640 %_sourcedir/$i-udp.%name %buildroot%_sysconfdir/%name.d/$i-udp
done

%makeinstall DAEMONDIR=%buildroot%_sbindir MANDIR=%buildroot%_mandir
%make_install makelibs \
	LIBDIR=%buildroot%_libdir/%name \
	INCLUDEDIR=%buildroot%_includedir/%name \
	MANDIR=%buildroot%_man3dir

find %buildroot{%_libdir,%_includedir,%_mandir} -type f -print0 |
	xargs -r0 chmod 644 --

mkdir -p %buildroot%_sysconfdir/%name.d
install -pD /dev/null %buildroot%_logdir/%name/%name.log

# No need to ship this.
rm %buildroot{%_sbindir/{itox,xconv.pl},%_man8dir/{itox,xconv.pl}*}
rm %buildroot%_mandir/*.3

%post
%post_service %name

%preun
%preun_service %name

%files
%_unitdir/%name.service
%config %_initdir/%name
%config(noreplace) %_sysconfdir/logrotate.d/*
%config(noreplace) %_sysconfdir/sysconfig/%name
%config(noreplace) %_sysconfdir/%name.conf
%config(noreplace) %_sysconfdir/%name.d/*
%attr(700,root,root) %dir %_sysconfdir/%name.d
%attr(750,root,adm) %dir %_logdir/%name
%ghost %attr(640,root,adm) %verify(not md5 mtime size) %_logdir/%name/%name.log
%_sbindir/*
%_mandir/man[58]/*
%doc AUDIT CHANGELOG COPYRIGHT INSTALL README *.html %name/sample.conf

%files devel
%_libdir/%name/
%_includedir/*
%_man3dir/*
%doc README.*

%changelog
