# TODO: python-uinput

Name: xpra
Version: 4.4.4
Release: alt3

Summary: X Persistent Remote Applications
License: GPLv2
Group: Networking/Remote access

Url: http://xpra.org/
Source: https://xpra.org/src/xpra-%version.tar

BuildRequires(pre): rpm-build-python3

BuildRequires: gcc-c++ libXcomposite-devel libXdamage-devel libXrandr-devel libXtst-devel libXres-devel libxkbfile-devel libpam0-devel libsystemd-devel

BuildRequires: libgtk+3-devel python3-module-pygobject3-devel python3-module-pycairo-devel

# Video
BuildRequires: libvpx-devel libx264-devel libx265-devel libwebp-devel libjpeg-devel libpng-devel libyuv-devel liblz4-devel

# p9+
%def_without ffmpeg_static

%if_with ffmpeg_static
BuildRequires: libffmpeg-devel-static
%else
BuildRequires: libavformat-devel libavcodec-devel libswscale-devel
%endif

# Sound
BuildRequires: libogg-devel libopus-devel libflac-devel libspeex-devel libvorbis-devel libwavpack-devel liblame-devel libtwolame-devel libmad-devel

# GL
BuildRequires: python3-module-OpenGL python3-module-OpenGL_accelerate
Requires: python3-module-OpenGL python3-module-OpenGL_accelerate

BuildRequires: python3-module-Pillow python3-module-websockify

%ifarch %e2k
# no libv8/node so far => --without-minify;
# it's java actually
BuildRequires: python3-module-yuicompressor
BuildRequires: /proc
%else
BuildRequires: /usr/bin/uglifyjs
%endif

BuildRequires: xorg-server brotli

BuildRequires: pandoc

# See https://bugzilla.altlinux.org/show_bug.cgi?id=28632
BuildRequires: python3-module-Cython >= 0.20

AutoReq: yes, nomingw
# server is not a python package
AutoProv: yes, nopython3

# why they are required?
%add_python3_req_skip xpra.codecs.argb.argb xpra.codecs.xor.cyxor xpra.codecs.evdi.capture
%add_python3_req_skip xpra.rectangle xpra.server.cystats xpra.server.window.motion
%add_python3_req_skip xpra.x11.bindings.core_bindings xpra.x11.bindings.display_source
%add_python3_req_skip xpra.x11.bindings.keyboard_bindings xpra.x11.bindings.randr_bindings
%add_python3_req_skip xpra.x11.bindings.window_bindings xpra.x11.bindings.ximage
%add_python3_req_skip xpra.net.websockets.mask xpra.x11.bindings.res_bindings xpra.x11.gtk3.gdk_bindings

# disabled during build
%add_python3_req_skip xpra.net.mdns

%add_python3_req_skip win32security pyopencl xpra.platform.win32.common

# prefer dbus notification
%add_python3_req_skip pynotify

BuildRequires(pre): rpm-build-gir rpm-build-intro rpm-macros-kde-common-devel

# Unity specific?
%add_typelib_req_skiplist typelib(AppIndicator) typelib(AppIndicator3) typelib(GtkosxApplication)

# TODO:
%add_typelib_req_skiplist typelib(GdkGLExt) typelib(GtkGLExt)

# Note: we have no linking requires to libwebp.so.x
Requires: libwebp

Requires: xorg-xvfb setxkbmap

Requires: python3-module-pyinotify python3-module-rencode python3-module-lz4 python3-module-netifaces

Requires: libgtk+3-gir

Requires: cert-sh-functions

%ifarch %e2k
%define py_flags --without-mdns --without-html5 --without-minify
%else
%define py_flags --without-mdns
%endif

%description
Xpra is 'screen for X': it allows you to run X programs,
usually on a remote host, direct their display to your local machine,
and then to disconnect from these programs and reconnect
from the same or another machine, without losing any state.
It gives you remote access to individual applications.
Xpra is "rootless" or "seamless": programs you run under
it show up on your desktop as regular programs, managed by your regular window manager.
Sessions can be accessed over SSH, or password protected over plain TCP sockets.
Xpra is usable over reasonably slow links and does its best to adapt
to changing network bandwidth limits. (see also adaptive JPEG mode)
Xpra is open-source (GPLv2+), multi-platform and multi-language,
with current clients written in Python and Java.

On the machine which will export the application (xterm in this example):
> xpra start :100 --start-child=xterm

We can then attach to this session from the same machine, with:
> xpra attach :100

If connecting from a remote machine, you would use something like (or you can also use the GUI):
> xpra attach ssh:serverhostname:100


%prep
%setup
# instal service file in anyway
sed -i "s|/bin/systemctl|/bin/true|g" setup.py

%build
%if_with ffmpeg_static
export PKG_CONFIG_PATH=%_libdir/ffmpeg-static/%_lib/pkgconfig/
%endif

%python3_build_debug --without-strict %py_flags %_smp_mflags

%install
%python3_install %py_flags
mkdir -p %buildroot/%_tmpfilesdir/
mv -f %buildroot/usr/lib/tmpfiles.d/xpra.conf %buildroot/%_tmpfilesdir/
mkdir -p %buildroot%_udevrulesdir/
mv -f %buildroot/usr/lib/udev/rules.d/71-xpra-virtual-pointer.rules %buildroot%_udevrulesdir/
#install -m644 -D service/xpra.service %buildroot%_unitdir/%name.service
mkdir -p %buildroot%_sysconfdir/%name/ssl/{certs,private}

# TODO
rm -v %buildroot/usr/lib/sysusers.d/xpra.conf

# remove obsoleted (python2 only) examples
rm -rv %buildroot/%python3_sitelibdir/xpra/client/gtk_base/example/

%pre
%_sbindir/groupadd -r -f xpra &>/dev/null ||:

%post
# Create SSL certificate for xpra
SSLDIR=%_sysconfdir/%name/ssl cert-sh generate xpra ||:
ln -fs %_sysconfdir/%name/ssl/private/xpra.pem %_sysconfdir/%name/ssl-cert.pem

%files
%dir %_sysconfdir/%name/
%config(noreplace) %_sysconfdir/%name/*
%_bindir/xpra
%_bindir/xpra_launcher
%_bindir/run_scaled
#_bindir/xpra_signal_listener
#_bindir/xpra_udev_product_version
#_libexecdir/%name/
%python3_sitelibdir/*
%_desktopdir/*
%_iconsdir/*
%_man1dir/*
/usr/libexec/%name/
#_datadir/parti/
#_datadir/wimpiggy/
%_docdir/%name/
%_datadir/xpra/
%_tmpfilesdir/xpra.conf
%_datadir/metainfo/xpra.appdata.xml
%_K4xdg_mime/application-x-xpraconfig.xml
%_cupslibdir/backend/xpraforwarder
%_sysconfigdir/%name
%_sysconfdir/pam.d/%name
#_sysconfdir/init.d/%name
%_unitdir/%name.service
%_unitdir/%name.socket
%_udevrulesdir/71-xpra-virtual-pointer.rules
%_sysconfdir/dbus-1/system.d/xpra.conf
%_sysconfdir/X11/xorg.conf.d/90-xpra-virtual.conf
%dir %_sysconfdir/%name/ssl/certs
%attr(0700, root, root) %dir %_sysconfdir/%name/ssl/private

%changelog
