#------------------------------------------------------------------------------
#   browser.spec
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
#   Prologue information
#------------------------------------------------------------------------------
Summary: Yandex Browser
License: ALT-YANDEX-BROWSER
Name: yandex-browser-stable
Version: 25.2.4.1000
Release: alt1
Group: Networking/WWW
Vendor: YANDEX LLC
Url: http://browser.yandex.ru/

ExclusiveArch: x86_64
Source0: x86_64-linux.tar.gz
Source1: common.tar.gz
Provides: yandex-browser = %{version}
Provides: webclient
Buildrequires: at-spi2-atk, libalsa, libat-spi2-core, libatk, libcairo, libcups
Buildrequires: libdbus, libdrm, libexpat, libgbm, libgio, libnspr, libnss
Buildrequires: libpango, libX11, libXcomposite, libXdamage, libXext, libXfixes
Buildrequires: libXrandr, libxcb, libxkbcommon
Buildrequires: libwayland-client
Buildrequires: libqt5-core, libqt5-widgets, libqt5-gui
Requires: ca-certificates, ffmpeg-plugin-browser, gst-libav, gst-plugins-bad, gst-plugins-base, gst-plugins-good, gstreamer, xdg-utils, fonts-ttf-google-noto-emoji-color
Requires(post): %{_sbindir}/update-alternatives
Requires(preun): %{_sbindir}/update-alternatives


# The prefix is pretty important; RPM uses this to figure out
# how to make a package relocatable

# =============== END Prologue ===============

#------------------------------------------------------------------------------
#   Description
#------------------------------------------------------------------------------
%Description
The web browser from Yandex

Yandex Browser is a browser that combines a minimal design with sophisticated technology to make the web faster, safer, and easier. Based on Chromium 132.0.6834.

%Description -l ru_RU.UTF-8
Веб-браузер от Яндекса

Яндекс Браузер - безопасный, простой в настройке и управлении браузер на базе Chromium 132.0.6834.

#------------------------------------------------------------------------------
#   Prep rule - Prepare sources before build
#------------------------------------------------------------------------------
%prep
%setup -c
%setup -T -D -a 1

#------------------------------------------------------------------------------
#   Build rule - How to make the package
#------------------------------------------------------------------------------
%build

# =============== END build ===============

#------------------------------------------------------------------------------
#       Installation rule - how to install it (note that it
#   gets installed into a temp directory given by %buildroot)
#------------------------------------------------------------------------------
%install
# TODO(palar): remove it when libabt-bindings.so is fixed
%set_verify_elf_method textrel=relaxed
%add_findreq_skiplist %_libdir/yandex/browser/xdg-*

if [ -z "%{_builddir}/%{name}-%{version}" -o ! \
     -d "%{_builddir}/%{name}-%{version}" ] ; then
    exit 1
fi

if [ -z "%{_builddir}/%{name}-%{version}" -o ! \
     -d "%{_builddir}/%{name}-%{version}/%{_libdir}/yandex/browser" ] ; then
    exit 1
fi

install -m 755 -d \
  "%buildroot/usr"
# This is hard coded for now
cp -a "%{_builddir}/%{name}-%{version}/usr/" "%buildroot/"

if [ -d "%{_builddir}/%{name}-%{version}%{_sysconfdir}/" ]; then
  install -m 755 -d \
    "%buildroot%{_sysconfdir}"
  cp -a "%{_builddir}/%{name}-%{version}%{_sysconfdir}/" "%buildroot/"
fi

# install icons
for size in 16 24 32 48 64 128 256; do
  install -Dm644 "%{_builddir}/%{name}-%{version}/%{_libdir}/yandex/browser/product_logo_$size.png" \
    "%buildroot/%_iconsdir/hicolor/${size}x${size}/apps/yandex-browser.png"
done

mkdir -p %buildroot/%{_datadir}/kio_desktop/DesktopLinks

cp -a \
    "%{_builddir}/%{name}-%{version}/%{_datadir}/applications/yandex-browser.desktop" \
    "%buildroot/%{_datadir}/kio_desktop/DesktopLinks/yandex-browser.desktop"

chmod a+x  "%buildroot/%{_datadir}/kio_desktop/DesktopLinks/yandex-browser.desktop"

# Set alternative to xbrowser
mkdir -p -- %buildroot%_altdir
cat >%buildroot%_altdir/%name <<EOF
%_bindir/xbrowser       %_bindir/%name  150
%_bindir/x-www-browser  %_bindir/%name  150
EOF

# =============== END install ===============

#------------------------------------------------------------------------------
#   Rule to clean up a build
#------------------------------------------------------------------------------
%clean

# =============== END clean ===============

#------------------------------------------------------------------------------
#   Files listing.
#------------------------------------------------------------------------------
%files
#%doc README
%defattr(-,root,root)
%{_datadir}/kio_desktop/DesktopLinks/yandex-browser.desktop

# We cheat and just let RPM figure it out for us; everything we install
# should go under this prefix anyways.
%{_libdir}/yandex/browser
%attr(4711,root,root) %{_libdir}/yandex/browser/yandex_browser-sandbox

%{_sysconfdir}/xdg/autostart/yandex-browser_user_setup.desktop
%{_bindir}/yandex-browser-stable
%{_datadir}/appdata/yandex-browser.appdata.xml
%{_datadir}/applications/yandex-browser.desktop
%{_datadir}/gnome-control-center/default-apps/yandex-browser.xml
%_altdir/%name
%_iconsdir/hicolor/*/apps/*.png
%docdir %{_mandir}/man1
%{_mandir}/man1/yandex-browser.1.xz
%{_mandir}/man1/yandex-browser-stable.1.xz

# =============== END files ===============
#------------------------------------------------------------------------------
#   Post installation script
#------------------------------------------------------------------------------
%post
#partner config
maybe_create_dir() {
  if [ ! -d "$1" ]; then
    mkdir -p "$1"
  fi
}
store_partner_file() {
  if [ -z "$1" ]; then
    local source_file="%{_libdir}/yandex/browser/$2"
  else
    local source_file="%{_libdir}/yandex/browser/$1/$2"
  fi
  local destination_dir="%{_localstatedir}/yandex/browser/$1"
  if [ -f "${source_file}" ]; then
    maybe_create_dir "${destination_dir}"
    cp -f "${source_file}" "${destination_dir}"
  fi
}
remove_partner_storage() {
  local partner_storage_dir="%{_localstatedir}/yandex/browser"
  if [ -d "${partner_storage_dir}" ]; then
    rm -rf "${partner_storage_dir}"
  fi
}
store_partner_files() {
  local source_dir="%{_libdir}/yandex/browser/$1"
  local destination_dir="%{_localstatedir}/yandex/browser/$1"
  if [ -d "${source_dir}" ]; then
    maybe_create_dir "${destination_dir}"
    find "${source_dir}" -maxdepth 1 -type f -name "$2" -exec cp -f {} "${destination_dir}" \;
  fi
}
store_partner_data() {
  local partner_config="%{_libdir}/yandex/browser/partner_config"
  if [ -f "${partner_config}" ]; then
    remove_partner_storage
    store_partner_file "" "partner_config"
    store_partner_file "" "distrib_info"
    store_partner_file "" "master_preferences"
    store_partner_file "resources/configs" "all_zip"
    store_partner_file "Extensions" "*.*"
    store_partner_files "resources" "clids*.xml"
    store_partner_files "resources" "tablo*"
    store_partner_files "resources" "*.png"
    store_partner_files "resources" "*.svg"
    store_partner_files "resources/wallpapers" "*"
  fi
}

store_partner_data
exit 0
# =============== END post ===============

#------------------------------------------------------------------------------
#   Pre uninstallation script
#------------------------------------------------------------------------------
%preun

remove_partner_storage() {
  local partner_storage_dir="%{_localstatedir}/yandex/browser"
  if [ -d "${partner_storage_dir}" ]; then
    rm -rf "${partner_storage_dir}"
  fi
}
if [ "$1" -eq "0" ]; then
  remove_partner_storage
fi
exit 0
# =============== END preun ===============

%changelog
