%define zabbix_user	zabbix
%define zabbix_group	zabbix
%define zabbix_home	/dev/null
%define svnrev		a2d0368f1b9

%def_with pgsql
%def_enable java
%def_with ssh2
%def_with unixodbc

%def_enable ipv6
%def_enable agent2
%def_enable webservice

%ifndef _unitdir
%define _unitdir %systemd_unitdir
%endif

Name: zabbix
Version: 7.0.19
Release: alt0.p10.1
Epoch: 1

Summary: A network monitor
License: AGPL-3.0-only
Group: Monitoring

Url: http://www.zabbix.com

# http://heanet.dl.sourceforge.net/sourceforge/%name/%name-%version.tar.gz
Source0: %name-%version.tar
Patch0: %name-%version-alt.patch

BuildRequires(pre): libelf-devel rpm-build-webserver-common rpm-macros-apache2
%{?_enable_agent2:BuildRequires(pre): rpm-build-golang}
%{?_enable_webservice:BuildRequires(pre): rpm-build-golang}

# Automatically added by buildreq on Thu Nov 02 2017 (-bi)
# optimized out: elfutils glibc-kernheaders-generic glibc-kernheaders-x86 libcom_err-devel libkrb5-devel libnet-snmp30 libp11-kit libpq-devel libsasl2-3 libssl-devel net-snmp-config perl pkg-config python-base python3 rpm-build-python3 xz
BuildRequires: libcurl-devel libelf-devel libevent-devel libiksemel-devel libldap-devel libmysqlclient-devel libnet-snmp-devel libopenipmi-devel libpcre-devel libsqlite3-devel libxml2-devel python3-base
BuildRequires: perl-Switch zlib-devel /proc
%if_with ssh2
BuildRequires: libssh2-devel
%endif
%if_with unixodbc
BuildRequires: libunixODBC-devel
%endif

%{?_enable_java:BuildRequires: java-11-devel rpm-build-java}

%if_with pgsql
BuildRequires: libpq-devel
%endif

%package common
Summary: %name network monitor (common stuff)
Group: Monitoring
Provides: %_sysconfdir/%name
Provides: %_logdir/%name
BuildArch: noarch

%package common-database-sqlite3
Summary: %name common database stuff (for sqlite3)
Group: Monitoring
BuildArch: noarch

%package common-database-mysql
Summary: %name common database stuff (for mysql)
Group: Monitoring
BuildArch: noarch

%if_with pgsql
%package common-database-pgsql
Summary: %name common database stuff (for postgresql)
Group: Monitoring
BuildArch: noarch
%endif

%package server-common
Summary: %name network monitor (server common stuff)
Group: Monitoring
Requires: %name-common = %EVR

%package server-mysql
Summary: %name network monitor (server, compiled with MySQL support)
Group: Monitoring
Requires: %name-server-common = %EVR
Requires: %name-common-database-mysql = %EVR
Requires: %_sbindir/fping

%if_with pgsql
%package server-pgsql
Summary: %name network monitor (server, compiled with PostgreSQL support)
Group: Monitoring
Requires: %name-server-common = %EVR
Requires: %name-common-database-pgsql = %EVR
Requires: %_sbindir/fping
%endif

%package agent
Summary: %name agent
Group: Monitoring
Requires: %name-common = %EVR
Requires: %name-agent-sudo

%if_enabled agent2
%package agent2
Summary: %name agent2
Group: Monitoring
Requires: %name-common = %EVR
Requires: %name-agent-sudo
%endif

%if_enabled webservice
%package web-service
Summary: %name web service
Group: Monitoring
Requires: %name-common = %EVR
%endif

%package agent-sudo
Summary: sudo entry for %name agent
Group: Monitoring
BuildArch: noarch
Requires: %name-common = %EVR

%package proxy
Summary: %name proxy with Sqlite3 support
Group: Monitoring
Requires: %name-proxy-common = %EVR
Requires: %name-common-database-sqlite3 = %EVR
Conflicts: %name-proxy-pgsql

%if_with pgsql
%package proxy-pgsql
Summary: %name proxy with PostgreSQL support
Group: Monitoring
Requires: %name-proxy-common = %EVR
Requires: %name-common-database-pgsql = %EVR
Conflicts: %name-proxy
%endif

%package proxy-common
Summary: %name proxy common files
Group: Monitoring
Requires: %name-common = %EVR
Requires: %_sbindir/fping
BuildArch: noarch

%if_enabled java
%package java-gateway
Summary: %name java gateway
Group: Monitoring
Requires: %name-common = %EVR
Requires: jre-11-openjdk
%filter_from_requires /^\/etc\/sysconfig\/network/d
%filter_from_requires /^\/etc\/sysconfig\/zabbix-java-gateway/d
%endif

%package phpfrontend-engine
Summary: zabbix web frontend (php)
Group: Monitoring
Requires: php-engine
BuildArch: noarch

%package phpfrontend-php8.0
Summary: zabbix web frontend, edition for php8.0
Group: Monitoring
Requires: php8.0-gd php8.0-libs php8.0-mbstring php8.0-mysqli php8.0-openssl php8.0-pgsql php8.0-sockets
Requires: php8.0-xmlreader php8.0-curl php8.0-ldap
Requires: zabbix-phpfrontend-engine = %EVR
BuildArch: noarch


%package phpfrontend-php8.1
Summary: zabbix web frontend, edition for php8.1
Group: Monitoring
Requires: php8.1-gd php8.1-libs php8.1-mbstring php8.1-mysqli php8.1-openssl php8.1-pgsql php8.1-sockets
Requires: php8.1-xmlreader php8.1-curl php8.1-ldap
Requires: zabbix-phpfrontend-engine = %EVR
BuildArch: noarch

%package phpfrontend-php8.2
Summary: zabbix web frontend, edition for php8.2
Group: Monitoring
Requires: php8.2-gd php8.2-libs php8.2-mbstring php8.2-mysqli php8.2-openssl php8.2-pgsql php8.2-sockets
Requires: php8.2-xmlreader php8.2-curl php8.2-ldap
Requires: zabbix-phpfrontend-engine = %EVR
BuildArch: noarch

%package phpfrontend-apache2
Summary: %name-phpfrontend's apache2 config files
Group: Monitoring
Requires: apache2-base
BuildArch: noarch

%package phpfrontend-apache2-mod_php8.0
Summary: Requirements for the use of apache2-mod_php8.0
Group: Monitoring
Requires: %name-phpfrontend-apache2
Requires: apache2-httpd-prefork-like
Requires: apache2-mod_php8.0
BuildArch: noarch

%package phpfrontend-apache2-mod_php8.1
Summary: Requirements for the use of apache2-mod_php8.1
Group: Monitoring
Requires: %name-phpfrontend-apache2
Requires: apache2-httpd-prefork-like
Requires: apache2-mod_php8.1
BuildArch: noarch

%package phpfrontend-apache2-mod_php8.2
Summary: Requirements for the use of apache2-mod_php8.2
Group: Monitoring
Requires: %name-phpfrontend-apache2
Requires: apache2-httpd-prefork-like
Requires: apache2-mod_php8.2
BuildArch: noarch

%package phpfrontend-nginx
Summary: %name-phpfrontend's nginx config files
Group: Monitoring
Requires: nginx
Requires: %name-common
BuildArch: noarch

%package phpfrontend-nginx-php8.0-fpm-fcgi
Summary: Requirements for the use of php8.0-fpm-fcgi
Group: Monitoring
Requires: %name-phpfrontend-nginx
Requires: %name-phpfrontend-php8.0
Requires: php8.0-fpm-fcgi
BuildArch: noarch

%package phpfrontend-nginx-php8.1-fpm-fcgi
Summary: Requirements for the use of php8.1-fpm-fcgi
Group: Monitoring
Requires: %name-phpfrontend-nginx
Requires: %name-phpfrontend-php8.1
Requires: php8.1-fpm-fcgi
BuildArch: noarch

%package phpfrontend-nginx-php8.2-fpm-fcgi
Summary: Requirements for the use of php8.2-fpm-fcgi
Group: Monitoring
Requires: %name-phpfrontend-nginx
Requires: %name-phpfrontend-php8.2
Requires: php8.2-fpm-fcgi
BuildArch: noarch

%package doc
Summary: %name network monitor documentation (README, ChangeLog, Manual)
Group: Monitoring
BuildArch: noarch

%package contrib
Summary: %name network monitor (additional scripts)
Group: Monitoring
BuildArch: noarch

%package source
Summary: %name network monitor (files for zabbix modules)
Group: Development/C
BuildArch: noarch

%description
ZABBIX is software for monitoring of your applications, network and servers.
ZABBIX supports both polling and trapping techniques to collect data from
monitored hosts. A flexible notification mechanism allows easy and quickly
configure different types of notifications for pre-defined events.

%description common
Common files and docs for zabbix network monitor

ZABBIX is software for monitoring of your applications, network and servers.
ZABBIX supports both polling and trapping techniques to collect data from
monitored hosts. A flexible notification mechanism allows easy and quickly
configure different types of notifications for pre-defined events.

%description common-database-sqlite3
common stuff for zabbix sqlite3 databases.

%description common-database-mysql
common stuff for zabbix mysql databases.

%if_with pgsql
%description common-database-pgsql
common stuff for zabbix postgresql databases.
%endif

%description server-common
common stuff for zabbix server

%description server-mysql
zabbix server, compiled with MySQL support

ZABBIX is software for monitoring of your applications, network and servers.
ZABBIX supports both polling and trapping techniques to collect data from
monitored hosts. A flexible notification mechanism allows easy and quickly
configure different types of notifications for pre-defined events.

%if_with pgsql
%description server-pgsql
zabbix server, compiled with PostgreSQL support
%endif

%description proxy
zabbix network monitor proxy daemon.

ZABBIX is software for monitoring of your applications, network and servers.
ZABBIX supports both polling and trapping techniques to collect data from
monitored hosts. A flexible notification mechanism allows easy and quickly
configure different types of notifications for pre-defined events.

%if_with pgsql
%description proxy-pgsql
zabbix network monitor proxy daemon with PostgreSQL support.

ZABBIX is software for monitoring of your applications, network and servers.
ZABBIX supports both polling and trapping techniques to collect data from
monitored hosts. A flexible notification mechanism allows easy and quickly
configure different types of notifications for pre-defined events.
%endif

%description proxy-common
zabbix network monitor proxy daemon.

ZABBIX is software for monitoring of your applications, network and servers.
ZABBIX supports both polling and trapping techniques to collect data from
monitored hosts. A flexible notification mechanism allows easy and quickly
configure different types of notifications for pre-defined events.

%if_enabled java
%description java-gateway
Zabbix java gateway
%endif

%description agent
zabbix network monitor agent.

%if_enabled agent2
%description agent2
zabbix network monitor agent2.

ZABBIX is software for monitoring of your applications, network and servers.
ZABBIX supports both polling and trapping techniques to collect data from
monitored hosts. A flexible notification mechanism allows easy and quickly
configure different types of notifications for pre-defined events.
%endif

%if_enabled webservice
%description web-service
Zabbix web servce for performing various tasks using headless web browser.
%endif

%description agent-sudo
Sudo entry for zabbix agent.

%description phpfrontend-apache2
zabbix's apache2 config files

%description phpfrontend-apache2-mod_php8.0
Contains requirements for the use of apache2-mod_php8.0
in to zabbix phpfrontend

%description phpfrontend-apache2-mod_php8.1
Contains requirements for the use of apache2-mod_php8.1
in to zabbix phpfrontend

%description phpfrontend-apache2-mod_php8.2
Contains requirements for the use of apache2-mod_php8.2
in to zabbix phpfrontend

%description phpfrontend-nginx
zabbix's nginx config files

%description phpfrontend-nginx-php8.0-fpm-fcgi
Contains requirements for the use of php8.0-fpm-fcgi
in to zabbix phpfrontend

%description phpfrontend-nginx-php8.1-fpm-fcgi
Contains requirements for the use of php8.1-fpm-fcgi
in to zabbix phpfrontend

%description phpfrontend-nginx-php8.2-fpm-fcgi
Contains requirements for the use of php8.2-fpm-fcgi
in to zabbix phpfrontend

%description phpfrontend-engine
a php frontend for zabbix - core

%description phpfrontend-php8.0
zabbix web frontend, edition for php8.0

%description phpfrontend-php8.1
zabbix web frontend, edition for php8.1

%description phpfrontend-php8.2
zabbix web frontend, edition for php8.2

%description doc
%name network monitor (README, ChangeLog)

%description contrib
%name network monitor (additional scripts)

%description source
%name network monitor (files for zabbix modules)

%prep
%setup
%patch0 -p1

%build
%ifarch armh
export CFLAGS=-fPIC
%endif
# fix ZABBIX_REVISION
sed -i -e "s,{ZABBIX_REVISION},%svnrev," include/version.h src/zabbix_java/src/com/zabbix/gateway/GeneralInformation.java src/go/pkg/version/version.go

%autoreconf

%configure --with-mysql \
	--with-net-snmp \
	--enable-server \
	%{subst_enable ipv6} \
	--with-ldap \
	--with-libcurl \
	--with-libxml2 \
	--with-openipmi \
	--with-openssl \
	%{subst_with ssh2} \
	%{subst_with unixodbc} \
	--sysconfdir=/etc/zabbix
%make_build dbschema
%make_build

mv src/%{name}_server/%{name}_server src/%{name}_server/%{name}_mysql
%make clean

%if_with pgsql
%configure --with-postgresql \
	--with-net-snmp \
	--enable-server \
	%{subst_enable ipv6} \
	--with-ldap \
	--with-libcurl \
	--with-libxml2 \
	--with-openipmi \
	--with-openssl \
	%{subst_with ssh2} \
	%{subst_with unixodbc} \
	--sysconfdir=/etc/zabbix
%make_build dbschema
%make_build

mv src/%{name}_server/%{name}_server src/%{name}_server/%{name}_pgsql
%make clean

%configure --with-postgresql \
	--enable-proxy \
	%{subst_enable ipv6} \
	--enable-agent \
	%{subst_enable java} \
	--with-libcurl \
	--with-libxml2 \
	--with-net-snmp \
	--with-ldap \
	--with-openipmi \
	--with-openssl \
	%{subst_with ssh2} \
	%{subst_with unixodbc} \
	--sysconfdir=/etc/zabbix
%make_build

mv src/%{name}_proxy/%{name}_proxy src/%{name}_proxy/%{name}_proxy_pgsql
%make clean
%endif

export GOFLAGS="-mod=vendor"

%configure --with-sqlite3 \
	--enable-proxy \
	%{subst_enable ipv6} \
	--enable-agent \
	%{subst_enable agent2} \
	%{subst_enable webservice} \
	%{subst_enable java} \
	--with-libcurl \
	--with-libxml2 \
	--with-net-snmp \
	--with-ldap \
	--with-openipmi \
	--with-openssl \
	%{subst_with ssh2} \
	%{subst_with unixodbc} \
	--sysconfdir=/etc/zabbix
%make_build dbschema
%make_build

# adjust in several files /home/zabbix
find conf src/go/conf -type f -print0 | xargs -0 sed -i \
	-e "s,/home/zabbix/bin,/usr/sbin,g" \
	-e "s,PidFile=/tmp,PidFile=%_var/run/zabbix,g" \
	-e "s,LogFile=/tmp,LogFile=%_logdir/zabbix,g" \
	-e "s,/home/zabbix/lock,%_var/lock/subsys/zabbix,g" \
	-e "s,/tmp/mysql.sock,%_localstatedir/mysql/mysql.sock,g" \
	-e "s,Include=/usr/local/etc/zabbix_agentd.conf.d/,Include=%_sysconfdir/%name/zabbix_agentd.conf.d/,g" --

%install
# Generate *.mo files
for pofile in `find ui/locale -type f -name '*.po'`
do
    msgfmt --use-fuzzy -c -o ${pofile%%po}mo $pofile
done

export GOFLAGS="-mod=vendor"
%makeinstall

# create directory structure
install -dm1775 %buildroot%_logdir/%name
install -dm0755 %buildroot%_sbindir
install -dm0750 %buildroot%_sysconfdir/%name
install -dm0750 %buildroot%_sysconfdir/%name/zabbix_agentd.conf.d
install -dm0755 %buildroot%webserver_webappsdir/%name
install -dm0755 %buildroot%_unitdir
install -dm0755 %buildroot%_includedir/%name

# binaries
install -m0755 src/%{name}_*/%{name}_{mysql,agentd} %buildroot%_sbindir
%if_with pgsql
install -m0755 src/%{name}_server/%{name}_pgsql %buildroot%_sbindir
install -m0755 src/%{name}_proxy/%{name}_proxy_pgsql %buildroot%_sbindir
%endif

# conf files
install -m0640 conf/%{name}_{server,agentd,proxy}.conf %buildroot%_sysconfdir/%name
install -Dpm 644 sources/%name-tmpfiles.conf %buildroot/lib/tmpfiles.d/%name.conf
%if_enabled agent2
install -dm0750 %buildroot%_sysconfdir/%name/zabbix_agent2.conf.d
install -m0640 src/go/conf/zabbix_agent2.conf %buildroot%_sysconfdir/%name/
install -dm0750 %buildroot%_sysconfdir/%name/zabbix_agent2.conf.d/plugins.d
install -m0640 src/go/conf/zabbix_agent2.d/plugins.d/*.conf %buildroot%_sysconfdir/%name/zabbix_agent2.conf.d/plugins.d/
%endif

# frontends
mv ui/locale/*.sh .
cp -r ui %buildroot%webserver_webappsdir/%name/

# apache2 config
install -pDm0644 sources/%name.conf %buildroot%_sysconfdir/httpd2/conf/addon.d/A.%name.conf

# nginx config
install -pDm0644 sources/%name.nginx %buildroot%_sysconfdir/%name/%{name}_nginx.conf

# start scripts
install -pDm0755 sources/%{name}_agentd.init %buildroot%_initdir/%{name}_agentd
install -pDm0644 sources/%{name}_agentd.service %buildroot%_unitdir/%{name}_agentd.service
install -pDm0644 sources/zabbix_server %buildroot%_sysconfdir/sysconfig/zabbix_server
%if_enabled agent2
install -pDm0755 sources/%{name}_agent2.init %buildroot%_initdir/%{name}_agent2
install -pDm0644 sources/%{name}_agent2.service %buildroot%_unitdir/%{name}_agent2.service
%endif
%if_with pgsql
install -pDm0755 sources/%{name}_pgsql.init %buildroot%_initdir/%{name}_pgsql
install -pDm0644 sources/%{name}_pgsql.service %buildroot%_unitdir/%{name}_pgsql.service
install -pDm0755 sources/%{name}_proxy_pgsql.init %buildroot%_initdir/%{name}_proxy_pgsql
install -pDm0644 sources/%{name}_proxy_pgsql.service %buildroot%_unitdir/%{name}_proxy_pgsql.service
%endif
install -pDm0755 sources/%{name}_mysql.init %buildroot%_initdir/%{name}_mysql
install -pDm0644 sources/%{name}_mysql.service %buildroot%_unitdir/%{name}_mysql.service
install -pDm0755 sources/%{name}_proxy.init %buildroot%_initdir/%{name}_proxy
install -pDm0644 sources/%{name}_proxy.service %buildroot%_unitdir/%{name}_proxy.service
%if_enabled java
install -pDm0755 sources/%{name}_java_gateway.init %buildroot%_initdir/%{name}_java_gateway
install -pDm0644 sources/%{name}_java_gateway.service %buildroot%_unitdir/%{name}_java_gateway.service
%endif
%if_enabled webservice
install -m0640 src/go/conf/zabbix_web_service.conf %buildroot%_sysconfdir/%name/
install -pDm0755 sources/%{name}_web_service.init %buildroot%_initdir/%{name}_web_service
install -pDm0644 sources/%{name}_web_service.service %buildroot%_unitdir/%{name}_web_service.service
%endif

# sudo entry
install -pDm0400 sources/%name.sudo %buildroot%_sysconfdir/sudoers.d/%name

# include files
cp -r include/* %buildroot%_includedir/%name

%if_enabled java
# delete unnecessary files from java gateway
rm %buildroot%_sbindir/zabbix_java/settings.sh
rm %buildroot%_sbindir/zabbix_java/startup.sh
rm %buildroot%_sbindir/zabbix_java/shutdown.sh

mv %buildroot%_sbindir/zabbix_java/lib/logback.xml %buildroot%_sysconfdir/zabbix/zabbix_java_gateway_logback.xml
rm %buildroot%_sbindir/zabbix_java/lib/logback-console.xml

mkdir -p %buildroot%_javadir
mv %buildroot%_sbindir/zabbix_java %buildroot%_javadir/zabbix-java-gateway
install -m 0755 -p sources/zabbix_java_gateway-sysd %buildroot%_sbindir/zabbix_java_gateway

cat src/zabbix_java/settings.sh | sed \
        -e 's|^PID_FILE=.*|PID_FILE="/var/run/zabbix/zabbix_java.pid"|g' \
        -e '/^# TIMEOUT=/a \\nTIMEOUT=3' \
        > %buildroot%_sysconfdir/zabbix/zabbix_java_gateway.conf
%endif

# ChangeLog
bzip2 ChangeLog

# remove Makefile* files from database/*
find ./database/postgresql  -name 'Makefile*' -exec rm '{}' ';'

%pre common
/usr/sbin/groupadd -r -f %zabbix_group ||:
/usr/sbin/useradd -g %zabbix_group -G proc -c 'Zabbix' \
	-d %zabbix_home -s /dev/null -r %zabbix_user >/dev/null 2>&1 ||:
/usr/sbin/usermod -a -G netadmin %zabbix_user ||:
echo "########################################################################"
echo "                        Attention!"
echo "########################################################################"
echo " Notice:"
echo " Zabbix Server and Zabbix Proxy use fping, run this command for correct work:"
echo " # control fping netadmin"

%pre server-mysql
echo "########################################################################"
echo "              Attention! Zabbix upgrade to %version"
echo "########################################################################"
echo " Notice:"
echo " On MySQL and MariaDB, this requires GLOBAL"
echo " log_bin_trust_function_creators = 1 to be set if binary logging is"
echo " enabled and there is no superuser privileges and"
echo " log_bin_trust_function_creators = 1 is not set in MySQL configuration"
echo " file. To set the variable using MySQL console, run:"
echo ""
echo " mysql> SET GLOBAL log_bin_trust_function_creators = 1;"
echo ""
echo " Once the upgrade has been successfully completed,"
echo " log_bin_trust_function_creators can be disabled:"
echo ""
echo " mysql> SET GLOBAL log_bin_trust_function_creators = 0;"
echo ""
echo "########################################################################"

%post server-mysql
%post_service zabbix_mysql

%preun server-mysql
%preun_service zabbix_mysql
%if_with pgsql
%pre server-pgsql
echo "########################################################################"
echo "              Attention! Zabbix upgrade to %version"
echo "########################################################################"
echo "# Notice: zabbix-server-pgsql require PostgreSQL 13 or newer!          #"
echo "########################################################################"

%post server-pgsql
%post_service zabbix_pgsql

%preun server-pgsql
%preun_service zabbix_pgsql
%endif

%post proxy
%post_service zabbix_proxy

%preun proxy
%preun_service zabbix_proxy

%if_with pgsql
%pre proxy-pgsql
echo "########################################################################"
echo "              Attention! Zabbix upgrade to %version"
echo "########################################################################"
echo "# Notice: zabbix-server-pgsql require PostgreSQL 13 or newer!          #"
echo "########################################################################"

%post proxy-pgsql
%post_service zabbix_proxy_pgsql

%preun proxy-pgsql
%preun_service zabbix_proxy_pgsql
%endif

%if_enabled java
%post java-gateway
%post_service zabbix_java_gateway

%preun java-gateway
%preun_service zabbix_java_gateway
%endif

%post agent
if [ $1 -eq 1 ]; then
	sed -i -e "s,Hostname=Zabbix server,Hostname=$HOSTNAME,g" \
	%_sysconfdir/%name/%{name}_agentd.conf
fi
%post_service zabbix_agentd

%post agent-sudo
if [ $1 -eq 1 ]; then
	gpasswd -a %zabbix_user wheel
fi

%preun agent
%preun_service zabbix_agentd


%if_with agent2
%post agent2
if [ $1 -eq 1 ]; then
	sed -i -e "s,Hostname=Zabbix server,Hostname=$HOSTNAME,g" \
	%_sysconfdir/%name/%{name}_agent2.conf
fi
%post_service zabbix_agent2

%preun agent2
%preun_service zabbix_agent2
%endif

%post phpfrontend-engine
if [ -f %webserver_webappsdir/%name/frontends/php/conf/zabbix.conf.php -a ! -f %webserver_webappsdir/%name/ui/conf/zabbix.conf.php ]
then
    cp -p %webserver_webappsdir/%name/frontends/php/conf/zabbix.conf.php %webserver_webappsdir/%name/ui/conf/
fi

%files common
%dir %attr(1775,root,%zabbix_group) %_logdir/%name
%dir %_sysconfdir/%name
/lib/tmpfiles.d/*

%files common-database-sqlite3
%doc database/sqlite3/*.sql

%files common-database-mysql
%doc database/mysql/*.sql
%doc database/mysql/option-patches/*.sql

%if_with pgsql
%files common-database-pgsql
%doc database/postgresql/*.sql database/postgresql/timescaledb
%endif

%files server-common
%_bindir/%{name}_get
%_bindir/%{name}_js
%config(noreplace) %_sysconfdir/sysconfig/zabbix_server
%config(noreplace) %attr(0640,root,%zabbix_group) %_sysconfdir/%name/%{name}_server.conf
%_man1dir/%{name}_get.*

%files server-mysql
%_sbindir/%{name}_mysql
%_initdir/%{name}_mysql
%_unitdir/*mysql*

%if_with pgsql
%files server-pgsql
%_sbindir/%{name}_pgsql
%_initdir/%{name}_pgsql
%_unitdir/*pgsql*
%exclude %_unitdir/*proxy_pgsql*
%endif

%files proxy-common
%config(noreplace) %attr(0640,root,%zabbix_group) %_sysconfdir/%name/%{name}_proxy.conf
%_man8dir/%{name}_proxy.*

%files proxy
%_sbindir/%{name}_proxy
%_initdir/%{name}_proxy
%_unitdir/*proxy*
%if_with pgsql
%exclude %_unitdir/*proxy_pgsql*
%endif

%if_with pgsql
%files proxy-pgsql
%_sbindir/%{name}_proxy_pgsql
%_initdir/%{name}_proxy_pgsql
%_unitdir/*proxy_pgsql*
%endif

%if_enabled java
%files java-gateway
%_sbindir/%{name}_java_gateway
%_initdir/%{name}_java_gateway
%_unitdir/*java_gateway*
%config(noreplace) %attr(0640,root,%zabbix_group) %_sysconfdir/%name/%{name}_java_gateway.conf
%config(noreplace) %attr(0640,root,%zabbix_group) %_sysconfdir/%name/%{name}_java_gateway_logback.xml
%_javadir/*
%endif

%files agent
%config(noreplace) %attr(0640,root,%zabbix_group) %_sysconfdir/%name/%{name}_agentd.conf
%dir %attr(0750,root,%zabbix_group) %_sysconfdir/%name/zabbix_agentd.conf.d
%_initdir/%{name}_agentd
%_unitdir/*agentd*
%_sbindir/%{name}_agentd
%_bindir/%{name}_sender
%_man8dir/%{name}_agentd.*
%_man1dir/%{name}_sender.*

%if_enabled agent2
%files agent2
%config(noreplace) %attr(0640,root,%zabbix_group) %_sysconfdir/%name/%{name}_agent2.conf
%dir %attr(0750,root,%zabbix_group) %_sysconfdir/%name/zabbix_agent2.conf.d
%dir %attr(0750,root,%zabbix_group) %_sysconfdir/%name/zabbix_agent2.conf.d/plugins.d
%config(noreplace) %attr(0640,root,%zabbix_group) %_sysconfdir/%name/zabbix_agent2.conf.d/plugins.d/*
%_initdir/%{name}_agent2
%_unitdir/*agent2*
%_sbindir/%{name}_agent2
%_man8dir/%{name}_agent2.*
%endif

%if_enabled webservice
%files web-service
%config(noreplace) %attr(0640,root,%zabbix_group) %_sysconfdir/%name/%{name}_web_service.conf
%_initdir/%{name}_web_service
%_unitdir/*_web_service*
%_sbindir/%{name}_web_service
%_man8dir/%{name}_web_service.*
%endif

%files agent-sudo
%config(noreplace) %attr(0400,root,root) %_sysconfdir/sudoers.d/%name

%files phpfrontend-engine
%webserver_webappsdir/%name
%doc add_new_language.sh make_mo.sh update_po.sh

%files phpfrontend-php8.0
%files phpfrontend-php8.1
%files phpfrontend-php8.2

%files phpfrontend-apache2
%config(noreplace) %_sysconfdir/httpd2/conf/addon.d/A.%name.conf

%files phpfrontend-apache2-mod_php8.0
%files phpfrontend-apache2-mod_php8.1
%files phpfrontend-apache2-mod_php8.2

%files phpfrontend-nginx
%config(noreplace) %_sysconfdir/%name/%{name}_nginx.conf

%files phpfrontend-nginx-php8.0-fpm-fcgi
%files phpfrontend-nginx-php8.1-fpm-fcgi
%files phpfrontend-nginx-php8.2-fpm-fcgi

%files doc
%doc AUTHORS NEWS README INSTALL ChangeLog.bz2

%files contrib
%doc misc/snmptrap/*

%files source
%_includedir/%name

%changelog
