%define zm_builddir %{?_cmake__builddir:%_cmake__builddir}%{!?_cmake__builddir:BUILD}

%define zmuser apache2
%define zmgroup _webserver
%define phpver 8.1
ExcludeArch: armh

Name: zoneminder
Version: 1.36.34
Release: alt1
Summary: A camera monitoring and analysis tool
Group: System/Servers 
License: GPLv2
# VCS: https://github.com/ZoneMinder/ZoneMinder.git
Url: http://www.zoneminder.com
Source: %name-%version-alt.tar
Source4: zoneminder.conf
Source5: README.alt
Source6: README-nginx-ru.alt
Source7: nginx-zoneminder.conf.sample
Source8: zm-fcgi.inc.in
Source9: php-fpm-zoneminder.conf.in

Source100: %name-%version-dep-RtspServer.tar
Source101: %name-%version-web-api-app-Plugin-CakePHP-Enum-Behavior.tar
Source102: %name-%version-web-api-app-Plugin-Crud.tar


Conflicts: zm <= 1.22.3
BuildRequires(pre): rpm-macros-webserver-common
Requires: libgnutls libgnutls-openssl zlib ffmpeg
Requires: php%phpver-pdo_mysql php%phpver-openssl php%phpver-gd php%phpver-apcu php%phpver-intl
Requires: su
Requires: perl-Data-Entropy perl-Crypt-Eksblowfish perl-Sys-Mmap webserver perl-Pod-Usage 
Requires: perl-Sys-MemInfo perl-Number-Bytes-Human perl-JSON-MaybeXS perl-Sys-CPU 
Requires: perl-SOAP-WSDL perl-Class-Std-Fast perl-Data-UUID perl-IO-Socket-Multicast 
Requires: perl-Digest-SHA perl-Class-Date perl-DateTime perl-Date-Manip perl-libwww
Requires: perl-X10 perl-Sys-Mmap perl-DBD-mysql perl-Storable
AutoReq: noperl
BuildRequires: bzlib-devel ffmpeg gcc-c++ libswresample-devel libavdevice-devel libavformat-devel libgcrypt-devel libgnutls-openssl-devel libjpeg-devel libmysqlclient-devel libpcre-devel libswscale-devel netpbm perl-Archive-Tar perl-Archive-Zip perl-DBD-mysql perl-Date-Manip perl-MIME-Lite perl-MIME-tools perl-Module-Load perl-Sys-Mmap perl-X10 perl-devel perl-libwww zlib-devel libpolkit-devel cmake libv4l-devel rpm-macros-cmake libvlc-devel libcurl-devel libssl-devel libsystemd-devel libffi-devel libx264-devel libmount-devel libuuid-devel libselinux-devel libblkid-devel libmp4v2

%description
ZoneMinder is a set of applications which is intended to provide a complete
solution allowing you to capture, analyse, record and monitor any cameras you
have attached to a Linux based machine. It is designed to run on kernels which
support the Video For Linux (V4L) interface and has been tested with cameras
attached to BTTV cards, various USB cameras and IP network cameras. It is
designed to support as many cameras as you can attach to your computer without
too much degradation of performance. This package includes cambozola.jar.

%package api
Summary: Zoneminder Web API
Group: Networking/WWW
Requires: zoneminder php%phpver-apcu

%description api
The API is built in CakePHP and lives under the /api directory. It provides a RESTful service 
and supports CRUD (create, retrieve, update, delete) functions for Monitors, Events, Frames, 
Zones and Config.

%package nginx
Summary: Zoneminder configuration file and requires for nginx
Group: Networking/WWW
Requires: php8.1-fpm-fcgi fcgiwrap nginx
BuildArch: noarch
%description nginx
Zoneminder configuration file and requires for nginx

%prep
%setup -n %name-%version-alt -a100 -a101 -a102

cp %SOURCE5 README.alt
cp %SOURCE6 README-nginx-ru.alt

cat <<EOF >> db/zm_create.sql.in
use mysql;
CREATE user 'zmuser'@localhost identified by 'zmpass';
grant select,insert,update,delete on zm.* to 'zmuser'@localhost;
EOF

./utils/zmeditconfigdata.sh ZM_OPT_CAMBOZOLA yes
./utils/zmeditconfigdata.sh ZM_OPT_CONTROL yes
./utils/zmeditconfigdata.sh ZM_CHECK_FOR_UPDATES no
./utils/zmeditconfigdata.sh ZM_DYN_SHOW_DONATE_REMINDER no
./utils/zmeditconfigdata.sh ZM_OPT_FAST_DELETE no

%ifarch %e2k
# unsupported as of lcc 1.25.15
sed -i 's,-Wconditionally-supported,,' cmake/compiler/gcc/settings.cmake
sed -i "s/srcN\[\]/srcN[0]/" src/zm_rtp_ctrl.h
%endif

%build
%cmake -DZM_TARGET_DISTRO="alt" -DPCRE_INCLUDE_DIR=/usr/include/pcre -DZM_SYSTEMD=ON -DZM_WEB_USER=%{zmuser} -DZM_WEB_GROUP=%{zmgroup}

%cmake_build

%install
install -d %buildroot%_var/run
%cmakeinstall_std
rm -rf %buildroot%prefix/%_lib/perl5/vendor_perl/*.*/*-*
rm -rf %buildroot%prefix/%_lib/perl5/*.*/*-*


install -m 755 -d %buildroot%_var/log/zoneminder
for dir in events images temp
do
	install -m 755 -d %buildroot%_localstatedir/zoneminder/$dir
done
install -D -m 755 %zm_builddir/scripts/zm %buildroot%_initdir/zoneminder
install -D -m 644 %zm_builddir/misc/zoneminder.service %buildroot/%_unitdir/%name.service
install -D -m 644 %zm_builddir/misc/zoneminder-tmpfiles.conf %buildroot/%_tmpfilesdir/zoneminder.conf
install -D -m 644 %SOURCE4 %buildroot%_sysconfdir/httpd/conf/addon-modules.d/zoneminder.conf
install -D -m 644 %SOURCE7 %buildroot%_sysconfdir/nginx/sites-enabled.d/nginx-zoneminder.conf.sample
install -D -m 644 %SOURCE8 %buildroot%_sysconfdir/nginx/sites-enabled.d/zm-fcgi.inc
sed -si 's,@phpver@,%phpver,g' %buildroot%_sysconfdir/nginx/sites-enabled.d/zm-fcgi.inc
install -D -m 644 %SOURCE9 %buildroot%_sysconfdir/fpm%phpver/php-fpm.d/fpm-zm.conf
sed -si 's,@phpver@,%phpver,g' %buildroot%_sysconfdir/fpm%phpver/php-fpm.d/fpm-zm.conf
mkdir -p %buildroot/%_cachedir/%name

ln -s ../../../../..%_cachedir/%name %buildroot%_datadir/%name/www/cache


rm -f %buildroot%perl_vendor_archlib/perllocal.pod
mkdir -p %buildroot%_datadir/%name/db
cp db/*.sql %buildroot%_datadir/%name/db

%pre
%_sbindir/groupadd -r -f %zmgroup 2>/dev/null ||:
%_sbindir/useradd -g %zmgroup -c 'WWW server' -d %webserver_datadir -s '/dev/null' \
        -G %webserver_group -r %zmuser 2>/dev/null || :

%post
%post_service zoneminder

%preun
%preun_service zoneminder

%files
%doc COPYING README.md README.alt
%config(noreplace) %_sysconfdir/zm/zm.conf
%config(noreplace) %_sysconfdir/zm/conf.d/*.conf
%ghost %_cachedir/%name
%_sysconfdir/zm/conf.d/README
%_tmpfilesdir/zoneminder.conf
%_unitdir/%name.service
%_initdir/zoneminder
%_bindir/*
%_datadir/%name
%_man8dir/zm*
%perl_vendorlib/ZoneMinder*
%perl_vendorlib/ONVIF*
%perl_vendorlib/WSDiscovery*
%perl_vendorlib/WSSecurity*
%perl_vendorlib/WSNotification*

%_libexecdir/%name
%dir %attr(755,%zmuser,%zmgroup) %_var/log/zoneminder
%dir %attr(755,%zmuser,%zmgroup) %_localstatedir/zoneminder
%dir %attr(755,%zmuser,%zmgroup) %_localstatedir/zoneminder/events
%dir %attr(755,%zmuser,%zmgroup) %_localstatedir/zoneminder/images
%dir %attr(755,%zmuser,%zmgroup) %_localstatedir/zoneminder/temp
%_datadir/polkit-1/*/*
%exclude %_datadir/%name/www/api


%files nginx
%doc README-nginx-ru.alt
%config(noreplace) %_sysconfdir/nginx/sites-enabled.d/*
%config(noreplace) %_sysconfdir/fpm%phpver/php-fpm.d/*

%files api
%_datadir/%name/www/api

%changelog
