Name: ElectricFence
Version: 2.2.2
Release: alt4

Summary: A debugger which detects memory allocation violations

License: GPLv2
Group: Development/Other
Url: http://perens.com/FreeSoftware/%name

Packager: Vitaly Lipatov <lav@altlinux.ru>

# restricted ftp?
Source: ftp://ftp.perens.com/pub/ElectricFence/beta/%name-%version.tar
Patch1: ElectricFence-2.0.5-longjmp.patch
Patch2: ElectricFence-2.1-vaarg.patch
Patch3: ElectricFence-2.2.2-pthread.patch
Patch4: ElectricFence-2.2.2-madvise.patch
Patch5: ElectricFence-2.2.2-strerror.patch
Patch6: ElectricFence-mmap-size.patch
Patch7: ElectricFence-2.2.2-ef.patch
Patch8: ElectricFence-2.2.2-builtins.patch

%description
ElectricFence is a utility for C programming and
debugging. ElectricFence uses the virtual memory hardware of your
system to detect when software overruns malloc() buffer boundaries,
and/or to detect any accesses of memory released by
free(). ElectricFence will then stop the program on the first
instruction that caused a bounds violation and you can use your
favorite debugger to display the offending statement.

Install ElectricFence if you need a debugger to find malloc()
violations.

%prep
%setup
%patch1 -p1 -b .longjmp
%patch2 -p1 -b .vaarg
%patch3 -p1 -b .pthread
%patch4 -p1 -b .madvise
%patch5 -p2 -b .strerror
%patch6 -p1
%patch7 -p1
%patch8 -p1
%__subst "s|/lib\$|/%_lib|g" Makefile

%build
%make_build CFLAGS='${RPM_OPT_FLAGS} -DUSE_SEMAPHORE -fpic'

%install
mkdir -p %buildroot{%_bindir,%_libdir,%_man3dir}
%makeinstall MAN_INSTALL_DIR=%buildroot%_man3dir
echo ".so man3/efence.3" > %buildroot%_mandir/man3/libefence.3
rm -fv %buildroot%_libdir/libefence.a

%files
%_bindir/ef
%_libdir/libefence.*
%_man3dir/*
%doc README CHANGES

%changelog
