%define maj_ver 3.0
Name: GLC_lib
Version: %maj_ver.1.20211001
Release: alt2
Summary: C++ class library for OpenGL application based on Qt 5

Group: System/Libraries
License: LGPL-2.1
Url: https://github.com/laumaya/GLC_lib

Source: %name-%version.tar
Patch: unbundled_library.patch

BuildRequires: qt5-base-devel
BuildRequires: qt5-quickcontrols2-devel
BuildRequires: lib3ds-devel
BuildRequires: quazip-qt5-devel
BuildRequires: zlib-devel

# Project ERROR: GLC_lib does not support OpenGL ES 2!
ExcludeArch: %arm

%description
GLC_lib is a C++ class library that enables the quick creation of OpenGL
application based on Qt 5. Some GLC_lib features : Camera orbiting, Obj
textured file support, 3D Primitive... And more.

%package devel
Summary: Development files for %name
Group: Development/Other
Requires: %name = %version-%release
Requires: libqt5-declarative
Requires: qt5-designer
Requires: qt5-base-devel
Requires: qt5-quickcontrols2-devel

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%prep
%setup
%patch -p2

#Fix library Path on lib64
%__subst 's|LIB_DIR = /usr/lib|LIB_DIR = %_libdir|' glc_lib.pro install.pri

%build
%qmake_qt5 \
    CONFIG+="force_debug_info qml_debug" \
    LIBS+="-l3ds -lquazip1-qt5 -lz" \
    QMAKE_CXXFLAGS+="`pkg-config --cflags quazip1-qt5`" \
    glc_lib.pro
%make_build

%install
%make_install install INSTALL_ROOT=%buildroot

# remove built examples
rm -r %buildroot%prefix/src/GLC_lib-%maj_ver/examples ||:

%files
%doc README
%_libdir/*.so.*
%_libdir/qt5/qml/glclib

%files devel
%_includedir/GLC_lib-%maj_ver/
%_libdir/*.so

%changelog
