%define soversion 2.2
%def_disable static

Name: GLEW
Version: 2.2.0
Release: alt1

Summary: The OpenGL Extension Wrangler library
License: BSD and MIT
Group: System/Libraries

Url: http://glew.sourceforge.net/
Packager: Nazarov Denis <nenderus@altlinux.org>

Source: https://downloads.sourceforge.net/project/glew/glew/%version/glew-%version.tgz

BuildRequires: gcc
BuildRequires: libGLU-devel

%description
The OpenGL Extension Wrangler Library (GLEW) is a cross-platform open-source C/C++
extension loading library. GLEW provides efficient run-time mechanisms for determining 
which OpenGL extensions are supported on the target platform. OpenGL core and extension
functionality is exposed in a single header file. GLEW has been tested on a variety of 
operating systems, including Windows, Linux, Mac OS X, FreeBSD, Irix, and Solaris.

%package -n lib%name%soversion
Summary: The OpenGL Extension Wrangler library
Group: System/Libraries
Provides: libGLEW = %version

%description -n lib%name%soversion
The OpenGL Extension Wrangler Library (GLEW) is a cross-platform open-source C/C++
extension loading library. GLEW provides efficient run-time mechanisms for determining 
which OpenGL extensions are supported on the target platform. OpenGL core and extension
functionality is exposed in a single header file. GLEW has been tested on a variety of 
operating systems, including Windows, Linux, Mac OS X, FreeBSD, Irix, and Solaris.

%package -n lib%name-devel
Summary: The OpenGL Extension Wrangler library development files
Group: Development/C
Provides: libglew-devel = %version
Obsoletes: libglew-devel < %version
Provides: lib%{name}mx-devel = %version
Obsoletes: lib%{name}mx-devel < %version

%description -n lib%name-devel
The OpenGL Extension Wrangler Library (GLEW) is a cross-platform open-source C/C++
extension loading library. GLEW provides efficient run-time mechanisms for determining 
which OpenGL extensions are supported on the target platform. OpenGL core and extension
functionality is exposed in a single header file. GLEW has been tested on a variety of 
operating systems, including Windows, Linux, Mac OS X, FreeBSD, Irix, and Solaris.

The package contains the C headers to compile programs based on %name.

%if_enabled static
%package -n lib%name-devel-static
Summary: The OpenGL Extension Wrangler library development files
Group: Development/C

%description -n lib%name-devel-static
The OpenGL Extension Wrangler Library (GLEW) is a cross-platform open-source C/C++
extension loading library. GLEW provides efficient run-time mechanisms for determining 
which OpenGL extensions are supported on the target platform. OpenGL core and extension
functionality is exposed in a single header file. GLEW has been tested on a variety of 
operating systems, including Windows, Linux, Mac OS X, FreeBSD, Irix, and Solaris.
%endif

%prep
%setup -n glew-%version
sed -i s/wglew/eglew/ Makefile
%if_disabled static
sed -i '/LIB.STATIC.*DESTDIR/d' Makefile
%endif

%build
install -pm755 -- %_datadir/gnu-config/config.guess config/
%make_build STRIP= CFLAGS.EXTRA='%optflags %optflags_shared' LDFLAGS.EXTRA= \
	glew.lib.shared \
%if_enabled static
	glew.lib.static \
%endif
	#

%install
%makeinstall_std BINDIR=%_bindir LIBDIR=%_libdir INCDIR=%_includedir/GL PKGDIR=%_pkgconfigdir

%set_verify_elf_method strict
%define _unpackaged_files_terminate_build 1

%files -n lib%name%soversion
%doc LICENSE.txt doc/*
%_libdir/lib%name.so.%soversion
%_libdir/lib%name.so.%soversion.*

%files -n lib%name-devel
%_includedir/GL/*.h
%_libdir/lib*.so
%_pkgconfigdir/*.pc

%if_enabled static
%files -n lib%name-devel-static
%_libdir/lib%name.a
%endif

%changelog
