# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name: OpenBoard
Version: 1.7.1
Release: alt2
Summary: Interactive whiteboard for schools and universities
Summary(ru_RU.UTF-8): Интерактивная доска для школ и университетов
License: GPL-3.0+
Group: Education
Url: https://github.com/OpenBoard-org/OpenBoard

ExcludeArch: ppc64le

Source: %name-%version.tar

Source1: %name.svg

# GeoInfo widget with a version with modified borders of Ukraine and Russia from ThomasLucky13
Source2: GeoInfo.wgt.tar.gz

# https://github.com/OpenBoard-org/OpenBoard/pull/648
Patch1: 0001-OpenBoard-1.7.0-update-russian-translations.patch
Patch2: 0002-dark-background-color-set-ability-feature.patch
# https://github.com/OpenBoard-org/OpenBoard/pull/635
Patch3: 0003-new-icon-images.patch
# https://github.com/OpenBoard-org/OpenBoard/pull/714
Patch4: 0004-toolbar_elements_changed.patch
# https://github.com/OpenBoard-org/OpenBoard/pull/714
Patch6: 0006-polygon_line_styles.patch
# https://github.com/OpenBoard-org/OpenBoard/pull/712
Patch8: 0008-background-grid-size-save.patch
# https://github.com/OpenBoard-org/OpenBoard/pull/714
Patch9: 0009-vector_tool.patch
Patch11: 0011-fix-videoSize-saving.patch
Patch13: 0013-Changes-for-dark-mode.patch
Patch14: 0014-widgets-names-ru_translate.patch
# https://github.com/OpenBoard-org/OpenBoard/pull/809
Patch16: 0016-UBCompassTool-upgrade.patch
# Patch changes:
# - Added help buttons to the toolbar
Patch18: 0018-Add-help-buttons.patch
Patch19: 0019-add-ru-translate-for-startupHints.patch
Patch20: 0020-showMaximized-when-open.patch
Patch21: 0021-set-web-search-engine-to-yandex.patch
Patch22: 0022-fix-documents-view.patch
Patch23: 0023-improvement-tool-change.patch
Patch24: 0024-fix-problem-with-multiscreen.patch
Patch25: 0025-multi-touch.patch
Patch26: 0026-remove-swipe-pages.patch
# Build with C++20 for Poppler v24.04 and newer
# https://github.com/OpenBoard-org/OpenBoard/issues/958
Patch100: build-with-c++20.patch
#https://github.com/OpenBoard-org/OpenBoard/pull/962
Patch101: fix-Add-compatibility-with-C++20.patch

BuildRequires: gcc-c++ libgomp-devel
BuildRequires: desktop-file-utils
BuildRequires: libpaper-devel
BuildRequires: libssl-devel
BuildRequires: quazip-qt5-devel
BuildRequires: libqtsingleapplication-qt5-devel
BuildRequires: t1lib-devel
BuildRequires: libavcodec-devel libavformat-devel libswscale-devel libswresample-devel
BuildRequires: libalsa-devel libvpx-devel libvorbis-devel libtheora-devel libogg-devel
BuildRequires: libopus-devel liblame-devel libass-devel
BuildRequires: liblzma-devel bzlib-devel
BuildRequires: pkgconfig(Qt5Core)
BuildRequires: pkgconfig(Qt5Gui)
BuildRequires: pkgconfig(Qt5Help)
BuildRequires: pkgconfig(Qt5Multimedia)
BuildRequires: pkgconfig(Qt5MultimediaWidgets)
BuildRequires: pkgconfig(Qt5Network)
BuildRequires: pkgconfig(Qt5PrintSupport)
BuildRequires: pkgconfig(Qt5Script)
BuildRequires: pkgconfig(Qt5Svg)
BuildRequires: pkgconfig(Qt5UiTools)
BuildRequires: pkgconfig(Qt5WebEngineWidgets)
BuildRequires: pkgconfig(Qt5Xml)
BuildRequires: pkgconfig(Qt5XmlPatterns)
BuildRequires: pkgconfig(libpulse-mainloop-glib)
BuildRequires: pkgconfig(libpulse)
BuildRequires: pkgconfig(hunspell)
BuildRequires: pkgconfig(freetype2)
BuildRequires: pkgconfig(openssl)
BuildRequires: pkgconfig(poppler)
BuildRequires: pkgconfig(poppler-cpp)
BuildRequires: pkgconfig(sdl)

Requires: onboard
Requires: /sbin/pidof

%description
Interactive whiteboard for schools and universities.

%description -l ru_RU.UTF-8
Интерактивная доска для школ и университетов

%prep
%setup -a2
%autopatch -p1

# remove unwanted and nonfree libraries
sed -i -e 's|-lfdk-aac ||' src/podcast/podcast.pri
sed -i -e 's|-lx264 ||' src/podcast/podcast.pri

# drop quazip LIBS INCLUDEPATH
sed -i  -e '/LIBS += -lquazip5/d' \
	-e '/INCLUDEPATH += "\/usr\/include\/quazip5"/d' \
	OpenBoard.pro

# Removed some map widgets because of incorrect display of borders of Ukraine and Russia
rm -vr resources/library/applications/GoogleMaps.wgt
rm -vr resources/library/applications/OpenStreetMap.wgt

# Replacement of the GeoInfo widget with a version with modified borders of Ukraine and Russia
rm -vr resources/library/applications/GeoInfo.wgt
mv GeoInfo.wgt resources/library/applications/GeoInfo.wgt

rm -v resources/etc/OpenBoard.css

%build
%qmake_qt5 \
    LIBS+="`pkg-config --libs quazip1-qt5`" \
    INCLUDEPATH+="`pkg-config --cflags-only-I quazip1-qt5 |
      sed 's/-I//g'`" \
    INCLUDEPATH+=%_includedir/poppler \
    INCLUDEPATH+=%_includedir/qt5/QtSolutions \
    %name.pro
%make_build

%install
%makeinstall_std
install -D -m 0644 %SOURCE1 %buildroot%_iconsdir/hicolor/scalable/apps/OpenBoard.svg

# missing desktop file, creating one
mkdir -p %buildroot%_desktopdir/
cat > %buildroot%_desktopdir/%name.desktop <<EOF
[Desktop Entry]
Encoding=UTF-8
Name=%name
GenericName=%name
Comment=Interactive whiteboard for schools and universities
Comment[ru]=Интерактивная доска для школ и университетов
Exec=%_bindir/openboard "%f"
Icon=%name
StartupNotify=true
Terminal=false
Type=Application
MimeType=application/x-%name;
Categories=Education;Engineering;
EOF

install -D -m 0755 build/linux/release/product/OpenBoard %buildroot%_libdir/%name/OpenBoard
cp -r build/linux/release/product/* %buildroot%_libdir/%name/

#run.sh (set env to avoid some possible issues)
cat > %buildroot%_libdir/%name/run.sh <<EOF
#!/bin/bash
# --------------------------------------------------------------------
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ---------------------------------------------------------------------

if pid="\$(/sbin/pidof OpenBoard)"; then
    echo "OpenBoard is already running, PID \${pid}."
    exit 0
fi

env QT_PLUGIN_PATH=\$QT_PLUGIN_PATH:%_libdir/%name/plugins LD_LIBRARY_PATH=\$LD_LIBRARY_PATH:%_libdir/%name/plugins/cffadaptor %_libdir/%name/OpenBoard "\$@"
EOF

chmod 0755 %buildroot%_libdir/%name/run.sh
mkdir -p %buildroot/%_bindir/
ln -s -T %_libdir/%name/run.sh %buildroot/%_bindir/openboard

# clean some exe bits
find %buildroot -executable -type f -name *.js -exec chmod -x '{}' \+
find %buildroot -executable -type f -name *.svg -exec chmod -x '{}' \+
find %buildroot -executable -type f -name *.css -exec chmod -x '{}' \+
find %buildroot -executable -type f -name *.xml -exec chmod -x '{}' \+
find %buildroot -executable -type f -name *.html -exec chmod -x '{}' \+

# internalization
lrelease-qt5 -removeidentical %name.pro
mkdir -p %buildroot%_libdir/%name/i18n/
cp -R resources/i18n/%{name}*.qm %buildroot%_libdir/%name/i18n/

# customizations
cp -R resources/customizations %buildroot%_libdir/%name/

%files
%doc COPYRIGHT LICENSE
%_bindir/openboard
%_libdir/%name
%_desktopdir/%name.desktop
%_iconsdir/hicolor/scalable/apps/%name.svg

%changelog
