# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

# TODO: with additional buildreqs it builds
#    /usr/bin/osgQtBrowser
#    /usr/bin/osgQtWidgets
#    /usr/bin/osgqfont
#    /usr/bin/osgviewerFLTK
#    /usr/bin/osgviewerQt
#    /usr/bin/osgviewerWX


#
# Copyright (c) 2005, 2006, 2007, 2008, 2009 Ralf Corsepius, Ulm, Germany.
# Copyright (c) 2009 Michael Shigorin
# Copyright (c) 2011 Dmitry Derjavin
# This file and all modifications and additions to the pristine
# package are under the same license as the package itself.

Name: OpenSceneGraph
Version: 3.6.5
Release: alt2

Summary: High performance real-time graphics toolkit
License: OSGPL (wxWidgets, clarified LGPL)
Group: System/Libraries

Url: http://www.openscenegraph.org
# Source-url: https://github.com/openscenegraph/OpenSceneGraph/archive/OpenSceneGraph-%version.tar.gz
Source: %name-%version.tar
Packager: Michael Shigorin <mike@altlinux.org>

# thanks, Fedora
Patch1: 0001-Cmake-fixes.patch
# Upstream deactivated building osgviewerWX for obscure reasons
# Reactivate for now.
Patch2:         0002-Activate-osgviewerWX.patch
# Unset DOT_FONTNAME
Patch3:         0003-Unset-DOT_FONTNAME.patch
# Re-add osgframerenderer
Patch4:         0004-Re-add-osgframerenderer.patch
# Force osgviewerWX to always use X11 backend (wxGLCanvas is broken on Wayland)
Patch5:         force-x11-backend.patch
# Minimal port to OpenEXR 3
# https://github.com/openscenegraph/OpenSceneGraph/issues/1075
Patch6:         OpenSceneGraph-openexr3.patch
# Fix build against recent asio
Patch7:         OpenSceneGraph_asio.patch

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake
BuildRequires: asio-devel
BuildRequires: doxygen graphviz
BuildRequires: gcc-c++
BuildRequires: libgif-devel
BuildRequires: gnuplot

BuildRequires: libcurl-devel
BuildRequires: libGL-devel
BuildRequires: libGLU-devel
BuildRequires: libjpeg-devel
BuildRequires: libpng-devel
BuildRequires: libtiff-devel
BuildRequires: libvncserver-devel
BuildRequires: libxml2-devel
BuildRequires: libXmu-devel
BuildRequires: libX11-devel

BuildRequires: libInventor-devel
#BuildRequires: libSDL-devel
BuildRequires: libSDL2-devel
#BuildRequires: libXScrnSaver-devel
#BuildRequires: libXcomposite-devel
#BuildRequires: libXdmcp-devel
#BuildRequires: libXpm-devel
#BuildRequires: libXtst-devel
#BuildRequires: libXxf86misc-devel
#BuildRequires: libfreeglut-devel

BuildRequires: libcairo-devel
BuildRequires: libXrandr-devel

BuildRequires: libgtkglext-devel
BuildRequires: libopenal-devel
BuildRequires: libpoppler-glib-devel
BuildRequires: librsvg-devel
BuildRequires: libxkbfile-devel
BuildRequires: libxml2-devel
BuildRequires: libgta-devel

BuildRequires: libwxGTK3.0-devel
#BuildRequires: pkgconfig(gtk+-2.0)

BuildRequires: gstreamer1.0-devel
BuildRequires: libgstreamermm1.0-devel
BuildRequires: gst-plugins-bad1.0-devel
BuildRequires: gst-plugins1.0-devel

BuildRequires: libgdal-devel

Requires: lib%name

%ifarch %e2k
# error: cpio archive too big - 4321M
%global __find_debuginfo_files %nil
%endif

%description
The OpenSceneGraph is an OpenSource, cross platform graphics
toolkit for the development of high performance graphics
applications such as flight simulators, games, virtual reality
and scientific visualization.  Based around the concept of
a SceneGraph, it provides an object oriented framework on top
of OpenGL freeing the developer from implementing and optimizing
low level graphics calls, and provides many additional utilities
for rapid development of graphics applications.

%package -n lib%name
Summary: Development files for OpenSceneGraph
Group: System/Libraries
Requires: libOpenThreads

%description -n lib%name
Runtime libraries files for OpenSceneGraph

%package -n lib%name-devel
Summary: Development files for OpenSceneGraph
Group: Development/C++
Requires: lib%name
Requires: libOpenThreads-devel
Requires: pkgconfig

%description -n lib%name-devel
Development files for OpenSceneGraph

%package gdal
Summary: OSG Gdal plugin
Group: System/Libraries
Requires: lib%name

%description gdal
OSG Gdal plugin.

%package gstreamer
Summary: OSG gstreamer plugin
Group: System/Libraries
Requires: lib%name

%description gstreamer
OSG gstreamer plugin.

%package inventor
Summary: OSG inventor plugin
Group: System/Libraries
Requires: lib%name

%description inventor
OSG inventor plugin.

%package examples-SDL
Summary: OSG sample applications using SDL
Group: Development/Documentation

%description examples-SDL
OSG sample applications using SDL

# currently broken, see #25943
#package examples-fltk
#Summary: OSG sample applications using FLTK
#Group: Development/Documentation
#
#description examples-fltk
#OSG sample applications using FLTK
#
#files examples-fltk
#_bindir/osgviewerFLTK

# lcc 1.23.12:
# CMakeFiles/example_osgoscdevice.dir/osgoscdevice.o:(.rodata._ZTIPKN5osgFX6ScribeE[_ZTIPKN5osgFX6ScribeE]+0x18): undefined reference to `typeinfo for osgFX::Scribe'
# CMakeFiles/example_osgoscdevice.dir/osgoscdevice.o:(.rodata._ZTIPKN5osgFX6EffectE[_ZTIPKN5osgFX6EffectE]+0x18): undefined reference to `typeinfo for osgFX::Effect'
# OpenSceneGraph-examples
%package examples
Summary: Sample applications for OpenSceneGraph
Group: Development/Documentation

%description examples
Sample applications for OpenSceneGraph

%package -n libOpenThreads
Summary: OpenThreads
Group: System/Libraries
Provides: OpenThreads = %name-%version

%description -n libOpenThreads
OpenThreads is intended to provide a minimal & complete Object-Oriented
(OO) thread interface for C++ programmers.  It is loosely modeled on the
Java thread API, and the POSIX Threads standards.  The architecture of
the library is designed around "swappable" thread models which are
defined at compile-time in a shared object library.

%package -n libOpenThreads-devel
Summary: Development files for OpenThreads
Group: Development/C++
Requires: libOpenThreads = %version-%release

%description -n libOpenThreads-devel
Development files for OpenThreads

%prep
%setup
%autopatch -p1

# path to install examples (instead the patch)
sed -i "s|share/OpenSceneGraph/bin|bin|" CMakeModules/OsgMacroUtils.cmake

# Also look in /usr/share/fonts for fonts
sed -i -e 's,\.:/usr/share/fonts/ttf:,.:%{_datadir}/fonts:/usr/share/fonts/ttf:,' \
src/osgText/Font.cpp

iconv -f ISO-8859-1 -t utf-8 AUTHORS.txt > AUTHORS.txt~
mv AUTHORS.txt~ AUTHORS.txt

# Update doxygen
doxygen -u doc/Doxyfiles/doxyfile.cmake
doxygen -u doc/Doxyfiles/openthreads.doxyfile.cmake

%build
%cmake -DCMAKE_BUILD_TYPE="Release" \
      -DLIB_POSTFIX=%(l=%{_lib}; echo ${l:3}) \
      -DCMAKE_CXX_FLAGS_RELEASE="-DNDEBUG" \
%ifarch %e2k
      -DBUILD_OSG_EXAMPLES=OFF \
%else
      -DBUILD_OSG_EXAMPLES=ON \
%endif
      -DBUILD_OSG_WRAPPERS=ON \
      -DBUILD_DOCUMENTATION=ON \
      -DOSG_AGGRESSIVE_WARNING_FLAGS=OFF \
      -Wno-dev

%cmake_build

%install
%cmake_install
# Supposed to take OpenSceneGraph data
mkdir -p %buildroot%_datadir/OpenSceneGraph

# hack for 3.4.x (it is ok since 3.6.0)
rm -rf %buildroot/usr/doc/

%files
%doc AUTHORS.txt LICENSE.txt NEWS.txt README.md
%_bindir/osgarchive
%_bindir/osgconv
%_bindir/osgviewer
%_bindir/osgfilecache
%_bindir/present3D

%files -n lib%name
%_libdir/osgPlugins-%version
%_libdir/libosg*.so.*
%exclude %_libdir/osgPlugins-%version/osgdb_gstreamer.so
%exclude %_libdir/osgPlugins-%version/osgdb_gdal.so
%exclude %_libdir/osgPlugins-%version/osgdb_ogr.so
%exclude %_libdir/osgPlugins-%version/osgdb_gstreamer.so
%exclude %_libdir/osgPlugins-%version/osgdb_iv.so

%files gdal
%_libdir/osgPlugins-%version/osgdb_gdal.so
%_libdir/osgPlugins-%version/osgdb_ogr.so

%files gstreamer
%_libdir/osgPlugins-%version/osgdb_gstreamer.so

%files inventor
%_libdir/osgPlugins-%version/osgdb_iv.so

%files -n lib%name-devel
%doc %_cmake__builddir/doc/OpenSceneGraphReferenceDocs
%_includedir/osg*
%_pkgconfigdir/openscenegraph*.pc
%_libdir/libosg*.so
%_bindir/osgversion

%ifnarch %e2k
#files examples-SDL
#_bindir/osgviewerSDL

%files examples
%_bindir/osg2cpp
%_bindir/osgbindlesstext
%_bindir/osgdatabaserevisions
%_bindir/osgdeferred
%_bindir/osgfpdepth
%_bindir/osgframerenderer
%_bindir/osggpx
%_bindir/osggraphicscost
%_bindir/osgmultiviewpaging
%_bindir/osgobjectcache
%_bindir/osgoit
%_bindir/osgoutline
%_bindir/osgparticleshader
%_bindir/osgposter
#_bindir/osgqfont
%_bindir/osgshadercomposition
%_bindir/osgshadergen
%_bindir/osgtexturecompression
%_bindir/osgthreadedterrain
%_bindir/osguniformbuffer
%_bindir/osguserdata
%_bindir/osguserstats
%_bindir/osgvertexattributes
%_bindir/osgvirtualprogram
%_bindir/osganalysis
%_bindir/osganimationeasemotion
%_bindir/osganimationmorph
%_bindir/osganimationhardware
%_bindir/osganimationmakepath
%_bindir/osganimationnode
%_bindir/osganimationskinning
%_bindir/osganimationsolid
%_bindir/osganimationtimeline
%_bindir/osganimationviewer
%_bindir/osgautocapture
#_bindir/osgbrowser
%_bindir/osgcluster
%_bindir/osgdrawinstanced
%_bindir/osggameoflife
%_bindir/osgmemorytest
%_bindir/osgpackeddepthstencil
%_bindir/osgpdf
%_bindir/osgrobot
%_bindir/osgsidebyside
%_bindir/osgwidgetmessagebox
%_bindir/osgwidgetperformance
%_bindir/osgfont
%_bindir/osgimagesequence
%_bindir/osgkdtree
%_bindir/osgscreencapture
%_bindir/osgwidgetaddremove
%_bindir/osgwidgetbox
%_bindir/osgwidgetcanvas
%_bindir/osgwidgetframe
%_bindir/osgwidgetinput
%_bindir/osgwidgetlabel
%_bindir/osgwidgetmenu
%_bindir/osgwidgetnotebook
%_bindir/osgwidgetscrolled
%_bindir/osgwidgetshader
%_bindir/osgwidgetstyled
%_bindir/osgwidgettable
%_bindir/osgwidgetwindow
%_bindir/osggeometryshaders
%_bindir/osgmultiplerendertargets
%_bindir/osgmultitexturecontrol
%_bindir/osgocclusionquery
%_bindir/osgsharedarray
%_bindir/osgstereomatch
%_bindir/osgtext3D
%_bindir/osgthirdpersonview
%_bindir/osgdepthpeeling
%_bindir/osganimate
%_bindir/osgautotransform
%_bindir/osgbillboard
%_bindir/osgblendequation
%_bindir/osgcallback
%_bindir/osgcamera
%_bindir/osgcatch
%_bindir/osgclip
%_bindir/osgcompositeviewer
%_bindir/osgcopy
%_bindir/osgcubemap
#_bindir/osgdelaunay
%_bindir/osgdepthpartition
%_bindir/osgdistortion
%_bindir/osgfadetext
%_bindir/osgforest
%_bindir/osgfxbrowser
#_bindir/osggeodemo
%_bindir/osggeometry
%_bindir/osghangglide
%_bindir/osghud
%_bindir/osgimpostor
%_bindir/osgintersection
#_bindir/osgintrospection
%_bindir/osgkeyboard
%_bindir/osgkeyboardmouse
%_bindir/osglauncher
%_bindir/osglight
%_bindir/osglightpoint
%_bindir/osglogicop
%_bindir/osglogo
%_bindir/osgmanipulator
%_bindir/osgmotionblur
%_bindir/osgmovie
%_bindir/osgmultitexture
%_bindir/osgoccluder
%_bindir/osgpagedlod
%_bindir/osgparametric
%_bindir/osgparticle
%_bindir/osgparticleeffects
%_bindir/osgpick
%_bindir/osgplanets
%_bindir/osgpoints
%_bindir/osgpointsprite
%_bindir/osgprecipitation
%_bindir/osgprerender
%_bindir/osgprerendercubemap
%_bindir/osgreflect
%_bindir/osgsampler
%_bindir/osgscalarbar
%_bindir/osgscribe
%_bindir/osgsequence
%_bindir/osgshaders
%_bindir/osgshadermultiviewport
%_bindir/osgshaderpipeline
%_bindir/osgshaderterrain
%_bindir/osgshadow
%_bindir/osgshape
%_bindir/osgsimpleMDI
%_bindir/osgsimplifier
%_bindir/osgslice
%_bindir/osgspacewarp
%_bindir/osgspheresegment
%_bindir/osgspotlight
%_bindir/osgstereoimage
%_bindir/osgteapot
%_bindir/osgterrain
%_bindir/osgtessellate
%_bindir/osgtext
%_bindir/osgtexture1D
%_bindir/osgtexture2D
%_bindir/osgtexture3D
%_bindir/osgtexturerectangle
%_bindir/osgunittests
%_bindir/osgvertexprogram
#_bindir/osgviewerGLUT
%_bindir/osgviewerWX
%_bindir/osgvolume
%_bindir/osgvnc
%_bindir/osgwindows

%_bindir/osgphotoalbum
%_bindir/osgsimulation

%_bindir/osgatomiccounter
%_bindir/osgcomputeshaders
#_bindir/osgframerenderer
%_bindir/osgkeystone
%_bindir/osgmultiplemovies
%_bindir/osgmultitouch
%_bindir/osgoscdevice
%_bindir/osgsimplegl3
%_bindir/osgsimpleshaders
%_bindir/osgtessellationshaders

%_bindir/osgSSBO
%_bindir/osgblenddrawbuffers
%_bindir/osggpucull
%_bindir/osgtexture2DArray
%_bindir/osgtransferfunction
%_bindir/osgtransformfeedback

%_bindir/osgviewerGTK

%_datadir/OpenSceneGraph
%endif

%files -n libOpenThreads
%doc AUTHORS.txt LICENSE.txt NEWS.txt README.md
%_libdir/libOpenThreads.so.*

%files -n libOpenThreads-devel
%doc %_cmake__builddir/doc/OpenThreadsReferenceDocs
%_pkgconfigdir/openthreads.pc
%_libdir/libOpenThreads.so
%_includedir/OpenThreads

%changelog
