# due libs in nonstandard place
%set_verify_elf_method unresolved=relaxed
%add_findprov_lib_path %_libdir/torcs/lib

Name: TORCS
Version: 1.3.7
Release: alt1
Summary: The Open Racing Car Simulator
License: GPL-2.0
Group: Games/Sports
Url: http://torcs.sourceforge.net/

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: %name-%version.tar
Source1: %name.desktop
Source2:  %name.appdata.xml

# mandatory
Source11: %name.16.xpm
Source12: %name.32.xpm
Source13: %name.48.xpm

Patch0: torcs-1.3.6-gcc7.patch
Patch1: torcs-1.3.7-isnan.patch

Requires: %name-data = %version
# hack for fix https://bugzilla.altlinux.org/show_bug.cgi?id=16145
Requires: freeglut plib libalut

# Automatically added by buildreq on Sun Nov 30 2008
BuildRequires: gcc-c++ imake libGL-devel libXext-devel libXi-devel libXmu-devel
BuildRequires: libXrandr-devel libXrender-devel libalut-devel libexpat-devel
BuildRequires: libfreeglut-devel libpng-devel plib-devel xorg-cf-files xorg-sdk
BuildRequires: libXxf86vm-devel libogg-devel libvorbis-devel libopenal-devel
%description
A 3D racing car simulator using OpenGL.

%package data
Summary:        Data files for TORCS
Group:          Games/Sports
Requires:       %name = %version
BuildArch:      noarch

Conflicts: %name-data-tracks < 1.3.7
Obsoletes: %name-data-tracks < 1.3.7
Conflicts: %name-data-cars < 1.3.7
Obsoletes: %name-data-cars < 1.3.7

%description data
Architecture independent data files for The Open Racing Car Simulator.

%prep
%setup

%patch0 -p1
%patch1 -p1

# replace nonunicode symbols in all XMLs
find ./ -name "*.xml" -print0 | xargs -0 sed -i "s|\xE9|e|g"

%build
export TORCS_BASE=`pwd` MAKE_DEFAULT=`pwd`/Make-default.mk
export CFLAGS="$CFLAGS -fPIC"
export CXXFLAGS="$CXXFLAGS -fPIC"
autoconf
%configure --x-libraries=%_libdir

%make

%install
make V=1 install DESTDIR=%{buildroot}
make V=1 datainstall DESTDIR=%{buildroot}

# Menu
install -D -m 644 %SOURCE1 %buildroot%_desktopdir/%name.desktop

#Appdata
install -D -m 644 %SOURCE2 %buildroot%_datadir/appdata/torcs.appdata.xml

# Icons
install -m 644 -D %SOURCE11 %buildroot%_miconsdir/%name.xpm
install -m 644 -D %SOURCE12 %buildroot%_niconsdir/%name.xpm
install -m 644 -D %SOURCE13 %buildroot%_liconsdir/%name.xpm

%files
%doc README COPYING
%_bindir/*
%_libdir/torcs/
%_desktopdir/*
%_datadir/appdata/torcs.appdata.xml
%_miconsdir/%name.xpm
%_niconsdir/%name.xpm
%_liconsdir/%name.xpm

%files data
%dir %_gamesdatadir/torcs/
%_gamesdatadir/torcs/*

%changelog
