# -*- mode: RPM-SPEC; tab-width: 8; fill-column: 70; -*- 
# $Id: alterator-control.spec,v 1.15 2006/04/28 10:48:26 inger Exp $ 

Name: alterator-wizardface
Version: 2.3
Release: alt1

Url: http://altlinux.org/alterator
Source: %name-%version.tar
Packager: Stanislav Ievlev <inger@altlinux.org>

#replace previous version in branch
Provides: alterator-wizard = %version
Obsoletes: alterator-wizard

Requires: alterator >= 5.0-alt1 alterator-sh-functions
Requires: alterator-lookout >= 2.8
Requires: alterator-l10n >= 2.5-alt8
Requires: alterator-browser-qt

%add_findreq_skiplist %_datadir/install2/postinstall.d/*
%add_findreq_skiplist %_datadir/install2/initinstall.d/*

Summary: alterator's wizard like module aggregator
License: GPL
Group: System/Configuration/Other

BuildArch: noarch
BuildPreReq: alterator >= 5.0 guile

# Automatically added by buildreq on Mon Jul 11 2005 (-bi)
BuildRequires: alterator

%description
alterator's wizard like module aggregator

%package usermode
Summary: Usermode bindings for %name
Group: System/Configuration/Other
BuildArch: noarch
Requires: %name = %version-%release
Requires: consolehelper

%description usermode
Usermode bindings for %name

%brp_strip_none %_alterator_libdir/*
%add_verify_elf_skiplist %_alterator_libdir/*
%add_findreq_skiplist %_alterator_libdir/*

%prep
%setup

%build
%make_build

%install
%makeinstall

#install consolehelper
obj=alterator-wizard

install -d %buildroot/%_bindir
ln -s %_libexecdir/consolehelper/helper %buildroot%_bindir/$obj
install -d %buildroot%_sysconfdir/pam.d/

cat>%buildroot%_sysconfdir/pam.d/$obj<<EOF
#%PAM-1.0
auth	sufficient	pam_rootok.so
auth	required	pam_stack.so service=system-auth
account	required	pam_permit.so
password	required	pam_deny.so
session	optional	pam_xauth.so
EOF

install -d %buildroot%_sysconfdir/security/console.apps/
cat>%buildroot%_sysconfdir/security/console.apps/$obj<<EOF
USER=root
PROGRAM=%_sbindir/$obj
SESSION=true
FALLBACK=true
EOF

%files
%_sbindir/*
#%_alterator_libdir/ui/*
%_alterator_datadir/ui/*
%_alterator_backend3dir/*
%_datadir/install2/initinstall.d/*
%_datadir/install2/postinstall.d/*

%files usermode
%config(noreplace) %_sysconfdir/pam.d/*
%config(noreplace) %_sysconfdir/security/console.apps/*
%_bindir/*

%changelog
