Group: Development/Other
BuildRequires: /proc rpm-build-java
BuildRequires: jpackage-11-compat
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global base_name       antunit

Name:           ant-%{base_name}
Version:        1.4
Release:        alt1_2jpp11
Summary:        Provide antunit ant task
License:        ASL 2.0
URL:            http://ant.apache.org/antlibs/%{base_name}/
Source0:        http://www.apache.org/dist/ant/antlibs/%{base_name}/source/apache-%{name}-%{version}-src.tar.bz2
# Do not download ivy
Patch0:         ant-antunit-local.patch
BuildArch:      noarch

BuildRequires:  javapackages-local
BuildRequires:  ant
BuildRequires:  ant-junit
BuildRequires:  ant-testutil
BuildRequires:  ivy-local
Source44: import.info


%description
The <antunit> task drives the tests much like <junit> does for JUnit tests.

When called on a build file, the task will start a new Ant project for that
build file and scan for targets with names that start with "test". For each
such target it then will:

   1. Execute the target named setUp, if there is one.
   2. Execute the target itself - if this target depends on other targets the
      normal Ant rules apply and the dependent targets are executed first.
   3. Execute the target names tearDown, if there is one.


%package javadoc
Group: Development/Java
Summary:       Javadoc for %{name}
BuildArch: noarch

%description javadoc
This package contains the API documentation for %{name}.


%prep
%setup -q -n apache-%{name}-%{version}
%patch0 -p1

cat > build.properties <<EOF
javac.-source=6
javac.-target=1.6
javac.test-source=6
javac.test-target=1.6
EOF
mkdir ivy
build-jar-repository -p ivy ivy
mv CONTRIBUTORS CONTRIBUTORS.orig
iconv -f ISO-8859-1 -t UTF-8 CONTRIBUTORS.orig > CONTRIBUTORS
touch -r CONTRIBUTORS.orig CONTRIBUTORS


%build
ant -Dant.build.javac.source=1.8 -Dant.build.javac.target=1.8  -Divy.mode=local package


%install
%mvn_artifact %{name}-%{version}.pom build/lib/%{name}-%{version}.jar
%mvn_file ":ant-antunit" ant/ant-antunit
%mvn_install -J docs/

# OPT_JAR_LIST fragments
mkdir -p %{buildroot}%{_sysconfdir}/ant.d
echo "ant/%{name}" > %{buildroot}%{_sysconfdir}/ant.d/%{base_name}


%check
# Not resolving local antunit at the moment
ant -Divy.mode=local -lib build/lib test || :


%files -f .mfiles
%doc --no-dereference common/LICENSE NOTICE
%doc CONTRIBUTORS README README.html WHATSNEW
%config(noreplace) %{_sysconfdir}/ant.d/%{base_name}

%files javadoc -f .mfiles-javadoc
%doc --no-dereference common/LICENSE NOTICE


%changelog
