Name: apache2-mod_fcgid
Summary: Apache2 module for high-performance server-side scripting 

Version: 2.3.9
Release: alt3
License: %asl
Group: System/Servers
URL: https://httpd.apache.org/mod_fcgid/

Source0: mod_fcgid-%{version}.tar.gz
Source1: %name-fcgid.conf
Source2: %name-fcgid.load
Source3: %name.init
Source4: %name.service
Source5: %name.preset

Provides: mod_fcgid = %version-%release
Requires(pre): apache2

BuildRequires: rpm-build-licenses

BuildPreReq: apache2-devel libaprutil1-devel libapr1-devel

%description
mod_fcgid is a binary-compatible alternative to the Apache module mod_fastcgi.
mod_fcgid has a new process management strategy, which concentrates on reducing
the number of fastcgi servers, and kicking out corrupt fastcgi servers as soon
as possible.

%prep
%setup -q -n mod_fcgid-%{version}

%build
APXS="/usr/bin/apxs2" ./configure.apxs
%__make top_dir=%apache2_libdir

%install
%__make \
  top_dir=%apache2_libdir \
  DESTDIR=%buildroot \
  MKINSTALLDIRS="%__mkdir_p" \
  install

# we don't really want to install this in the system Apache modules dir
%__mkdir_p %buildroot/%apache2_moduledir
%__mkdir_p %buildroot%apache2_confdir/mods-available/

%__mkdir_p %buildroot%_initdir
%__sed -e 's|@apache2_user@|%apache2_user|' -e 's|@apache2_group@|%apache2_group|' < %SOURCE3 > %buildroot%_initdir/mod_fcgid

%__mkdir_p %buildroot%_unitdir
%__sed -e 's|@apache2_user@|%apache2_user|' -e 's|@apache2_group@|%apache2_group|' < %SOURCE4 > %buildroot%_unitdir/mod_fcgid.service
install -Dm 644 %SOURCE5 %buildroot%_presetdir/90-mod_fcgid.preset

install -m 644 %SOURCE1 %buildroot%apache2_confdir/mods-available/fcgid.conf
install -m 644 %SOURCE2 %buildroot%apache2_confdir/mods-available/fcgid.load

#install -d -m 755 %buildroot%_localstatedir/run/mod_fcgid/fcgid_sock
install -d -m 755 %buildroot%_runtimedir/mod_fcgid/fcgid_sock

rm -rf %buildroot%webserver_datadir/apache2

%post
%post_service mod_fcgid

%preun
%preun_service mod_fcgid

%files
%doc docs/manual/mod/*
%doc CHANGES-FCGID LICENSE-FCGID NOTICE-FCGID README-FCGID STATUS-FCGID

%apache2_moduledir/mod_fcgid.so
%dir %attr(0755,%apache2_user,%apache2_group) %_runtimedir/mod_fcgid
%dir %attr(0755,%apache2_user,%apache2_group) %_runtimedir/mod_fcgid/fcgid_sock
%apache2_confdir/mods-available/*

%attr(0755,root,root) %_initdir/mod_fcgid
%_unitdir/mod_fcgid.service
%_presetdir/90-mod_fcgid.preset

%changelog
