%define php_sapi apache2-mod_php
%define so_file  mod_php%_php_suffix.so

%define apache_module_name php_module
%define mod_conflicts %(echo "%_supported_php_suffix"|sed 's/\\<%{_php_suffix}\\>//;s/ \\+/ /g;s/^[[:space:]]*//;s/[[:space:]]*$//;s/\\([[:graph:]]*\\)/apache2-mod_php\\1/g')

Name: apache2-mod_php%_php_suffix
Version: %php_version
Release: %php_release

Summary: The php HTML-embedded scripting language for use with Apache2

Group: System/Servers
License: PHP-3.01
Url: http://www.php.net/

Source1: php.ini
Source2: apache2-mod_php-browscap.ini

BuildRequires(pre): rpm-build-php8.1-version
BuildRequires: php-devel = %php_version

BuildRequires(pre): rpm-macros-apache2
BuildRequires: apache2-devel apache2-httpd-worker libmm-devel libxml2-devel zlib-devel libsqlite3-devel
BuildRequires: libargon2-devel

Requires: php%_php_suffix = %php_version
Requires: php%_php_suffix >= %php_version-%php_release
Requires: apache2-httpd-prefork-like
Requires(post): apache2-httpd-prefork-like
Requires(post): apache2-base

Conflicts: %mod_conflicts
Provides: apache2-mod_php = %php_version
Provides: php-engine = %php_version-%php_release

%description
PHP is an HTML-embedded scripting language. PHP attempts to make it
easy for developers to write dynamically generated web pages. PHP
also offers built-in database integration for several commercial
and non-commercial database management systems, so writing a
database-enabled web page with PHP is fairly simple. The most
common use of PHP coding is probably as a replacement for CGI
scripts. The mod_php module enables the Apache web server to
understand and process the embedded PHP language in web pages.

This package contains PHP version %_php_suffix. You'll also need to install the
Apache2 web server.


%prep
%setup -T -c
%php_sapi_prepare apache2handler
# changed module name for easier identification in loaded modules list
sed -i "s,apache2handler,apache2-mod_php," sapi_apache2.c

%build
rm -f internal_functions.c

%apache2_apxs \
  $(php-config%_php_suffix --includes) \
  $(php-config%_php_suffix --ldflags) %php_optflags \
  $(php-config%_php_suffix --libs) \
  -I. -I./include -I/usr/include/apache -Iext/date/lib -I/usr/include/libxml2 \
  -DUSE_TRANSFER_TABLES=1 \
  -lphp-%_php_version \
  -o %so_file -c *.c

%install
mkdir -p \
	%buildroot/%apache2_mods_available \
	%buildroot/%apache2_mods_start \
	%buildroot/%apache2_moduledir \
	%buildroot/%php_sysconfdir/%php_sapi/php.d \
	%buildroot/%_rpmlibdir

cp .libs/%so_file %buildroot/%apache2_moduledir

cat > %buildroot/%apache2_mods_available/mod_php%_php_suffix.load <<EOF
LoadModule %apache_module_name %apache2_moduledir/%so_file
EOF

cat > %buildroot/%apache2_mods_available/mod_php%_php_suffix.conf <<EOF
%if "%_php_suffix" == "7"
<IfModule mod_php%{_php_suffix}.c>
%else
<IfModule php_module>
%endif
    AddType    application/x-httpd-php-source   .phps
    AddType    application/x-httpd-php         .php .phtml
    AddHandler application/x-httpd-php         .php .phtml
</IfModule>
EOF

cat > %buildroot/%apache2_mods_start/mod_php%{_php_suffix}.conf << EOF
mod_php%_php_suffix=yes
EOF

cat > %buildroot/%_rpmlibdir/90-php%{_php_suffix}-%name.filetrigger << EOF
#!/bin/sh
LC_ALL=C sed 's|^%php_sysconfdir/%php_sapi/control.d||' |
        grep -Eqs '^%php_sysconfdir/%php_sapi|^%php_extdir' || exit 0
%post_apache2conf
EOF
chmod 755 %buildroot/%_rpmlibdir/90-php%{_php_suffix}-%name.filetrigger

install -m 644 %SOURCE1 %buildroot/%php_sysconfdir/%php_sapi/php.ini
install -m 644 %SOURCE2 %buildroot/%php_sysconfdir/%php_sapi/browscap.ini

for f in \
	%buildroot/%php_sysconfdir/%php_sapi/php.ini
do
  subst 's,@SAPI@,%php_sapi,g' "$f"
  subst 's,@PHP_VERSION@,%_php_version,g' "$f"
  subst 's,@PHP_MAJOR@,%_php_major,g' "$f"
  subst 's,@PHP_LIBDIR@,%_libdir/php,g' "$f"
  subst 's,@HTDOCSDIR@,%apache2_htdocsdir,g' "$f"
  subst 's,@PHP_BROWSCAP@,%php_sysconfdir/%php_sapi/browscap.ini,g' "$f"
  subst 's,@PHP_UPLOADDIR@,%apache2_spooldir/uploads,g' "$f"
  subst 's,@PHP_SESSIONDIR@,%apache2_spooldir/sessions,g' "$f"
done

%preun
%php_sapi_preun

%files
%config(noreplace) %apache2_mods_available/*
%config(noreplace) %apache2_mods_start/*
%dir %php_sysconfdir/%php_sapi
%dir %php_sysconfdir/%php_sapi/php.d
%config(noreplace) %php_sysconfdir/%php_sapi/php.ini
%config(noreplace) %php_sysconfdir/%php_sapi/browscap.ini
%apache2_moduledir/%so_file
%_rpmlibdir/90-php%{_php_suffix}-%name.filetrigger
%doc CREDITS


%changelog
