%define _unpackaged_files_terminate_build 1

%def_with check

Name: apache2-mod_wsgi
Version: 4.9.4
Release: alt0.p10.1

Summary: Python WSGI module for Apache2
Group: System/Servers
License: Apache-2.0
# Source-git: https://github.com/GrahamDumpleton/mod_wsgi
Url: http://www.modwsgi.org

Source: %name-%version.tar
Patch: %name-%version.patch

BuildRequires(pre): apache2-devel
BuildRequires: python3-dev

%if_with check
BuildRequires: nss_wrapper
BuildRequires: socket_wrapper
BuildRequires: pytest3
BuildRequires: python3-module-requests
%endif

%description
The mod_wsgi package implements a simple to use Apache module which can host
any Python web application which supports the Python WSGI specification.

%package py3
Summary: Python3 WSGI module for Apache2
Group: System/Servers
Requires: apache2 >= %apache2_version
Provides: mod_wsgi-py3 = %EVR

%description py3
The mod_wsgi-py3 package implements a simple to use Apache module which can
host any Python3 web application which supports the Python3 WSGI specification.

%prep
%setup
%autopatch -p1

%build
%add_optflags -fno-strict-aliasing
%configure --with-apxs=%apache2_apxs --with-python=python3
%make

%install

mkdir -p %buildroot%apache2_mods_available
%makeinstall_std
mv %buildroot%apache2_moduledir/mod_wsgi{,-py3}.so
echo -e '<IfModule !wsgi_module>\n\tLoadModule wsgi_module %apache2_moduledir/mod_wsgi-py3.so\n</IfModule>' > \
    %buildroot%apache2_mods_available/wsgi-py3.load

%check
%make check DESTDIR=%buildroot

%files

%files py3
%doc *.rst LICENSE
%apache2_moduledir/mod_wsgi-py3.so
%config(noreplace) %apache2_mods_available/wsgi-py3.load

%changelog
