Name: astyle
Version: 3.1
Release: alt2

Summary: A small, fast automatic indentation filter for C/C++/Java code
License: GPL
Group: Development/Other

Url: http://%name.sourceforge.net/
Source: %{name}_%{version}_linux.tar.gz
# Make the astyle-lib usable for arduino
Patch: astyle-arduino.patch

BuildRequires: gcc-c++ java-devel-default

%global majorversion    3
%global soversion       %version

%package -n lib%name
Group: Development/C++
Summary: Separated dynamc library for linking with astyle
%description -n lib%name
Separated dynamc library for linking with astyle

%package -n lib%name-devel
Group: Development/C++
Summary: Separated dynamc library for linking with astyle (development environment)
%description -n lib%name-devel
Separated dynamc library for linking with astyle (development environment)

%description
Artistic Style is a reindenter and reformatter of C++, C and Java source code.

When indenting source code, we as programmers have a tendency to use
both spaces and tab characters to create the wanted
indentation. Moreover, some editors by default insert spaces instead
of tabs when pressing the tab key. Since the NUMBER of space
characters showed on screen for each tab character in the source code
changes between editors (until the user sets up the number to his
liking...), one of the standard problems facing programmers when
moving from one source code editor to another is that code containing
both spaces and tabs that was up to now perfectly indented, suddently
becomes a mess to look at when changing to another editor.

Artistic Style solves this problem by providing a series of filters,
written in C++, that automatically reindent & reformat C/C++/Java
source files. These can be used from a command line, or it can be
incorporated as classes in another C++ program.

%prep
%setup -n %name
%patch -p1
chmod a-x src/*
chmod a-x doc/*

%build
%ifarch %e2k
# -std=c++03 by default as of lcc 1.23.12
%add_optflags -std=c++11
%endif

pushd src
    # it's much easier to compile it here than trying to fix the Makefile
    g++ %optflags -DASTYLE_LIB -DASTYLE_JNI -fPIC -I/usr/lib/jvm/java/include -I/usr/lib/jvm/java/include/linux -c ASBeautifier.cpp ASEnhancer.cpp ASFormatter.cpp ASResource.cpp astyle_main.cpp
    g++ -shared -o libastyle.so.%soversion *.o -Wl,-soname,libastyle.so.%majorversion
    ln -s libastyle.so.%soversion libastyle.so
    g++ %optflags -c ASLocalizer.cpp astyle_main.cpp
    g++ %optflags -o astyle ASLocalizer.o astyle_main.o -L. -lastyle
popd

%install
pushd src
    mkdir -p %buildroot{%_bindir,%_libdir,%_includedir}

    install -p -m 755 astyle %buildroot%_bindir
    install -p -m 755 libastyle.so.%soversion %buildroot%_libdir
    cp -P libastyle.so %buildroot%_libdir
    install -p -m 644 astyle.h %buildroot%_includedir
popd

# hardcoded path! for --help
mkdir -p %buildroot%_datadir/doc/%name/html
install -p -m 644 doc/*.html %buildroot%_datadir/doc/%name/html/

%files
%doc %_datadir/doc/%name
%_bindir/%name

%files -n lib%name
%_libdir/lib*.so.*

%files -n lib%name-devel
%_libdir/lib%name.so
%_includedir/%name.h

%changelog
