Summary: Automated Testing Framework
Group: Development/Tools
Name: atf
Version: 0.21
Release: alt1
License: BSD
Url: http://code.google.com/p/kyua/wiki/ATF
Source0: https://github.com/jmmv/atf/releases/download/%name-%version/%name-%version.tar.gz
Source1: README.Fedora

%define _testsdir %_libexecdir/atf/tests

%define common_description The Automated Testing Framework (ATF) is a collection of libraries to \
implement test programs in a variety of languages.  At the moment, ATF \
offers C, C++ and POSIX shell bindings with which to implement tests. \
These bindings all offer a similar set of functionality and any test \
program written with them exposes a consistent user interface. \
\
ATF-based test programs rely on a separate runtime engine to execute them. \
The runtime engine is in charge of isolating the test programs from the \
rest of the system to ensure that their results are deterministic and that \
they cannot affect the running system.  The runtime engine is also \
responsible for gathering the results of all tests and composing reports. \
The current runtime of choice is Kyua.

# Automatically added by buildreq on Fri Jan 24 2020
# optimized out: glibc-kernheaders-generic glibc-kernheaders-x86 gnu-config libstdc++-devel python2-base sh4
BuildRequires: gcc-c++ git-core

%description
There is no main package being built here.  This is unused.

%prep
%setup

# Put the README.Fedora file in the top-level directory of the source tree so
# that the call below can pick it up.
cp -p %SOURCE1 README.Fedora

%build
%configure INSTALL="/usr/bin/install -p" --disable-static
sed -i 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool
sed -i 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool
make %{?_smp_mflags} pkgtestsdir=%_testsdir testsdir=%_testsdir

%check
make check

%install
make install DESTDIR=%buildroot doc_DATA= \
             pkgtestsdir=%_testsdir testsdir=%_testsdir
rm %buildroot%_libdir/libatf*.la
# Ideally, we would ship one tests package for every component, namely
# libatf-c-tests, libatf-c++-tests and libatf-sh-tests.  However, the test
# suite of ATF has not been written with this in mind, and the tests of one
# component often have dependencies on the rest of the components.  It is
# much easier to ship a single package with the whole test suite rather
# than attempting to fight this fact.
%package tests
Summary: Automated Testing Framework - Test suite
Group: Development/Tools
Requires: libatf-c = %version-%release
Requires: libatf-c++ = %version-%release
Requires: libatf-sh = %version-%release
Requires: libatf-c-devel = %version-%release
Requires: libatf-c++-devel = %version-%release
Requires: libatf-sh-devel = %version-%release

%description tests
%common_description

This package installs the run-time tests for all the components of ATF, which
include tests for the C, C++ and POSIX shell libraries and the run-time tools.
Please see the README.Fedora file in the documentation directory for further
details on how to run the installed tests.

%files tests
%doc README.Fedora
%_testsdir
%_man7dir/atf*

%package -n libatf-c
Group: Development/Tools
Summary: Automated Testing Framework - C bindings

%description -n libatf-c
%common_description

This package provides the run-time libraries to run tests that use the
ATF C bindings.

%files -n libatf-c
%_libdir/libatf-c.so.*
%_datadir/man/man1/atf-test-program*
%_datadir/man/man4/atf-test-case*

%package -n libatf-c-devel
Group: Development/Tools
Summary: Automated Testing Framework - C bindings (headers)
Requires: libatf-c = %version-%release

%description -n libatf-c-devel
%common_description

This package provides the libraries, header files and documentation to
develop tests that use the ATF C bindings.

%files -n libatf-c-devel
%_datadir/aclocal/atf-c.m4
%_datadir/aclocal/atf-common.m4
%_includedir/atf-c.h
%_includedir/atf-c
%_libdir/libatf-c.so
%_libdir/pkgconfig/atf-c.pc
%_man3dir/atf-c-api*
%_man3dir/atf-c.*

%package -n libatf-c++
Group: Development/Tools
Summary: Automated Testing Framework - C++ bindings

%description -n libatf-c++
%common_description

This package provides the run-time libraries to run tests that use the
ATF C++ bindings.

%files -n libatf-c++
%_libdir/libatf-c++.so.*

%package -n libatf-c++-devel
Group: Development/Tools
Summary: Automated Testing Framework - C++ bindings (headers)
Requires: libatf-c = %version-%release
Requires: libatf-c-devel = %version-%release
Requires: libatf-c++ = %version-%release

%description -n libatf-c++-devel
%common_description

This package provides the libraries, header files and documentation to
develop applications that use the ATF C++ bindings.

%files -n libatf-c++-devel
%_datadir/aclocal/atf-c++.m4
%_includedir/atf-c++.hpp
%_includedir/atf-c++
%_libdir/libatf-c++.so
%_libdir/pkgconfig/atf-c++.pc
%_man3dir/atf-c++-api*
%_man3dir/atf-c++.*

%package -n libatf-sh
Group: Development/Tools
Summary: Automated Testing Framework - POSIX shell bindings
Requires: libatf-c++ = %version-%release

%description -n libatf-sh
%common_description

This package provides the run-time libraries to run tests that use the
ATF POSIX shell bindings.

%files -n libatf-sh
%_bindir/atf-sh
# Cheat a bit: While this directory should be supposedly owned by the main
# 'atf' package, 'atf' depends on libatf-sh.  Therefore, it's easier to handle
# ownership here.
%_datadir/atf
%_libexecdir/atf-check
%_man1dir/atf-sh*

%package -n libatf-sh-devel
Group: Development/Tools
Summary: Automated Testing Framework - POSIX shell bindings (headers)
Requires: libatf-sh = %version-%release

%description -n libatf-sh-devel
%common_description

This package provides the supporting files and documentation to develop
applications that use the ATF POSIX shell bindings.

%files -n libatf-sh-devel
%_datadir/aclocal/atf-sh.m4
%_libdir/pkgconfig/atf-sh.pc
%_man1dir/atf-check*
%_man3dir/atf-sh-api*
%_man3dir/atf-sh.*

%changelog
