# BEGIN SourceDeps(oneline):
BuildRequires: perl(RPM/Header.pm) perl(Source/Repository/Mass/ALTLinuxBackport.pm) perl-devel perl-ALTLinux-ACL perl(ALTLinux/RepoList.pm)
# END SourceDeps(oneline)
Name: autorepo-scripts
Version: 0.635
Release: alt1
BuildArch: noarch
Packager: Igor Yu. Vlasenko <viy@altlinux.org>

Summary: common scripts for an automated packaging node
Group: Development/Other
License: GPLv2+
Url: https://www.altlinux.org/Autorepo
Source: %name-%version.tar

Requires: /usr/bin/relative /usr/bin/parallel
Requires: parentlock-sh-functions
# for mail
%filter_from_requires /^mutt/d
Requires: perl(Date/Format.pm) qa-robot /usr/bin/mutt
Requires: autorepo-builder = %EVR

%description
%summary

%package -n autorepo-builder
Summary: autorepo builder scripts
Group: Development/Other
Requires: parentlock-sh-functions
Requires: hsh-clone-workdir > 0.002
Conflicts: autorepo-scripts < 0.622
Obsoletes: autorepo-scripts-common < 0.632

%description -n autorepo-builder
%summary

%package -n autorepo-altnode-misc
Summary: autorepo scripts for an axiliary node
Group: Development/Other

%description -n autorepo-altnode-misc
%summary

%package -n autorepo-altnode-builder
Summary: autorepo scripts for a builder node
Group: Development/Other
Requires: %name = %version-%release

%description -n autorepo-altnode-builder
%summary

%package -n autorepo-altnode-build-merger
Summary: autorepo scripts and config for a builder merge node
Group: Development/Other
Requires: %name = %version-%release
Requires: autorepo-altnode-builder = %version-%release
Conflicts: autorepo-scripts < 0.635

%description -n autorepo-altnode-build-merger
%summary

%package autoports
Summary: autorepo scripts for an autoports node
Group: Development/Other
Requires: /usr/bin/srpmbackport

%description autoports
%summary

%prep
%setup

%build
%perl_vendor_build

%install
%perl_vendor_install

mkdir -p $RPM_BUILD_ROOT%_bindir
cp autoports-* autorepo-* $RPM_BUILD_ROOT%_bindir/
rm $RPM_BUILD_ROOT%_bindir/*.spec

mkdir -p %buildroot%_datadir/%name/templates/
install -m 755 *.template %buildroot%_datadir/%name/templates/

mkdir -p %buildroot%_sysconfdir/sysctl.d
#echo "fs.protected_hardlinks = 0" > %buildroot%_sysconfdir/sysctl.d/20-build-merger.conf
cat > %buildroot%_sysconfdir/sysctl.d/20-build-merger.conf <<EOF
# allow hardlinking files of different users to create merged repository
fs.protected_hardlinks = 0
EOF


%files
%doc configs
%doc crontab
%doc DEPLOY.txt
%_bindir/autorepo*
%perl_vendor_privlib/Autorepo*
%_datadir/%name/templates
# altnode
%exclude %_bindir/autorepo-altnode-*
# builder
%exclude %_bindir/autorepo-build-config
%exclude %_bindir/autorepo-buildhelper-*
%exclude %_bindir/autorepo-build-sh-functions
%exclude %_bindir/autorepo-ls
%exclude %_bindir/autorepo-ls-bad-ugly
%exclude %_bindir/autorepo-parallel-build
%exclude %_bindir/autorepo-sequential-build
# build-merger
%exclude %_bindir/autorepo-merge-repositories

#files autoports
%_bindir/autoports*

%files -n autorepo-builder
%_bindir/autorepo-build-config
%_bindir/autorepo-buildhelper-*
%_bindir/autorepo-build-sh-functions
%_bindir/autorepo-parallel-build
%_bindir/autorepo-sequential-build
# todo: return to autorepo-scripts?
%_bindir/autorepo-ls
%_bindir/autorepo-ls-bad-ugly

%files -n autorepo-altnode-builder
%_bindir/autorepo-altnode-builder-statistics

%files -n autorepo-altnode-build-merger
%config %_sysconfdir/sysctl.d/20-build-merger.conf
%_bindir/autorepo-merge-repositories

%files -n autorepo-altnode-misc
%_bindir/autorepo-altnode-misc-statistics-wrapper

%changelog
