Name:    bcel
Version: 6.8.2
Release: alt1
Epoch: 1
Summary: Byte Code Engineering Library
License: Apache-2.0
Group: Development/Java
URL: http://commons.apache.org/proper/commons-bcel/

BuildArch: noarch

Source0: http://archive.apache.org/dist/commons/bcel/source/bcel-%{version}-src.tar.gz

BuildRequires: /proc rpm-build-java
BuildRequires: jpackage-default
BuildRequires: maven-local
BuildRequires: mvn(org.apache.commons:commons-parent:pom:)

%description
The Byte Code Engineering Library (formerly known as JavaClass) is
intended to give users a convenient possibility to analyze, create, and
manipulate (binary) Java class files (those ending with .class). Classes
are represented by objects which contain all the symbolic information of
the given class: methods, fields and byte code instructions, in
particular.  Such objects can be read from an existing file, be
transformed by a program (e.g. a class loader at run-time) and dumped to
a file again. An even more interesting application is the creation of
classes from scratch at run-time. The Byte Code Engineering Library
(BCEL) may be also useful if you want to learn about the Java Virtual
Machine (JVM) and the format of Java .class files.  BCEL is already
being used successfully in several projects such as compilers,
optimizers, obfuscators and analysis tools, the most popular probably
being the Xalan XSLT processor at Apache.

%package javadoc
Group: Development/Java
Summary:        API documentation for %{name}
BuildArch: noarch

%description javadoc
This package provides %{summary}.

%prep
%setup -q -n %{name}-%{version}-src

%pom_remove_plugin :maven-source-plugin
%pom_remove_plugin :spotbugs-maven-plugin
%pom_remove_plugin :jacoco-maven-plugin
 
%mvn_alias : bcel: apache:
%mvn_file : %name

%build
%mvn_build -f

%install
%mvn_install

%files -f .mfiles
%doc RELEASE-NOTES.txt
%doc --no-dereference LICENSE.txt NOTICE.txt

%files javadoc -f .mfiles-javadoc
%doc --no-dereference LICENSE.txt NOTICE.txt

%changelog
