%define binutils_sourcedir /usr/src/binutils-source

Name: binutils
Version: 2.35.2
Release: alt4
Epoch: 1

Summary: GNU Binary Utility Development Utilities
License: GPLv3+
Group: Development/Other
Url: http://sourceware.org/binutils/

# ftp://ftp.gnu.org/gnu/%name/%name-%version.tar.xz
Source: %name-%version.tar
Source1: bfd.h
Source2: gcc.sh
Source3: g++.sh
Source4: ld.sh
Source5: output-format.sed

Patch: binutils-2_35-branch.patch

# Backports from upstream
Patch1001: 0001-ld-elf-x86-Don-t-compare-IFUNC-address-in-the-shared.patch
Patch1002: 0002-gold-Remove-the-circular-IFUNC-dependency-in-ifuncma.patch

Patch1003: CVE-2021-45078.patch
Patch1004: CVE-2022-38533.patch
Patch1005: CVE-2022-47007.patch
Patch1006: CVE-2022-47010.patch
Patch1007: CVE-2022-47673.patch
Patch1008: CVE-2022-47696.patch
Patch1009: CVE-2022-48064.patch
Patch1010: CVE-2021-46174.patch
Patch1011: CVE-2022-4285.patch
Patch1012: CVE-2022-47008.patch
Patch1013: CVE-2022-47011.patch
Patch1014: CVE-2022-47695.patch
Patch1015: CVE-2022-48063.patch
Patch1016: CVE-2022-44840.patch
Patch1017: CVE-2022-48065.patch
Patch1018: CVE-2023-1972.patch
Patch1019: CVE-2025-5244.patch
Patch1020: CVE-2025-5245.patch

# ALT patches
Patch01: 0001-ld-testsuite-ld-ifunc-pr18808b.c-pass-Wno-return-typ.patch
Patch02: 0002-ld-testsuite-ld-elf-pr22269-1.c-pass-Wno-return-type.patch
Patch03: 0003-bfd-export-demangle.h-and-hashtab.h.patch
Patch04: 0004-ld-add-no-warn-shared-textrel-option.patch
Patch05: 0005-ld-enable-optimization-by-default.patch
Patch06: 0006-ld-testsuite-restore-upstream-default-options.patch
Patch07: 0007-gold-testsuite-use-sysv-hash-style-for-two-tests.patch
Patch08: 0008-readelf-objdump-enable-wide-unconditionally.patch
Patch09: 0009-Drop-redundant-and-misleading-test-headers.patch
Patch10: 0010-Dropped-unused-test-file.patch
Patch11: 0011-Use-wide-output-of-readelf-and-objdump-in-tests.patch
Patch12: 0012-Load-libdebuginfod-library-on-demand.patch
Patch13: 0013-ld-testsuite-ld-cdtest-cdtest.exp-disable-Wstringop-.patch
Patch14: 0014-gold-testsuite-disable-PIE.patch
Patch15: 0015-ld-testsuite-ld-i386-use-z-lazy-binding-for-tests-fa.patch


%def_with debuginfod

# List of architectures worthy to care about test results.
%define check_arches x86_64 %ix86 ppc64le
%def_with check

Conflicts: libbfd
# due to c++filt
Conflicts: gcc-common < 0:1.2.1-alt4

BuildRequires: flex makeinfo perl-Pod-Parser zlib-devel
BuildRequires: gcc-c++ libstdc++-devel-static
%{?!_without_check:%{?!_disable_check:BuildRequires: dejagnu, gcc-c++, glibc-devel-static, zlib-devel-static, bc, /proc, /dev/pts}}
%if_with debuginfod
BuildRequires: libdebuginfod-devel
%endif

%package -n libctf-nobfd0
Summary: Compact C Type Format library (no BFD dependency)
Group: System/Libraries

%package devel
Summary: Development files for development with BFD, opcodes and libiberty libraries
Group: Development/C
Requires: zlib-devel-static
Provides: libiberty-devel = %epoch:%version-%release
Provides: libbfd-devel = %epoch:%version-%release
Obsoletes: libiberty-devel
Obsoletes: libbfd-devel

%package source
Summary: Binutils sources
Group: Development/Other
BuildArch: noarch

%description
Binutils is a collection of binary utilities, including:
+ addr2line: converting addresses to file and line;
+ ar: creating modifying and extracting from archives;
+ nm: listing symbols from object files;
+ objcopy: copying and translating object files;
+ objdump: displaying information from object files;
+ ranlib: generating an index for the contents of an archive;
+ size: listing the section sizes of an object or archive file;
+ strings: listing printable strings from files;
+ strip: discarding symbols.

%description -n libctf-nobfd0
This package includes the libctf-nobfd shared library.  The Compact C Type
Format (CTF) is a way of representing information about a binary program.

%description devel
This package contains include files, dynamic and static libraries needed
for development software based on Binary File Descriptor library and
libiberty.

%description source
This package contains source code of GNU Binutils.

%prep
%setup

%patch -p1
chmod +x gold/testsuite/plugin_pr22868.sh

# Backports from upstream
%patch1001 -p1
%patch1002 -p1

%patch1003 -p1
%patch1004 -p1
%patch1005 -p1
%patch1006 -p1
%patch1007 -p1
%patch1008 -p1
%patch1009 -p1
%patch1010 -p1
%patch1011 -p1
%patch1012 -p1
%patch1013 -p1
%patch1014 -p1
%patch1015 -p1
%patch1016 -p1
%patch1017 -p1
%patch1018 -p1
%patch1019 -p1
%patch1020 -p1

# ALT patches
%patch01 -p1
%patch02 -p1
%patch03 -p1
%patch04 -p1
%patch05 -p1
%patch06 -p1
%patch07 -p1
%patch08 -p1
%patch09 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1

# Replay libtool commits
# a042d335197ac7afb824ab54c3aab91f3e79a2d0
# 9e68384a4fac10585e54519a3f1925cb99d338e8
sed -i -e '
/^      \*32-bit\*)$/ a \
	libsuff=x32
/^      \*64-bit\*)$/ a \
	libsuff=64
s,sys_lib_search_path_spec="/lib /usr/lib /usr/local/lib",sys_lib_search_path_spec="/lib$libsuff /usr/lib$libsuff /usr/local/lib$libsuff",
s,sys_lib_dlsearch_path_spec="/lib /usr/lib",sys_lib_dlsearch_path_spec="/lib$libsuff /usr/lib$libsuff",
s,sys_lib_dlsearch_path_spec="/lib /usr/lib \$lt_ld_extra",sys_lib_dlsearch_path_spec="$sys_lib_dlsearch_path_spec $lt_ld_extra",
s,x86_64-\*kfreebsd\*-gnu|x86_64-\*linux\*|powerpc\*-\*linux\*|,aarch64*-*linux*|riscv64*-*linux*|mips64*-*linux*|&,
' libtool.m4 */configure

sed -i 's/%%{release}/%release/g' bfd/Makefile{.am,.in}

%build
%define _configure_target --host=%_target_platform --build=%_target_platform
%undefine __libtoolize
ADDITIONAL_TARGETS=
%ifarch %ix86 x86_32
ADDITIONAL_TARGETS="--enable-64-bit-bfd"
%endif
%ifarch ia64 x86_64
ADDITIONAL_TARGETS="--enable-targets=i386-alt-linux"
%endif
%ifarch ppc
ADDITIONAL_TARGETS="--enable-targets=powerpc64-alt-linux --enable-targets=spu --enable-64-bit-bfd"
%endif
%configure \
	%{subst_with debuginfod} \
	--with-system-zlib \
	--enable-shared \
	--with-pic \
	--disable-werror \
	--enable-plugins \
	--with-bugurl=http://bugzilla.altlinux.org/ \
	--enable-gold=yes --enable-ld=default \
	--with-stage1-ldflags=' ' \
	--with-boot-ldflags=' ' \
%ifnarch mipsel mips64el
	--enable-default-hash-style=gnu \
%endif
	--enable-relro \
	--enable-textrel-check=warning \
	--enable-deterministic-archives \
	$ADDITIONAL_TARGETS

for t in configure-host maybe-all-{libiberty,bfd,opcodes} all; do
	%make_build MAKEINFOFLAGS=--no-split tooldir=%_prefix $t
done

%install
%makeinstall_std tooldir=%_prefix install-info

# Remove static libctf libraries.
rm %buildroot%_libdir/libctf*.a

# Install ld.default and ld wrapper.
ln -snf ld.bfd %buildroot%_bindir/ld.default
install -pm755 %_sourcedir/ld.sh %buildroot%_bindir/ld

# Install PIC version of the libiberty.a
install -pm644 libiberty/pic/libiberty.a %buildroot%_libdir/

# Remove unrelated manpages.
find %buildroot%_man1dir -type f |while read f; do
	n="${f##*/}"
	n="${n%%.1*}"

	[ -f "%buildroot%_bindir/$n" ] || rm -v "$f"
done

%ifarch %ix86 x86_32 ppc
# Sanity check --enable-64-bit-bfd really works.
grep -Fqsx '#define BFD_ARCH_SIZE 64' %buildroot%_prefix/include/bfd.h
%endif

# Generate .so linker scripts for dependencies; imported from glibc/Makerules:

# Remove symlinks
rm -f %buildroot%_libdir/lib{bfd,opcodes}.so

# This fragment of linker script gives the OUTPUT_FORMAT statement
# for the configuration we are building.
OUTPUT_FORMAT="\
/* Ensure this .so library will not be used by a link for a different format
   on a multi-architecture system.  */
$(gcc $CFLAGS $LDFLAGS -shared -x c /dev/null -o /dev/null -Wl,--verbose -v 2>&1 |
	sed -n -f "%_sourcedir/output-format.sed")"

cat >%buildroot%_libdir/libbfd.so <<EOF
/* GNU ld script */

$OUTPUT_FORMAT

/* The -lz and -ldl dependencies are unexpected by legacy build scripts.  */
INPUT ( %_libdir/libbfd.a -liberty -ldl -lz )
EOF

cat >%buildroot%_libdir/libopcodes.so <<EOF
/* GNU ld script */

$OUTPUT_FORMAT

INPUT ( %_libdir/libopcodes.a -lbfd )
EOF

# Relocate include files.
pushd %buildroot%_includedir
	mkdir bfd
	for f in *.h; do
		mv "$f" bfd/
		ln -s bfd/"$f" .
	done
popd

# Cleanup config.h remnants
sed -i '/PR 14072:/,/^#endif/d' %buildroot%_includedir/bfd/bfd.h
sed -i '/HAVE_STDINT_H/,/^#endif/d; /#include <sys\/types.h>/i#include <stdint.h>' \
	%buildroot%_includedir/bfd/plugin-api.h

# Workaround multilib issues
wordsize=$(printf '%%s\n%%s' '#include <bits/wordsize.h>' '__WORDSIZE' | gcc -E -P -)
mv %buildroot%_includedir/bfd/bfd{,-$wordsize}.h
install -pm644 %_sourcedir/bfd.h %buildroot%_includedir/bfd/

# Add more include files.
install -pm644 include/libiberty.h %buildroot%_includedir/
install -pm644 bfd/{elf-bfd,lib*}.h %buildroot%_includedir/bfd/
cp -a include/{coff,elf} %buildroot%_includedir/bfd/
rm %buildroot%_includedir/bfd/{*in.h,*/ChangeLog*}

# Install NEWS.
for n in binutils gas ld; do
	install -pm644 $n/NEWS NEWS-$n
done

mkdir -p %buildroot%binutils_sourcedir
cp %SOURCE0 %buildroot%binutils_sourcedir/
cp %PATCH0 %buildroot%binutils_sourcedir/

%find_lang binutils bfd gas gold gprof ld opcodes --append --output files.lst

%set_verify_elf_method strict

%check
[ -w /dev/ptmx -a -f /proc/self/maps ] || exit
# testsuite requires gcc to be able to print path to liblto_plugin.so
GCC_PFN_LTO=$(gcc -print-file-name=liblto_plugin.so)
GCC_PPN_LTO=$(gcc -print-prog-name=liblto_plugin.so)
[ "$GCC_PFN_LTO" != 'liblto_plugin.so' -o "$GCC_PPN_LTO" != 'liblto_plugin.so' ] || exit
RUNTESTFLAGS=
XFAIL_TESTS=
%ifarch ppc64le
XFAIL_TESTS="$XFAIL_TESTS script_test_12i"
%endif

%make_build -k check CC="%_sourcedir/gcc.sh" CXX="%_sourcedir/g++.sh" \
	XFAIL_TESTS="$XFAIL_TESTS" RUNTESTFLAGS="$RUNTESTFLAGS" \
%ifnarch %check_arches
    || : \
%endif
    #

%files -f files.lst
%_bindir/*
%_prefix/lib/ldscripts/
%_mandir/man?/*
%_libdir/libopcodes-*.so
%_libdir/libbfd-*.so
%_libdir/libctf.so.0*
%_infodir/*.info*
%exclude %_infodir/bfd.info*
%doc NEWS*

%files -n libctf-nobfd0
%_libdir/libctf-nobfd.so.0*

%files devel
%_libdir/*.a
%_libdir/libbfd.so
%_libdir/libopcodes.so
%_libdir/libctf-nobfd.so
%_libdir/libctf.so
%_includedir/bfd/
%_includedir/*.h
%_infodir/bfd.info*

%files source
%binutils_sourcedir

%changelog
