%define if_ver_gt() %if "%(rpmvercmp '%1' '%2')" > "0"
%define if_ver_gteq() %if "%(rpmvercmp '%1' '%2')" >= "0"
%define if_ver_lt() %if "%(rpmvercmp '%2' '%1')" > "0"
%define if_ver_lteq() %if "%(rpmvercmp '%2' '%1')" >= "0"

%{expand: %(sed 's,^%%,%%global ,' /usr/lib/rpm/macros.d/ubt)}
%define ubt_id %__ubt_branch_id

%define bumblebeed_group xgrp
%define pm_metod bbswitch

Name: bumblebee
Version: 3.2.1
Release: alt12

Summary: Bumblebee - support for NVidia Optimus laptops on Linux
Group: System/Kernel and hardware
License: GPLv3
Url: http://bumblebee-project.org

Source: %name-%version.tar
Source1: bumblebeed.in
Source2: bumblebee_detect_optimus

# Configure the name of the Bumbleblee server group
Patch1: %name-3.1-alt-CONF_GID.patch
# https://github.com/Bumblebee-Project/Bumblebee/issues/699
Patch2: nvidia_modeset-detection_bug699_01.patch
Patch3: nvidia_modeset-detection_bug699_02.patch
Patch4: nvidia_umv_detection_bug699.patch
# https://github.com/Bumblebee-Project/Bumblebee/issues/573
Patch5: hexadicimal_bug573.patch
Patch6: nvidia_modeset-detection_bug699_03.patch
Patch7: alt-disable-xdrvswitch.patch

Requires: VirtualGL
%ifarch %ix86 x86_64
Requires: nvidia_glx_common
%endif
# see ALT #29213
# Requires: bbswitch

BuildRequires(pre): rpm-build-ubt
BuildRequires: help2man libX11-devel glib2-devel
BuildRequires: libbsd-devel >= 0.2.0

%description
Bumblebee daemon is a rewrite of the original Bumblebee service,
providing an elegant and stable means of managing Optimus hybrid
graphics chipsets. A primary goal of this project is to not only enable
use of the discrete GPU for rendering, but also to enable smart power
management of the dGPU when it's not in use.

To enable power management functionality you need to install
kernel-modules-bbswitch package for your running kernel.


%prep
%setup
%patch1 -b .gid
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%if_ver_lt %ubt_id M90
%patch7 -p1
%endif

cp %SOURCE1 scripts/sysvinit/

%build
%add_optflags -fcommon
%autoreconf
%configure CONF_GID=%bumblebeed_group \
	CONF_DRIVER=nvidia \
	CONF_DRIVER_MODULE_NVIDIA=nvidia \
	CONF_LDPATH_NVIDIA=%_x11sysconfdir/lib_nvidia/current \
	CONF_MODPATH_NVIDIA=%_x11sysconfdir/%{_lib}_nvidia/current,%_x11modulesdir \
	CONF_PM_METHOD=%pm_metod

%make_build

%install
%makeinstall_std

install -pD -m644 scripts/systemd/bumblebeed.service %buildroot/%systemd_unitdir/bumblebeed.service
install -pD -m755 scripts/sysvinit/bumblebeed %buildroot/%_initdir/bumblebeed
install -pD -m755 %SOURCE2 %buildroot/%_sysconfdir/firsttime.d/`basename %SOURCE2`

%pre
groupadd -r -f %bumblebeed_group

%post
%post_service bumblebeed

%preun
%preun_service bumblebeed

%files
%_sbindir/bumblebeed
%_bindir/optirun
%exclude %_bindir/%name-bugreport
/lib/udev/rules.d/99-bumblebee-nvidia-dev.rules
%_sysconfdir/bash_completion.d/%name
%_sysconfdir/firsttime.d/*
%dir %_sysconfdir/%name
%config %_sysconfdir/%name/%name.conf
%config %_sysconfdir/%name/xorg.conf.nouveau
%config %_sysconfdir/%name/xorg.conf.nvidia
%dir %_sysconfdir/%name/xorg.conf.d
%config %_sysconfdir/%name/xorg.conf.d/10-dummy.conf
%config %systemd_unitdir/bumblebeed.service
%config %_initdir/bumblebeed
%_man1dir/bumblebeed.1*
%_man1dir/optirun.1*
%doc README.markdown doc/RELEASE_NOTES*

%exclude %_docdir/bumblebee

%changelog
