%def_without scglib
%def_disable gcdmaster

Name: cdrdao
Version: 1.2.4
Release: alt1

Summary: Cdrdao - Write audio CD-Rs in disk-at-once mode
Group: Archiving/Cd burning
License: GPLv2
Url: http://cdrdao.sourceforge.net

Source: http://prdownloads.sourceforge.net/%name/%name-%version.tar.bz2
Source1: %name.control
PreReq: control

%define lame_ver 3.100

BuildRequires: gcc-c++ libacl-devel libao-devel liblame-devel >= %lame_ver
BuildRequires: libmad-devel libvorbis-devel
BuildRequires: libGConf-devel
%{?_enable_gcdmaster:BuildRequires: libgnomeuimm-devel}

%description
Writes audio CD-Rs in disc-at-once (DAO) mode allowing
control over pre-gaps (length down to 0, nonzero audio data)
and sub-channel information like ISRC codes. All data that
is written to the disc must be specified with a text file.
Audio data may be in WAVE or raw format.

%package -n gcdmaster
Summary: Graphical front end to cdrdao for composing audio CDs
Group: Archiving/Cd burning
Requires: %name = %version-%release

%description -n gcdmaster
gcdmaster allows the creation of toc-files for cdrdao and
can control the recording process. Its main application is
the composition of audio CDs from one or more audio files.
It supports PQ-channel editing, entry of meta data like
ISRC codes/CD-TEXT and non destructive cut of the audio data.

%prep
%setup
#subst 's,<linux/../scsi/scsi.h>,<scsi/scsi.h>,' dao/sg_err.h

%build
%add_optflags -D_FILE_OFFSET_BITS=64
%autoreconf
%configure \
	--with-mp3-support \
	--with-ogg-support \
	%{?_disable_gcdmaster:--without-gcdmaster} \
	%{subst_with scglib}

%make_build

%install
%makeinstall_std

# control support
install -pD -m755 %SOURCE1 %buildroot%_controldir/%name
chmod 700 %buildroot%_bindir/%name

%pre
%pre_control %name

%post
%post_control %name

%files
%_bindir/*
%_datadir/%name
%_man1dir/*
%config /etc/control.d/facilities/%name
%doc README CREDITS ChangeLog

%if_enabled gcdmaster
%files -n gcdmaster
%_bindir/gcdmaster
%_desktopdir/*
%_datadir/pixmaps/*
%_man1dir/gcdmaster*
%endif

%changelog
