Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: /usr/bin/ccache boost-devel boost-python-devel cmake glib2-devel libGL-devel libGLES-devel libSDL2-devel libSDL2_image-devel libatk-devel libcairo-devel libgtk+2-devel libminizip-devel libpango-devel pkgconfig(tinyxml2) python-devel rpm-build-python
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           cegui
Version:        0.8.7
Release:        alt7_14
Summary:        Free library providing windowing and widgets for graphics APIs / engines
License:        MIT
URL:            http://www.cegui.org.uk
Source0:        http://downloads.sourceforge.net/crayzedsgui/cegui-%{version}.tar.bz2
Patch0:         cegui-0.8.4-lua53.patch
Patch1:         cegui-0.8.7-alt-default-cxx14.patch
Patch2:         cegui-0.8.7-alt-nullptr.patch

ExcludeArch: %arm

BuildRequires:  gcc-c++
%ifnarch %e2k
BuildRequires:  libdevil-devel
%endif
BuildRequires:  libfreeimage-devel
BuildRequires:  libexpat-devel
BuildRequires:  libfreetype-devel > 2.0.0
BuildRequires:  libxml2-devel
BuildRequires:  libICE-devel
BuildRequires:  libglm-devel
BuildRequires:  libGLU-devel
BuildRequires:  libtool
BuildRequires:  libSM-devel
BuildRequires:  lua-devel >= 0.5.2
BuildRequires:  libpcre-devel libpcrecpp-devel
BuildRequires:  SILLY-devel
BuildRequires:  tolua++-devel >= 1.0.93
BuildRequires:  tinyxml-devel
BuildRequires:  libGLEW-devel
BuildRequires:  libogre-devel >= 1.7.0
BuildRequires:  libois-devel
BuildRequires:  libirrlicht-devel >= 1.8
BuildRequires:  doxygen
BuildRequires:  graphviz libgraphviz
# We no longer build a python subpackage as the python bindings are
# broken when building with gcc6 / boost-1.60 and no-one uses them
Obsoletes:      %{name}-python < %{version}-%{release}
# Idem for the xerces-xmlparser (broken with recent xerces versions)
Obsoletes:      %{name}-xerces-xmlparser < %{version}-%{release}
Source44: import.info

%description
Crazy Eddie's GUI System is a free library providing windowing and widgets for
graphics APIs / engines where such functionality is not natively available, or
severely lacking. The library is object orientated, written in C++, and
targeted at games developers who should be spending their time creating great
games, not building GUI sub-systems!


%package devel
Group: Development/Other
Summary:        Development files for cegui
Requires:       %{name} = %{version}-%{release}
%ifnarch %e2k
Requires:       %{name}-DevIL-imagecodec = %{version}-%{release}
%endif
Requires:       %{name}-freeimage-imagecodec = %{version}-%{release}
Requires:       %{name}-irrlicht-renderer = %{version}-%{release}
Requires:       %{name}-ogre-renderer = %{version}-%{release}
Requires:       %{name}-null-renderer = %{version}-%{release}
Requires:       %{name}-libxml-xmlparser = %{version}-%{release}
Requires:       %{name}-tinyxml-xmlparser = %{version}-%{release}

%description devel
Development files for cegui


%package devel-doc
Group: Documentation
Summary:        API documentation for cegui
Requires:       cegui = %{version}-%{release}

%description devel-doc
API and Falagard skinning documentation for cegui


%package samples
Group: System/Libraries
Summary:        Executable samples provided with the library
Requires:       cegui = %{version}-%{release}

%description samples
Several interactive sample programs demonstrating functionality of
the CEGUI library.


%package DevIL-imagecodec
Group: System/Libraries
Summary:        Alternative imagecodec library for CEGUI using DevIL
Requires:       cegui = %{version}-%{release}

%description DevIL-imagecodec
Alternative imagecodec library for CEGUI using DevIL.


%package freeimage-imagecodec
Group: System/Libraries
Summary:        Alternative imagecodec library for CEGUI using freeimage
Requires:       cegui = %{version}-%{release}

%description freeimage-imagecodec
Alternative imagecodec library for CEGUI using freeimage.


%package irrlicht-renderer
Group: System/Libraries
Summary:        Irrlicht renderer for CEGUI
Requires:       cegui = %{version}-%{release}

%description irrlicht-renderer
Irrlicht renderer for CEGUI.


%package ogre-renderer
Group: System/Libraries
Summary:        OGRE renderer for CEGUI
Requires:       cegui = %{version}-%{release}

%description ogre-renderer
OGRE renderer for CEGUI.


%package null-renderer
Group: System/Libraries
Summary:        Null renderer for CEGUI
Requires:       cegui = %{version}-%{release}

%description null-renderer
Null renderer for CEGUI. Useful for headless deployments or unit testing.


%package libxml-xmlparser
Group: System/Libraries
Summary:        Alternative xml parsing library for CEGUI using libxml
Requires:       cegui = %{version}-%{release}

%description libxml-xmlparser
Alternative xml parsing library for CEGUI using libxml.


%package tinyxml-xmlparser
Group: System/Libraries
Summary:        Alternative xml parsing library for CEGUI using tinyxml
Requires:       cegui = %{version}-%{release}

%description tinyxml-xmlparser
Alternative xml parsing library for CEGUI using tinyxml.


%prep
%setup
%patch0 -p1
%patch1 -p2
%patch2 -p2
find -name "*.orig" -exec rm -f {} ';'


%build
%{fedora_cmake} \
-D CMAKE_INSTALL_DOCDIR=%{_docdir}/%{name} \
-D CEGUI_BUILD_IMAGECODEC_SDL2=false \
-D CEGUI_BUILD_IMAGECODEC_STB=false \
-D CEGUI_BUILD_IMAGECODEC_TGA=false \
-D CEGUI_BUILD_PYTHON_MODULES=false \
-D CEGUI_BUILD_RENDERER_DIRECTFB=false \
-D CEGUI_BUILD_XMLPARSER_XERCES=false \
-D CEGUI_OPTION_DEFAULT_XMLPARSER=ExpatParser \
-D CEGUI_OPTION_DEFAULT_IMAGECODEC=SILLYImageCodec \
-D CEGUI_BUILD_RENDERER_NULL=true \
-D CEGUI_BUILD_TESTS=false \
.

%make_build
make html %{?_smp_mflags}


#%check
# CEGUITests is in $BUILDDIR/bin, datafiles are in $BUILDDIR/datafiles
#CEGUI_SAMPLE_DATAPATH=../datafiles ctest -V


%install
make install DESTDIR=%{buildroot} 
mkdir -p %{buildroot}/%{_docdir}/cegui-0.8.4/
cp -r doc/doxygen/html %{buildroot}/%{_docdir}/cegui-0.8.4/

# CEGUITests is not very useful to install
find $RPM_BUILD_ROOT -name "CEGUITests-0.8" -exec rm -f {} ';'











%files
%doc README.md
%doc --no-dereference COPYING
%{_libdir}/libCEGUIBase-0.so.*
%{_libdir}/libCEGUICommonDialogs-0.so.*
%{_libdir}/libCEGUILuaScriptModule-0.so.*
%{_libdir}/libCEGUIOpenGLRenderer-0.so.*
%{_libdir}/cegui-0.8/libCEGUICoreWindowRendererSet.so
# this is the default parser, that's why it's not split off into a subpackage
%{_libdir}/cegui-0.8/libCEGUIExpatParser.so
# same with silly image codec
%{_libdir}/cegui-0.8/libCEGUISILLYImageCodec.so

%files devel
%{_libdir}/libCEGUI*-0.so

%{_bindir}/toluappcegui-0.8

%{_libdir}/pkgconfig/CEGUI-0.pc
%{_libdir}/pkgconfig/CEGUI-0-OPENGL.pc
%{_libdir}/pkgconfig/CEGUI-0-OPENGL3.pc
%{_libdir}/pkgconfig/CEGUI-0-OGRE.pc
%{_libdir}/pkgconfig/CEGUI-0-NULL.pc
%{_libdir}/pkgconfig/CEGUI-0-LUA.pc
%{_libdir}/pkgconfig/CEGUI-0-IRRLICHT.pc

%{_includedir}/cegui-0

%{_datadir}/cegui-0

%files devel-doc
%doc %{_docdir}/cegui-0.8.4/html

%files samples
%{_bindir}/CEGUISampleFramework-0.8
%{_libdir}/cegui-0.8/libCEGUI*Demo.so
%{_libdir}/cegui-0.8/libCEGUIDemo6.so
%{_libdir}/cegui-0.8/libCEGUIMinesweeper.so

%files irrlicht-renderer
%{_libdir}/libCEGUIIrrlichtRenderer-0.so.*

%files ogre-renderer
%{_libdir}/libCEGUIOgreRenderer-0.so.*

%files null-renderer
%{_libdir}/libCEGUINullRenderer-0.so.*

%ifnarch %e2k
%files DevIL-imagecodec
%{_libdir}/cegui-0.8/libCEGUIDevILImageCodec.so
%endif

%files freeimage-imagecodec
%{_libdir}/cegui-0.8/libCEGUIFreeImageImageCodec.so

%files libxml-xmlparser
%{_libdir}/cegui-0.8/libCEGUILibXMLParser.so

%files tinyxml-xmlparser
%{_libdir}/cegui-0.8/libCEGUITinyXMLParser.so

%changelog
