%def_disable snapshot
%define _unpackaged_files_terminate_build 1

%define ver_major 44
%define beta %nil
%define api_ver 3.0
%define xdg_name org.gnome.Cheese
%define gst_api_ver 1.0
%define _libexecdir %_prefix/libexec

%def_enable gtk_doc
%def_enable man
%def_enable introspection
%def_disable check

Name: cheese
Version: %ver_major.0.1
Release: alt1%beta

Summary: Cheese is a Photobooth-inspired application for taking pictures and videos
License: GPL-2.0
Group: Video
Url: https://wiki.gnome.org/Apps/Cheese

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/cheese/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version.tar
%endif

%define glib_ver 2.40.0
%define gtk_ver 3.14.0
%define desktop_ver 3.0.0
%define gst_ver 1.4.0
%define vala_ver 0.18.0
%define clutter_ver 1.13.2
%define clutter_gst_ver 3.0.16

Requires: lib%name = %version-%release
Requires: gnome-video-effects
Requires: gst-plugins-base%gst_api_ver
# camerabin used for taking photos and videos
Requires: gst-plugins-bad%gst_api_ver
# matroska (webmmux), vp8enc
Requires: gst-plugins-good%gst_api_ver
Requires: gst-plugins-ugly%gst_api_ver
Requires: gst-libav

BuildRequires(pre): rpm-macros-meson rpm-build-gir
BuildRequires: meson vala-tools >= %vala_ver
BuildRequires: yelp-tools desktop-file-utils libappstream-glib-devel
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: libgnome-desktop3-devel >= %desktop_ver
BuildRequires: libdbus-devel
BuildRequires: gst-plugins%gst_api_ver-devel >= %gst_ver
BuildRequires: gst-plugins-bad%gst_api_ver-devel >= %gst_ver
BuildRequires: gstreamer%gst_api_ver-utils >= %gst_ver
BuildRequires: gst-plugins-good%gst_api_ver >= %gst_ver
BuildRequires: libclutter-devel >= %clutter_ver
BuildRequires: libclutter-gst3.0-devel >= %clutter_gst_ver
BuildRequires: librsvg-devel libcanberra-gtk3-devel libcanberra-vala
BuildRequires: libgudev-devel libclutter-gtk3-devel
BuildRequires: libX11-devel libXtst-devel libXext-devel
BuildRequires: gnome-video-effects-devel gsettings-desktop-schemas-devel
#BuildRequires: nautilus-sendto-devel
BuildRequires: libappstream-glib-devel
%{?_enable_introspection:BuildRequires: libgdk-pixbuf-gir-devel libcogl-gir-devel libclutter-gir-devel libgstreamer%gst_api_ver-gir-devel}
%{?_enable_gtk_doc:BuildRequires: gtk-doc}
%{?_enable_check:BuildRequires: /proc xvfb-run dbus-tools-gui}

%description
Cheese is a Photobooth-inspired GNOME application for taking pictures
and videos from a webcam. It also includes fancy graphical effects
based on the gstreamer-backend.

%package -n lib%name
Summary: Cheese libraries
Group: System/Libraries

%description -n lib%name
Cheese is a Photobooth-inspired GNOME application for taking pictures
and videos from a webcam. It also includes fancy graphical effects
based on the gstreamer-backend. This package contains Cheese libraries.

%package -n lib%name-devel
Summary: Cheese development files
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
This package contains files necessary to develop applications that use
Cheese libraries.

%package -n lib%name-devel-doc
Summary: Cheese development documentation
Group: Development/Documentation
BuildArch: noarch
Conflicts: lib%name-devel < %version

%description -n lib%name-devel-doc
This package contains documentation necessary to develop applications
that use Cheese libraries.

%package -n lib%name-gir
Summary: GObject introspection data for the Cheese
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for the Cheese library.

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the Cheese
Group: Development/Other
BuildArch: noarch
Requires: lib%name-gir = %version-%release
Requires: lib%name-devel = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the Cheese library.


%prep
%setup -n %name-%version%beta

%build
%meson \
	%{?_disable_gtk_doc:-Dgtk_doc=false} \
	%{?_disable_man:-Dman=false}
%nil
%meson_build

%install
%meson_install
%find_lang --with-gnome %name

%check
xvfb-run %__meson_test

%files -f %name.lang
%_bindir/%name
%_desktopdir/%xdg_name.desktop
%_datadir/icons/hicolor/*/*/*.*
%_datadir/metainfo/%xdg_name.appdata.xml
%_datadir/dbus-1/services/%xdg_name.service
%config %_datadir/glib-2.0/schemas/*
%{?_enable_man:%_man1dir/%name.1.*}
%doc AUTHORS NEWS README

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc

%if_enabled gtk_doc
%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/*
%endif

%if_enabled introspection
%files -n lib%name-gir
%_typelibdir/Cheese-%api_ver.typelib

%files -n lib%name-gir-devel
%_girdir/Cheese-%api_ver.gir
%endif

%changelog
