%define vendorzone ru.

Name: chrony
Version: 4.5
Release: alt1

Summary: Chrony clock synchronization program
License: GPLv2
Group: System/Configuration/Other

Url: http://chrony.tuxfamily.org
Source0: http://download.tuxfamily.org/chrony/%name-%version.tar
Source1: clknetsim-chrony-%version.tar
Patch0: %name-%version-alt.patch
Source2: chronyd.init
Source3: chrony.sh

BuildRequires: libcap-devel libncurses-devel libedit-devel
BuildRequires: libnss-devel asciidoctor lynx libseccomp-devel
BuildRequires: libgnutls-devel
BuildRequires: libnettle-devel
BuildRequires: makeinfo control
BuildRequires: pps-tools-devel
# for tests
BuildRequires: /proc gcc-c++ /dev/kvm rpm-build-vm

Provides: ntp-server

Conflicts: ntpd openntpd

%define _localstatedir %_var

%description
A pair of programs for keeping computer clocks accurate. chronyd is a daemon
program and chronyc is a command-line interface to it. Time reference sources
for chronyd can be RFC1305 NTP servers, human (via keyboard and chronyc), and
the computer's real-time clock at boot time. chronyd can determine the rate at
which the computer gains or loses time and compensate for it whilst no external
reference is present. chronyd's use of NTP servers can be switched on and off
(through chronyc) to support computers with dial-up/intermittent access to the
Internet. chronyd can also act as an RFC1305-compatible NTP server.

%prep
%setup -a 1
%patch0 -p1
mv clknetsim-chrony-* test/simulation/clknetsim
# prepare git sources (make_release)
# version in version.txt file
echo %version > version.txt

# regenerate the file from getdate.y
rm -f getdate.c

# use our vendor zone
sed -e 's|\([0-3]\.\)\(pool.ntp.org\)|\1%{vendorzone}\2|' \
        < examples/chrony.conf.example2 > chrony.conf

echo '# Keys used by chronyd for command and NTP authentication' > chrony.keys

echo '# Pass extra arguments to chronyd' > chronyd.sysconfig
echo '#CHRONYD_ARGS=' >> chronyd.sysconfig

sed -i -e 's/OPTIONS/CHRONYD_ARGS/' examples/chronyd.service

%build
%configure \
	--with-user=_chrony \
	--with-hwclockfile=%_sysconfdir/adjtime \
	--chronyrundir=/run/chrony \
	--with-pidfile=/run/chrony/chronyd.pid \
	--enable-ntp-signd \
	--enable-scfilter \
	--with-ntp-era=$(date -d '1970-01-01 00:00:00+00:00' +'%%s') \
	--with-sendmail=%_sbindir/sendmail

%make_build all docs 
make -C doc txt

%check
export CLKNETSIM_RANDOM_SEED=34653
%make_build -C test/simulation/clknetsim
%make check

# chronyc dump + scfilter always falls when working in virtual environment under fakeroot, but in 
# real system it works fine. need to investigate
rm -f test/system/099-scfilter

# system tests must be run in kvm with fakeroot for permissions override
pushd test/system
vm-run fakeroot ./run
popd

%install
%makeinstall_std
install -pD -m755 %SOURCE2 %buildroot%_initrddir/chronyd
install -pD -m644 chrony.conf %buildroot%_sysconfdir/chrony.conf
install -pD -m644 chrony.keys %buildroot%_sysconfdir/chrony.keys
install -pD -m755 examples/chrony.nm-dispatcher.dhcp %buildroot%_sysconfdir/NetworkManager/dispatcher.d/20-chrony-dhcp
install -pD -m755 examples/chrony.nm-dispatcher.onoffline %buildroot%_sysconfdir/NetworkManager/dispatcher.d/21-chrony-onoffline
install -pD -m644 examples/chrony.logrotate %buildroot%_sysconfdir/logrotate.d/chrony
install -pD -m644 chronyd.sysconfig %buildroot%_sysconfdir/sysconfig/chronyd
install -pD -m644 examples/chronyd.service %buildroot%_unitdir/chronyd.service
install -pD -m644 examples/chrony-wait.service %buildroot%_unitdir/chrony-wait.service
install -pD -m755 %SOURCE3 %buildroot%_sysconfdir/control.d/facilities/chrony

install -d %buildroot/lib/systemd/ntp-units.d

echo 'chronyd.service' > \
        %buildroot/lib/systemd/ntp-units.d/50-chronyd.list

rm -rf %buildroot/usr/doc
install -d %buildroot%_localstatedir/{lib,log}/%name
touch %buildroot%_localstatedir/lib/%name/{drift,rtc}

mkdir -p  %buildroot%_tmpfilesdir
echo 'd /run/chrony 0750 _chrony _chrony' >> %buildroot%_tmpfilesdir/chronyd.conf

%pre
%_sbindir/groupadd -r -f _chrony 2> /dev/null ||:
%_sbindir/useradd -r -g _chrony -d %_localstatedir/lib/%name -s /dev/null -c "Chrony User" _chrony 2> /dev/null ||:

%post
# Move old configs to /etc
[ -e %_sysconfdir/%name/chrony.conf ] && mv %_sysconfdir/%name/chrony.conf %_sysconfdir/chrony.conf >/dev/null 2>&1 || :
[ -e %_sysconfdir/%name/chrony.keys ] && mv %_sysconfdir/%name/chrony.keys %_sysconfdir/chrony.keys >/dev/null 2>&1 || :

%post_service chronyd

%preun
%preun_service chronyd

%files
%doc COPYING NEWS README doc/*.txt
%_initrddir/chronyd
%_unitdir/*.service
/lib/systemd/ntp-units.d/50-chronyd.list
%config(noreplace) %_sysconfdir/sysconfig/chronyd
%config(noreplace) %_sysconfdir/chrony.conf
%config(noreplace) %verify(not md5 size mtime) %attr(640,root,_chrony) %_sysconfdir/chrony.keys
%config(noreplace) %_sysconfdir/logrotate.d/chrony
%config(noreplace) %_sysconfdir/control.d/facilities/chrony
%_tmpfilesdir/chronyd.conf
%_sysconfdir/NetworkManager/dispatcher.d/20-chrony-dhcp
%_sysconfdir/NetworkManager/dispatcher.d/21-chrony-onoffline
%_bindir/*
%_sbindir/*
%dir %attr(-,_chrony,_chrony) %_localstatedir/lib/%name
%ghost %attr(-,_chrony,_chrony) %_localstatedir/lib/%name/drift
%ghost %attr(-,_chrony,_chrony) %_localstatedir/lib/%name/rtc
%dir %attr(1775,root,_chrony) %_localstatedir/log/%name
%_man1dir/*
%_man5dir/*
%_man8dir/*

%changelog
