%define ver_major 5.6
%define api_ver 1.0

%def_disable debug
%def_disable static
%def_enable systemd
%def_enable ibus
%def_enable onlineaccounts

Name: cinnamon-control-center
Version: %ver_major.1
Release: alt1

Summary: Cinnamon Control Center
License: GPLv2+
Group: Graphical desktop/GNOME
Url: https://github.com/linuxmint/cinnamon-control-center

Source: %name-%version.tar

# From configure.ac
%define gtk_ver 3.5.13
%define glib_ver 2.31.0
%define desktop_ver 1.9.0
#%define clutter_ver 1.11.3
%define fontconfig_ver 1.0.0
%define xft_ver 2.1.2
%define libmetacity_ver 2.30.0
%define gsds_ver 3.6.0
%define notify_ver 0.7.3
%define nm_ver 1.2.0
%define gnome_menus_ver 3.5.5
%define goa_ver 3.5.90
%define sett_daemon_ver 0.0.1
%define bt_ver 3.5.92
%define systemd_ver 40
%define ibus_ver 1.4.99

Requires: %name-data = %version-%release
Requires: %name-translations

# For /usr/share/gnome
Requires: gnome-filesystem
Requires: cinnamon-settings-daemon
# for graphical passwd changing apps
Requires: accountsservice
#Requires: userpasswd
Requires: gnome-online-accounts >= %goa_ver
BuildPreReq: rpm-build-gnome >= 0.9

# From configure.in
BuildPreReq: gnome-common desktop-file-utils gnome-doc-utils gtk-doc xsltproc
BuildPreReq: fontconfig-devel >= %fontconfig_ver
BuildPreReq: libXft-devel >= %xft_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: glib2-devel >= %glib_ver
BuildPreReq: libcinnamon-desktop-devel >= %desktop_ver
BuildPreReq: libnotify-devel >= %notify_ver
BuildPreReq: cinnamon-settings-daemon-devel >= %sett_daemon_ver
BuildRequires: meson
BuildRequires: libxkbfile-devel
%{?_enable_ibus:BuildPreReq: libibus-devel >= %ibus_ver}
BuildRequires: libGConf-devel libdbus-glib-devel libupower-devel libpolkit1-devel
BuildRequires: libgio-devel librsvg-devel libxml2-devel
BuildRequires: libX11-devel libXext-devel libSM-devel libXScrnSaver-devel libXt-devel
BuildRequires: libXft-devel libXi-devel libXrandr-devel libXrender-devel libXcursor-devel libXcomposite-devel
BuildRequires: libgtop-devel libcups-devel iso-codes-devel
BuildRequires: libpwquality-devel libkrb5-devel
BuildRequires: libgnomekbd-devel libxklavier-devel
BuildRequires: libwacom-devel
BuildRequires: libcinnamon-menus-devel
BuildRequires: libgudev-devel

BuildRequires: glibc-i18ndata
BuildRequires: libnm-devel >= %nm_ver
BuildRequires: libnma-devel >= %nm_ver
BuildRequires: libmm-glib-devel
BuildRequires: libgnome-online-accounts-devel >= %goa_ver colord-devel
BuildRequires: libgnome-bluetooth-devel >= %bt_ver
BuildRequires: libclutter-gtk3-devel
%{?_enable_systemd:BuildRequires: systemd-devel >= %systemd_ver libsystemd-login-devel}

%description
Cinnamon is an attractive and easy-to-use GUI desktop environment. The control-center package
provides the Cinnamon Control Center utilities that allow you to setup
and configure your Cinnamon environment (things like the desktop
background and theme, the screensaver, the window manager, system
sounds, and mouse behavior).

If you install Cinnamon, you need to install control-center.

%package data
Summary: Arch independent files for Cinnamon Control Center
Group: Networking/Instant messaging
BuildArch: noarch

%description data
This package provides noarch data needed for Cinnamon Control Center to work.

%package devel
Summary: Cinnamon Control Center development files
Group: Development/GNOME and GTK+
Requires: %name = %version-%release

%description devel
If you're interested in developing panels for the Cinnamon control center,
you'll want to install this package.

%name-devel helps you create the panels for the control center.

%prep
%setup

%build
%meson
%meson_build

%install
%meson_install

%find_lang %name-timezones

%files
#cinnamon-control-center binary doesn't work at x64 so temporary disable it.
%exclude %_bindir/*
%dir %_libdir/%{name}-1/panels
%_libdir/%{name}-1/panels/libcolor.so
%_libdir/%{name}-1/panels/libdisplay.so
%_libdir/%{name}-1/panels/libnetwork.so
%_libdir/%{name}-1/panels/libregion.so
%_libdir/%{name}-1/panels/libwacom-properties.so
%{?_enable_onlineaccounts:%_libdir/%{name}-1/panels/libonline-accounts.so}
%_libdir/*.so.*

%files data -f %name-timezones.lang
%dir %_datadir/%name
%_datadir/%name/ui
%_iconsdir/hicolor/*/*/*
%_datadir/glib-2.0/schemas/*.xml
%_datadir/%name/panels
%_datadir/applications/*.desktop
%doc AUTHORS NEWS README

%files devel
%_pkgconfigdir/*.pc
%dir %_includedir/%name-1/lib%{name}/
%_includedir/%name-1/lib%{name}/*
%_libdir/*.so


%changelog
