%define ver_major 5.6
%define _libexecdir %_prefix/libexec

Name: cinnamon-screensaver
Version: %ver_major.3
Release: alt2

Summary: Cinnamon Screensaver
License: GPLv2+
Group: Graphical desktop/GNOME
Url: https://github.com/linuxmint/cinnamon-screensaver

Provides: screen-saver-engine
Provides: screen-saver-frontend
Provides: cinnamon-screensaver-module

Source: %name-%version.tar
Source1: %name.pam
Patch: %name-%version-%release.patch

BuildPreReq: meson
BuildRequires: python3-dev
BuildRequires: libgio-devel
BuildRequires: libgtk+3-devel
BuildRequires: libgtk+3-gir-devel
BuildRequires: gobject-introspection-devel
BuildRequires: libdbus-glib-devel
BuildRequires: libpam0-devel
BuildRequires: libXinerama-devel
BuildRequires: xdotool-devel
BuildRequires: libXrandr-devel
Requires: %name-translations
Requires: typelib(CDesktopEnums)

%add_python3_self_prov_path %buildroot%_datadir/%name

%description
cinnamon-screensaver is a screen saver and locker that aims to have
simple, sane, secure defaults and be well integrated with the Cinnamon desktop.

%package -n lib%name
Summary: Shared libraries needed to run %name
Group: System/Libraries

%description -n lib%name
This package contains shared libraries needed to run %name and its
components.

%package -n lib%name-devel
Summary: Libraries and include files for developing %name components
Group: Development/GNOME and GTK+
Requires: lib%name = %version-%release

%description -n lib%name-devel
This package provides the necessary development libraries and include
files to allow you to develop %name components.

%package -n lib%name-gir
Summary: GObject introspection data for the %name library
Group: System/Libraries
Requires: lib%name = %version-%release
Requires: libxapps-gir

%description -n lib%name-gir
GObject introspection data for the %name library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the %name library
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-gir = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the %name library

%prep
%setup -q
%patch0 -p1

%build
export CFLAGS=-DUSE_SETRES
%meson
%meson_build

%install
%meson_install

rm -f %buildroot/%_sysconfdir/pam.d/%name
install -pm640 %SOURCE1 %buildroot/%_sysconfdir/pam.d/%name

%filter_from_requires /python3[(]dbusdepot[)]/d
%filter_from_requires /python3[(]util[)]/d
%filter_from_requires /python3[(]widgets[)]/d
%filter_from_requires /python3[(]pamhelper[)]/d
%filter_from_requires /python3[(]pamhelper[)]/d
%filter_from_requires /python3[(]gi.repository.CDesktopEnums[)]/d

%files
%_bindir/%name
%_bindir/cinnamon-unlock-desktop
%attr(2711,root,chkpwd) %_libexecdir/%name-pam-helper
%attr(640,root,chkpwd) %config(noreplace) %_sysconfdir/pam.d/*
%_libexecdir/cs-backup-locker
%_bindir/%name-command
%_datadir/%name
%_datadir/dbus-1/services/*.service
%_datadir/applications/*.desktop
%_datadir/icons/hicolor/scalable/*/*.svg
%_datadir/icons/hicolor/scalable/*/*.svg
%doc AUTHORS NEWS README.md

%files -n lib%name
%_libdir/libcscreensaver.so.*

%files -n lib%name-devel
%_libdir/*.so
%_pkgconfigdir/*

%files -n lib%name-gir
%_libdir/girepository-1.0/*

%files -n lib%name-gir-devel
%_datadir/gir-1.0/*

%changelog
