%define _unpackaged_files_terminate_build 1

%def_disable docs

Name: clanlib0.8
Version: 0.8.1
Release: alt7

Summary: The ClanLib Game SDK
License: LGPL
Group: System/Libraries
Url: http://www.clanlib.org/

# http://clanlib.org/~sphair/download/
# http://clanlib.org/download/releases-0.8/ClanLib-%version.tar.gz
Source: ClanLib-%version.tar
Source1: launch_x11_clanapp.sh

Patch0: ClanLib-0.8.1-link-fix.patch
Patch1: ClanLib-0.8.0-doc-install.patch
Patch2: ClanLib-0.8.0-fix-pkgconfig.patch
Patch3: ClanLib-0.8.0-gcc43.patch
Patch4: clanlib-0.8.1-alt-glibc-2.16.patch
Patch5: clanlib-0.8.1-alt-libpng15.patch
Patch6: clanlib-0.8.1-alt-gcc6.patch
Patch7: clanlib-0.8.1-alt-perl.patch


Obsoletes: clanLib
Provides: lib%name = %EVR
Obsoletes: lib%name < %EVR

BuildRequires: gcc-c++ libGLU-devel libICE-devel libXi-devel libXmu-devel libalsa-devel
BuildRequires: libmikmod-devel libjpeg-devel libpng-devel xorg-cf-files xsltproc libvorbis-devel
BuildRequires: libSDL_gfx-devel libSDL-devel libXxf86vm-devel

%description
The ClanLib Game SDK is a crossplatform game library designed to ease the work
for game developers. The goal is to provide a common interface to classical
game problems (loading graphics eg.), so games can share as much code as
possible. Ideally anyone with small resources should be able to write
commercial quality games.

%package devel
Summary: Headers for developing programs that will use %name
Group: Development/C++
Requires: %name = %EVR
Requires: %name-gl = %EVR
Requires: %name-gui = %EVR
Requires: %name-mikmod = %EVR
Requires: %name-network = %EVR
Requires: %name-sound = %EVR
Requires: %name-vorbis = %EVR
Requires: %name-sdl = %EVR
Provides: lib%name-devel = %version
Obsoletes: lib%name-devel < %version

%description devel
This package contains the headers that programmers will need to develop
applications which will use %name.

%package devel-static
Summary: Static libraries for developing programs that will use %name
Group: Development/C++
Requires: %name-devel = %EVR
Provides: lib%name-devel-static = %version

%description devel-static
This package contains the static libraries that programmers will need
to develop applications which will use %name.

%package sound
Summary: ClanLib Sound module
Group: System/Libraries
Requires: %name = %EVR
Provides: lib%name-sound = %version
Obsoletes: lib%name-sound < %version

%description sound
The ClanLib Game SDK is a crossplatform game library designed to ease the
work for game developers. This package is the Sound module (clanSound).

%package sdl
Summary: ClanLib SDL module
Group: System/Libraries
Requires: %name = %EVR
Provides: lib%name-sdl = %version
Obsoletes: lib%name-sdl < %version

%description sdl
The ClanLib Game SDK is a crossplatform game library designed to ease the
work for game developers. This package is the SDL module (clanSDL).

%package vorbis
Summary: ClanLib Vorbis module
Group: System/Libraries
Requires: %name = %EVR
Requires: %name-sound = %EVR
Provides: lib%name-vorbis = %version
Obsoletes: lib%name-vorbis < %version

%description vorbis
The ClanLib Game SDK is a crossplatform game library designed to ease the
work for game developers. This package is the Vorbis module (clanVorbis).

%package gl
Summary: ClanLib GL module
Group: System/Libraries
Requires: %name = %EVR
Provides: lib%name-gl = %version
Obsoletes: lib%name-gl < %version

%description gl
The ClanLib Game SDK is a crossplatform game library designed to ease the
work for game developers. This package is the GL module (clanGL).

%package network
Summary: ClanLib Network module
Group: System/Libraries
Requires: %name = %EVR
Provides: lib%name-network = %version
Obsoletes: lib%name-network < %version

%description network
The ClanLib Game SDK is a crossplatform game library designed to ease the
work for game developers. This package is the Network module (clanNetwork).

%package gui
Summary: ClanLib Gui module
Group: System/Libraries
Requires: %name = %EVR
Provides: lib%name-gui = %version
Obsoletes: lib%name-gui < %version

%description gui
The ClanLib Game SDK is a crossplatform game library designed to ease the
work for game developers. This package is the Gui module (clanGUI).

%package mikmod
Summary: ClanLib MikMod module
Group: System/Libraries
Requires: %name = %EVR
Requires: %name-sound = %EVR
Provides: lib%name-mikmod = %version
Obsoletes: lib%name-mikmod < %version

%description mikmod
The ClanLib Game SDK is a crossplatform game library designed to ease the
work for game developers. This package is the MikMod module (clanMikMod).

%package docs
Summary: ClanLib documentation
Group: System/Libraries
Requires: %name = %EVR
Provides: lib%name-docs = %version
Obsoletes: lib%name-docs < %version
BuildArch: noarch

%description docs
The ClanLib Game SDK is a crossplatform game library designed to ease the
work for game developers. This package contains the documentation.

%prep
%setup -q -n ClanLib-%version
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p2
%patch5 -p2
%patch6 -p2
%patch7 -p2

%build
echo >> acinclude.m4
%autoreconf
%configure \
	--enable-dyn \
	--disable-debug \
	--disable-directfb \
%if_disabled docs
	--disable-docs \
%endif
	%nil

%make_build all

%install
%makeinstall \
	BIN_PREFIX=%buildroot%_bindir \
	LIB_PREFIX=%buildroot%_libdir \
	INC_PREFIX=%buildroot%_includedir \
	TARGET_PREFIX=%buildroot%_libdir/ClanLib \
	MAN_PREFIX=%buildroot%_mandir \
	HTML_PREFIX=%buildroot%_docdir/clanlib-%version

%if_disabled docs
mkdir -p %buildroot%_docdir/clanlib-%version
%endif

install -pD -m644 README CREDITS CODING_STYLE ascii-logo %buildroot%_docdir/clanlib-%version
install -pD -m755 %SOURCE1 %buildroot%_bindir/launch_x11_clanapp


%files
%dir %_docdir/clanlib-%version
%_docdir/clanlib-%version/README
%_docdir/clanlib-%version/CREDITS
%_bindir/launch_x11_clanapp
%_libdir/libclanCore-*.so.*
%_libdir/libclanSignals-*.so.*
%_libdir/libclanApp-*.so.*
%_libdir/libclanDisplay-*.so.*

%files devel
%dir %_docdir/clanlib-%version
%_docdir/clanlib-%version/CODING_STYLE
%_docdir/clanlib-%version/ascii-logo
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*

%files devel-static
%_libdir/*.a

%if_enabled docs
%files docs
%dir %_docdir/clanlib-%version
%_docdir/clanlib-%version/*.html
%_docdir/clanlib-%version/Overview
%_docdir/clanlib-%version/Reference
%_docdir/clanlib-%version/Tutorial
%endif

%files mikmod
%_libdir/libclanMikMod-*.so.*

%files network
%_libdir/libclanNetwork-*.so.*

%files vorbis
%_libdir/libclanVorbis-*.so.*

%files gl
%_libdir/libclanGL-*.so.*

%files sound
%_libdir/libclanSound-*.so.*

%files sdl
%_libdir/libclanSDL-*.so.*

%files gui
%_libdir/libclanGUI-*.so.*
%_libdir/libclanGUIStyleSilver-*.so.*

%changelog
