%define gst_api_ver 1.0

Name: clementine
Version: 1.4.0
Release: alt4.git67a947f11
Summary: A music player and library organiser

Group: Sound
License: %lgpl3only
Url: https://www.clementine-player.org/

Source0: %name-%version.tar.gz

BuildRequires(pre): rpm-build-licenses
BuildRequires(pre): rpm-macros-cmake cmake
BuildRequires: boost-devel-headers gcc-c++
BuildRequires: libgio-devel libglew-devel libgpod-devel libmtp-devel
BuildRequires: libqt5-opengl libqt5-sql libqt5-webkit libqt5-xmlpatterns qt5-x11extras-devel
BuildRequires: libtag-devel
BuildRequires: gstreamer%{gst_api_ver}-devel gst-plugins%gst_api_ver-devel gstreamer%gst_api_ver-utils
BuildRequires: libchromaprint-devel
BuildRequires: libcryptopp-devel >= 6
# SQLITE_DBCONFIG_ENABLE_FTS3_TOKENIZER is available since 3.12
BuildRequires: libsqlite3-devel >= 3.12
BuildRequires: libpulseaudio-devel
BuildRequires: qt5-tools-devel
BuildRequires: libalsa-devel
BuildRequires: libfftw3-devel

BuildRequires: qt5-sql-sqlite3 protobuf-compiler
# Enable Google Drive support
BuildRequires: libgoogle-sparsehash
BuildPreReq: libavcodec-devel libavformat-devel libpcre-devel
BuildPreReq: libprotobuf-devel qjson-qt5-devel libcdio-devel

# Clementine crashes without it
Requires: gst-plugins-base%{gst_api_ver}

%description
Clementine is a modern music player and library organizer

%add_python_req_skip clementine

%prep
%setup

%build
%cmake
%cmake_build

%install
%cmakeinstall_std
%find_lang --with-kde %name

%files -f %name.lang
%doc Changelog
%_bindir/clementine
%_bindir/clementine-tagreader
%_desktopdir/clementine.desktop
%_datadir/kservices5/*.protocol
%_datadir/clementine
%_datadir/metainfo/clementine.appdata.xml
%_datadir/icons/hicolor/*/apps/*.png
%_datadir/icons/hicolor/*/apps/*.svg


%changelog
