%def_without static
%define abiversion 6
%define oname cln

Name: %oname%abiversion
Version: 1.3.3
Release: alt3

Summary: CLN - Class Library for Numbers
Group: System/Libraries
License: GPL
Url: http://www.ginac.de/CLN

Source: %oname-%version.tar

# Automatically added by buildreq on Fri Jun 17 2005
BuildRequires: gcc-c++ libgmp-devel libstdc++-devel
# explicitly added texinfo for info files
BuildRequires: texinfo

%description
Class Library for Numbers.
Features:
- Rich set of number classes.
- Elementary, logical, transcendental functions.
- Memory efficiency.
- Speed efficiency.
- Interoperability.

%package -n lib%name
Summary: CLN - Class Library for Numbers
Group: System/Libraries

%description -n lib%name
Class Library for Numbers.
Features:
- Rich set of number classes.
- Elementary, logical, transcendental functions.
- Memory efficiency.
- Speed efficiency.
- Interoperability.

%package -n lib%oname-devel
Summary: CLN development package
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%oname-devel
The CLN package contains the header files needed for developing
applications that use CLN library. Install libcln-devel if
you want to develop applications using CLN.

%if_enabled static
%package -n lib%oname-devel-static
Summary: CLN static library
Group: Development/C
Requires: lib%oname-devel = %version-%release

%description -n lib%oname-devel-static
This package contains static version of CLN library. Install
libcln-devel-static if you want to develop applications statically linked
with CLN.
%endif

%package -n lib%oname-doc
Summary: CLN library documentation
Group: Development/Documentation
BuildArch: noarch

%description -n lib%oname-doc
This package contains documentation on CLN library.

%package -n pi
Summary: Compute decimal Archimedes' constant Pi to arbitrary accuracy
Group: Sciences/Mathematics
Requires: lib%name = %version-%release
Conflicts: puppet

%description -n pi
Compute decimal Archimedes' constant Pi to arbitrary accuracy.

%prep
%setup
rm -f aclocal.m4

%build
%ifarch %arm
%add_optflags -DNO_ASM
%endif
%autoreconf
%configure %{subst_enable static}

%make_build

%install
%make_install DESTDIR=%buildroot install

# remove non-packaged files
rm -f %buildroot%_libdir/*.la
%if_without static
rm -f %buildroot%_libdir/*.a
%endif


%files -n lib%name
%_libdir/*.so.*
%_man1dir/*

%files -n lib%oname-devel
%_includedir/*
%_libdir/*.so
%_libdir/pkgconfig/*

%if_with static
%files -n lib%oname-devel-static
%_libdir/*.a
%endif

%files -n lib%oname-doc
%_infodir/*

%files -n pi
%_bindir/pi

%changelog
