Name: codeblocks
Version: 20.03
Release: alt7

Summary: Code::Blocks is open source, cross platform free C++ IDE
Summary(ru_RU.UTF-8): Code::Blocks это кросс-платформенная свободная среда разработки для C++ с открытым исходным кодом

License: GPLv3
Group: Development/C++
Url: http://www.codeblocks.org

Packager: Grigory Ustinov <grenka@altlinux.ru>

Source0: %name-%version.tar
Source1: %name-8.02-alt-icons.tar
Source3: %name.desktop
Source4: %name.po

Patch0: codeblocks-language-detection-from-locale.patch
Patch1: codeblocks-ebuild.conf.patch
Patch2: %name-%version-FortranProject_autotools_build.patch
Patch3: %name-%version-add-shebang-to-gdb-fortran-extension.patch
Patch4: %name-%version-multi-arch.patch
Patch5: %name-%version-fix-empty-arduino-page.patch
Patch6: 0001-Do-not-call-wxChoice::GetString-with-wxNOT_FOUND.patch
Patch7: 0001-Fix-build-with-wxWidgets-3.1.4.patch

Requires: automake >= 1.7 libwxGTK3.1 gcc gcc-c++ gdb xterm gamin mythes-en

BuildRequires(pre): rpm-build-python3
BuildRequires: boost-devel gcc-c++ libICE-devel libgamin-devel libgtk+3-devel
BuildRequires: libhunspell-devel libwxGTK-contrib-gizmos-devel libwxGTK3.1-devel
BuildRequires: tinyxml-devel zip zlib-devel bzlib-devel

%description
Code::Blocks is a free C++ IDE built specifically to meet the most
demanding needs of its users. It was designed, right from the start,
to be extensible and configurable. Built around a plugin framework,
Code::Blocks can be extended with plugin DLLs.
It includes a plugin wizard so you can compile your own plugins!

%description -l ru_RU.UTF-8
Code::Blocks это свободная IDE для C++, которая создана для
удовлетворения множества требований её пользователей.
Она разрабатывалась с самого начала, как расширяемая
и легко настраиваемая. Собранная с поддержкой плагинов
Code::Blocks может быть расширена с помощью подключаемых библиотек.

%package contrib
Summary: Code::Blocks contrib plugins
Summary(ru_RU.UTF-8): Дополнительные плагины для Code::Blocks
Group: Development/C++
Requires: codeblocks = %EVR
%add_python3_req_skip gdb

%description contrib
Additional Code::Blocks plugins.

%description contrib -l ru_RU.UTF-8
Набор дополнительных плагинов для среды разработки Code::Blocks.

%package devel
Summary: Code::Blocks SDK
Group: Development/C++
Requires: codeblocks = %EVR

%description devel
Code::Blocks SDK to develop your own plugins.

%description devel -l ru_RU.UTF-8
SDK для создания собственных плагинов к среде разработки Code::Blocks.

%prep
%setup -a1
cp %SOURCE3 src/mime/
cp %SOURCE4 .

%patch0 -p1
%patch1 -p1
%patch2 -p2
%patch3 -p2
%patch4 -p1
%patch5 -p2
%patch6 -p1
%patch7 -p1

# https://sourceforge.net/p/codeblocks/tickets/936/
sed -ri '/^\s+#pragma implementation/ s,cbkeybinder,cbKeyConfigPanel,' src/plugins/contrib/keybinder/cbkeyConfigPanel.cpp

%build
msgfmt %name.po -o %name.mo
./bootstrap
%add_optflags -std=gnu++14
%configure --with-contrib-plugins=all \
           --with-boost-libdir=%_libdir \
           --enable-fortran \
           --disable-pch
%make_build

%install
%makeinstall_std

rm -f %buildroot/%_libdir/%name/plugins/*.la
rm -f %buildroot/%_libdir/%name/wxContribItems/*.la
rm -f %buildroot/%_libdir/%name/plugins/contrib/*.la

install -m 644 -D alt-icons/16x16/%name.png %buildroot%_miconsdir/%name.png
install -m 644 -D alt-icons/32x32/%name.png %buildroot%_niconsdir/%name.png
install -m 644 -D alt-icons/48x48/%name.png %buildroot%_liconsdir/%name.png
install -m 644 -D alt-icons/64x64/%name.png %buildroot%_iconsdir/hicolor/64x64/apps/%name.png
install -m 644 -D %name.mo %buildroot%_datadir/%name/locale/ru_RU/%name.mo

%files
%doc README COPYING AUTHORS BUGS COMPILERS TODO NEWS ChangeLog
%_bindir/%name
%_bindir/cb_console_runner
%_libdir/lib%name.so.*
%_desktopdir/%name.desktop
%_datadir/mime/packages/%name.xml
%_man1dir/*
%exclude %_man1dir/codesnippets.1.xz

%dir %_datadir/%name
%dir %_datadir/%name/locale
%dir %_datadir/%name/locale/ru_RU
%_datadir/%name/locale/ru_RU/codeblocks.mo

%_datadir/appdata/%name.appdata.xml

%_datadir/%name/abbreviations.zip
%_datadir/%name/Astyle.zip
%_datadir/%name/autosave.zip
%_datadir/%name/classwizard.zip
%_datadir/%name/codecompletion.zip
%_datadir/%name/compiler.zip
%_datadir/%name/debugger.zip
%_datadir/%name/defaultmimehandler.zip
%_datadir/%name/IncrementalSearch.zip
%_datadir/%name/manager_resources.zip
%_datadir/%name/resources.zip
%_datadir/%name/scriptedwizard.zip
%_datadir/%name/start_here.zip
%_datadir/%name/todo.zip
%_datadir/%name/Valgrind.zip
%_datadir/%name/tips.txt
%_datadir/%name/icons
%dir %_datadir/%name/images
%_datadir/%name/images/*.png
%_datadir/%name/images/settings
%_datadir/%name/compilers
%_datadir/%name/lexers
%dir %_libdir/%name
%dir %_libdir/%name/plugins
%_libdir/%name/plugins/libabbreviations.*
%_libdir/%name/plugins/libAstyle.*
%_libdir/%name/plugins/libautosave.*
%_libdir/%name/plugins/libclasswizard.*
%_libdir/%name/plugins/libcodecompletion.*
%_libdir/%name/plugins/libcompiler.*
%_libdir/%name/plugins/libdebugger.*
%_libdir/%name/plugins/libdefaultmimehandler.*
%_libdir/%name/plugins/libIncrementalSearch.*
%_libdir/%name/plugins/libscriptedwizard.*
%_libdir/%name/plugins/libtodo.*
%_libdir/%name/plugins/libValgrind.*
%_datadir/%name/scripts
%_datadir/%name/templates

%_iconsdir/hicolor/48x48/mimetypes/application-x-codeblocks-workspace.png
%_iconsdir/hicolor/48x48/mimetypes/application-x-codeblocks.png
%_iconsdir/hicolor/64x64/apps/codeblocks.png
%_miconsdir/%name.png
%_niconsdir/%name.png
%_liconsdir/%name.png
%_pixmapsdir/%name.png
# Fix of post-install unowned files
%dir %_iconsdir/hicolor/48x48/mimetypes
%dir %_iconsdir/hicolor/64x64
%dir %_iconsdir/hicolor/64x64/apps

%files contrib
%_bindir/cb_share_config
%_libdir/libwxsmithlib.so*
%_libdir/%name/wxContribItems
%_man1dir/codesnippets.1.xz
%_datadir/appdata/%name-contrib.metainfo.xml

%_datadir/%name/AutoVersioning.zip
%_datadir/%name/BrowseTracker.zip
%_datadir/%name/byogames.zip
%_datadir/%name/cb_koders.zip
%_datadir/%name/Cccc.zip
%_datadir/%name/codesnippets.zip
%_datadir/%name/CppCheck.zip
%_datadir/%name/codestat.zip
%_datadir/%name/copystrings.zip
%_datadir/%name/Cscope.zip
%_datadir/%name/DoxyBlocks.zip
%_datadir/%name/dragscroll.zip
%_datadir/%name/EditorTweaks.zip
%_datadir/%name/EditorConfig.zip
%_datadir/%name/envvars.zip
%_datadir/%name/exporter.zip
%_datadir/%name/FileManager.zip
%_datadir/%name/FortranProject.zip
%_datadir/%name/help_plugin.zip
%_datadir/%name/HexEditor.zip
%_datadir/%name/headerfixup.zip
%_datadir/%name/keybinder.zip
%_datadir/%name/lib_finder.zip
%_datadir/%name/MouseSap.zip
%_datadir/%name/NassiShneiderman.zip
%_datadir/%name/occurrenceshighlighting.zip
%_datadir/%name/openfileslist.zip
%_datadir/%name/projectsimporter.zip
%_datadir/%name/ProjectOptionsManipulator.zip
%_datadir/%name/Profiler.zip
%_datadir/%name/RegExTestbed.zip
%_datadir/%name/ReopenEditor.zip
%_datadir/%name/rndgen.zip
%_datadir/%name/SmartIndent*.zip
%_datadir/%name/SpellChecker.zip
%_datadir/%name/SymTab.zip
%_datadir/%name/ThreadSearch.zip
%_datadir/%name/ToolsPlus.zip
%_datadir/%name/wxsmith.zip
%_datadir/%name/wxSmithAui.zip
%_datadir/%name/wxsmithcontribitems.zip

%_datadir/%name/images/16x16/*
%_datadir/%name/images/20x20/*
%_datadir/%name/images/24x24/*
%_datadir/%name/images/28x28/*
%_datadir/%name/images/32x32/*
%_datadir/%name/images/40x40/*
%_datadir/%name/images/48x48/*
%_datadir/%name/images/56x56/*
%_datadir/%name/images/64x64/*
%_datadir/%name/images/fortranproject/*
%_datadir/%name/images/fortranproject/16x16/*
%_datadir/%name/images/fortranproject/20x20/*
%_datadir/%name/images/fortranproject/24x24/*
%_datadir/%name/images/fortranproject/28x28/*
%_datadir/%name/images/fortranproject/32x32/*
%_datadir/%name/images/fortranproject/40x40/*
%_datadir/%name/images/fortranproject/48x48/*
%_datadir/%name/images/fortranproject/56x56/*
%_datadir/%name/images/fortranproject/64x64/*
# Fix of post-install unowned files
%dir %_datadir/%name/images/16x16
%dir %_datadir/%name/images/20x20
%dir %_datadir/%name/images/24x24
%dir %_datadir/%name/images/28x28
%dir %_datadir/%name/images/32x32
%dir %_datadir/%name/images/40x40
%dir %_datadir/%name/images/48x48
%dir %_datadir/%name/images/56x56
%dir %_datadir/%name/images/64x64
%dir %_datadir/%name/images/fortranproject

%_datadir/%name/images/codesnippets
%_datadir/%name/images/wxsmith
%_datadir/%name/lib_finder
%_datadir/%name/SpellChecker

%_libdir/%name/plugins/libAutoVersioning.*
%_libdir/%name/plugins/libBrowseTracker.*
%_libdir/%name/plugins/libbyogames.*
%_libdir/%name/plugins/libcb_koders.*
%_libdir/%name/plugins/libCccc.*
%_libdir/%name/plugins/libcodesnippets.*
%_libdir/%name/plugins/libcodestat.*
%_libdir/%name/plugins/libcopystrings.*
%_libdir/%name/plugins/libCppCheck.*
%_libdir/%name/plugins/libCscope.*
%_libdir/%name/plugins/libDoxyBlocks.*
%_libdir/%name/plugins/libdragscroll.*
%_libdir/%name/plugins/libEditorTweaks.*
%_libdir/%name/plugins/libEditorConfig.*
%_libdir/%name/plugins/libenvvars.*
%_libdir/%name/plugins/libexporter.*
%_libdir/%name/plugins/libFileManager.*
%_libdir/%name/plugins/libFortranProject.*
%_libdir/%name/plugins/libhelp_plugin.*
%_libdir/%name/plugins/libHexEditor.*
%_libdir/%name/plugins/libheaderfixup.*
%_libdir/%name/plugins/libkeybinder.*
%_libdir/%name/plugins/liblib_finder.*
%_libdir/%name/plugins/libMouseSap.*
%_libdir/%name/plugins/libNassiShneiderman.*
%_libdir/%name/plugins/liboccurrenceshighlighting.*
%_libdir/%name/plugins/libopenfileslist.*
%_libdir/%name/plugins/libprojectsimporter.*
%_libdir/%name/plugins/libProjectOptionsManipulator.*
%_libdir/%name/plugins/libProfiler.*
%_libdir/%name/plugins/libRegExTestbed.*
%_libdir/%name/plugins/libReopenEditor.*
%_libdir/%name/plugins/librndgen.*
%_libdir/%name/plugins/libSmartIndent*.*
%_libdir/%name/plugins/libSpellChecker.*
%_libdir/%name/plugins/libSymTab.*
%_libdir/%name/plugins/libThreadSearch.*
%_libdir/%name/plugins/libToolsPlus.*
%_libdir/%name/plugins/libwxsmith.*
%_libdir/%name/plugins/libwxSmithAui.*
%_libdir/%name/plugins/libwxsmithcontribitems.*

%files devel
%_includedir/%name
%_includedir/wxsmith
%_libdir/lib%name.so
%_libdir/pkgconfig/%name.pc
%_libdir/pkgconfig/cb_wx*.pc
%_libdir/pkgconfig/wxsmith.pc
%_libdir/pkgconfig/wxsmithaui.pc
%_libdir/pkgconfig/wxsmith-contrib.pc

%changelog
