Name: colpack
Version: 1.0.10
Release: alt1
Summary: Graph Coloring for Computing Derivatives
License: LGPL v3
Group: Sciences/Mathematics
Url: http://cscapes.cs.purdue.edu/coloringpage/software.htm

# https://github.com/CSCsw/ColPack.git
Source: %name-%version.tar
Patch1: %name-%version-alt-build.patch

BuildRequires: gcc-c++ libgomp-devel

Requires: lib%name = %version-%release

%description
ColPack: Graph Coloring for Computing Derivatives.

%package -n lib%name
Summary: Shared library of Graph Coloring for Computing Derivatives
Group: System/Libraries

%description -n lib%name
ColPack: Graph Coloring for Computing Derivatives.

This package contains shared library of ColPack.

%package -n lib%name-devel
Summary: Development files of Graph Coloring for Computing Derivatives
Group: Development/C++
Requires: lib%name = %version-%release

%description -n lib%name-devel
ColPack: Graph Coloring for Computing Derivatives.

This package contains development files of ColPack.

%package examples
Summary: Examples for Graph Coloring for Computing Derivatives
Group: Sciences/Mathematics
Requires: lib%name = %version-%release

%description examples
ColPack: Graph Coloring for Computing Derivatives.

This package contains examples for ColPack.

%prep
%setup
%patch1 -p1

%build
%autoreconf
%configure \
	--enable-static=no \
	--enable-examples
#	--enable-openmp \
%make_build

%install
%makeinstall_std

install -d %buildroot%_bindir
install -m755 .libs/ColPack %buildroot%_bindir
mv %buildroot%prefix/examples/Basic/* %buildroot%_bindir/
mv %buildroot%prefix/examples/Matrix_Compression_and_Recovery/*/* \
	%buildroot%_bindir/

ln -s ColPack %buildroot%_includedir/%name

%pre -n lib%name-devel
rm -fR %_includedir/%name

%files
%doc AUTHORS ChangeLog NEWS README.md Main/Main.cpp
%_bindir/ColPack

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*

%files examples
%doc SampleDrivers/Basic/*.cpp
%doc SampleDrivers/Matrix_Compression_and_Recovery/*/*.cpp
%_bindir/*
%exclude %_bindir/ColPack

%changelog
