%define _unpackaged_files_terminate_build 1

Name: complgen
Version: 0.1.8
Release: alt0.p10.1

Summary: Bash/fish/zsh completions generator
License: Apache-2.0
Group: Development/Tools
Vcs: https://github.com/adaszko/complgen

Source: %name-%version.tar
BuildRequires: rust-cargo git
BuildRequires: /proc

%description
Generate bash/fish/zsh completions from a single declarative grammar familiar
from man pages.

%prep
%setup -q
mkdir -p .cargo
cat >> .cargo/config <<EOF
[source.crates-io]
replace-with = "vendored-sources"

[source.vendored-sources]
directory = "vendor"
EOF

%build
cargo build --offline --release

%install
mkdir -p %buildroot%_bindir
install -Dm0755 target/release/%name %buildroot%_bindir/

%check
ARCH="$(uname -m)"
EXCLUDED_ARCHES="armv8l armv7l armv6l armv7hf armhf"
if ! echo "$EXCLUDED_ARCHES" | grep -w -q "$ARCH"; then
    cargo test
fi

%files
%doc LICENSE
%doc README.md
%_bindir/%name

%changelog
