%def_enable snapshot

%define _name cpprestsdk
%define ver_major 2.10

%if_enabled snapshot
#can't build on %ix86, see bottom of /usr/share/cmake/websocketpp-configVersion.cmake
%def_without system_websocketpp
%else
# tarball doesn't contain websocketpp headers
%def_with system_websocketpp
%endif
%def_disable check

Name: cpprest
Version: %ver_major.18
Release: alt1

Summary: C++ REST library
Group: System/Libraries
License: MIT
Url: https://github.com/Microsoft/%_name

%if_disabled snapshot
Source: %url/archive/v%version/%_name-%version.tar.gz
%else
Source: %_name-%version.tar
%endif

BuildRequires: gcc-c++ cmake
BuildRequires: boost-devel >= 1.55 boost-interprocess-devel boost-filesystem-devel
BuildRequires: boost-asio-devel boost-locale-devel
BuildRequires: pkgconfig(openssl) >= 1.0
%{?_with_system_websocketpp:BuildRequires: websocketpp-devel >= 0.4}
BuildRequires: zlib-devel libbrotli-devel

%description
The C++ REST SDK is a Microsoft project for cloud-based client-server
communication in native code using a modern asynchronous C++ API design. This
project aims to help C++ developers connect to and interact with services.

Also known as Casablanca.

%package -n lib%name
Summary: %summary
Group: System/Libraries

%description -n lib%name
The C++ REST SDK is a Microsoft project for cloud-based client-server
communication in native code using a modern asynchronous C++ API design. This
project aims to help C++ developers connect to and interact with services.

This package provides shared %name library.

%package -n lib%name-devel
Summary: Development files for %name
Group: Development/C++
Provides: %name-devel = %version-%release
Requires: lib%name = %version-%release
Requires: libssl-devel

%description -n lib%name-devel
The C++ REST SDK is a Microsoft project for cloud-based client-server
communication in native code using a modern asynchronous C++ API design. This
project aims to help C++ developers connect to and interact with services.

This package provides development files for %name library.

%prep
%setup -n %_name-%version
# Remove bundled sources of websocketpp
%{?_with_system_websocketpp:rm -r Release/libs}
# Remove file ThirdPartyNotices.txt, which is associated to websocketpp
rm -f ThirdPartyNotices.txt
# fix libdir
subst 's|\(DESTINATION \)lib|\1%_lib|' Release/src/CMakeLists.txt

%build
cd Release
%add_optflags %optflags %(getconf LFS_CFLAGS) -Wl,--as-needed
%cmake .. -DCMAKE_BUILD_TYPE=Release \
	  -DCMAKE_INSTALL_DO_STRIP=OFF \
	  -DWERROR=OFF \
	  -DCPPREST_EXCLUDE_BROTLI=OFF \
	  -DCPPREST_EXPORT_DIR=cmake/%_name
%cmake_build

%install
cd Release
%cmakeinstall_std

%check
cd Release
LD_LIBRARY_PATH=%buildroot/%_libdir %make -C BUILD test

%files -n lib%name
%_libdir/libcpprest.so.*
%doc README.md license.txt

%files -n lib%name-devel
%_includedir/%name
%_includedir/pplx
%_libdir/libcpprest.so
%_libdir/cmake/%_name/
%doc README.md

%changelog
