# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/pdftotext
# END SourceDeps(oneline)
%define svn_rev r409

Name: csync2
Version: 2.0
Release: alt3

Summary: Csync2 is a cluster synchronization tool

License: GPLv2
Group: File tools
Url: http://oss.linbit.com/csync2/
VCS: https://github.com/LINBIT/csync2
Source: %name-%version.tar
Source1: http://www.clifford.at/papers/2005/csync2/paper.pdf
Source2: %name.init
Source3: csync2.socket
Source4: csync2@.service
Source5: gen-cert
Patch0: %name-%version-%release.patch

# Automatically added by buildreq on Fri Mar 31 2006
BuildRequires: flex libgnutls-openssl-devel librsync-devel libtasn1-devel libsqlite3-devel xpdf-utils
# for broken checking code (add libs depends)
BuildRequires: zlib-devel
BuildRequires: gcc-c++

# we have incompatibility in ALT
%define _localstatedir /var

%description
Csync2 is a cluster synchronization tool. It can be used to keep files on
multiple hosts in a cluster in sync. Csync2 can handle complex setups with
much more than just 2 hosts, handle file deletions and can detect conflicts.

%prep
%setup
%patch0 -p1
%ifarch %e2k
# name collision with existing function from "string.h"
sed -i "s/strlcpy/rsync_strlcpy/" rsync.c
%endif

%build
%autoreconf
%configure --sysconfdir=%_sysconfdir/%name --enable-sqlite3
sed -i 's,libmysqlclient.so,libmysqlclient.so.21,' db_mysql.c
sed -i 's,libsqlite.so,libsqlite.so.0,' db_sqlite.c
sed -i 's,libpq.so,libpq.so.5,' db_postgres.c
%make_build
pdftotext %SOURCE1 paper.txt

%install
%make_install DESTDIR=%buildroot install
install -m 644 -D csync2.xinetd %buildroot%_sysconfdir/xinetd.d/%name
install -m 755 -D %SOURCE2 %buildroot%_initrddir/%name
install -p -m 644 -D %SOURCE3 %buildroot%_unitdir/csync2.socket
install -p -m 644 -D %SOURCE4 %buildroot%_unitdir/csync2@.service
install -m 755 -D %SOURCE5 %buildroot%_sysconfdir/%name/gen-cert
mkdir -p %buildroot%_localstatedir/lib/%name
touch %buildroot/etc/%name/csync2_ssl_cert.pem
touch %buildroot/etc/%name/csync2_ssl_key.pem

%post
%post_service %name

%preun
%preun_service %name

%files
%doc ChangeLog README AUTHORS paper.txt
%_sbindir/*
%_man1dir/*
%dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/csync2.cfg
%config(noreplace) %_localstatedir/lib/%name
%config(noreplace) %_sysconfdir/xinetd.d/%name
%_initrddir/%name
%_unitdir/%name.socket
%_unitdir/%name@.service
%_sysconfdir/%name/gen-cert
%ghost /etc/%name/csync2_ssl_cert.pem
%ghost /etc/%name/csync2_ssl_key.pem

%changelog
