%define privuser  dyndns
%define privgroup dyndns
%define privpath  /var/empty

Summary: A client to update host entries on DynDNS like services
Summary(ru_RU.UTF8): Клиент для обновления записей служб динамического DNS, подобных DynDNS
Name: ddclient
Version: 3.9.0
Release: alt1
License: GPLv2
Group: System/Configuration/Networking
Url: http://ddclient.sourceforge.net/
Source0: %name-%version.tar.xz
Source1: ddclientd
Source2: README_SSL.ALT.txt
Patch0: %name-3.7.1-piddir.diff
Patch1: %name-3.9.0.fix_ssl_warning_altspecifics.diff
Patch2: %name-3.8.1-ipv6.patch
BuildArch: noarch

Requires: perl-Digest-SHA1

BuildRequires: perl-Data-Validate-IP

%description
DDclient is a small full featured client requiring only Perl and no
additional modules. It runs under most UNIX OSes and has been tested
under Linux and FreeBSD. Supported features include: operating as a
daemon, manual and automatic updates, static and dynamic updates,
optimized updates for multiple addresses, MX, wildcards, abuse
avoidance, retrying failed updates, and sending update status to
syslog and through e-mail. This release may now obtain your IP address
from any interface, web based IP detection, Watchguard's SOHO router,
Netopia's R910 router, SMC's Barricade broadband router, Netgear's
RT3xx router, Linksys' broadband routers, MaxGate's UGATE-3x00
routers, ELSA's LANCOM DSL/10 routers, Cisco's 2610, 3com 3c886a 56k
Lan Modem, SOHOWare BroadGuard NBG800, almost every other router with
user configurable FW definitions (see the sample-etc_ddclient.conf)
and now provides Full support for DynDNS.org's NIC2 protocol. Support
is also included for other dynamic DNS services. Comes with sample
scripts for use with DHCP, PPP, and cron. See the README for more
information.

%description -l ru_RU.UTF8
DDclient - маленький, но полнофункциональный клиент для службы динамического DNS,
требующий для работы только наличия Perl без каких-либо дополнительных модулей.
DDclient работает под большинством UNIX-подобных операционных систем и был
протестирован в Linux и FreeBSD. Среди поддерживаемых функций: работа в качестве
демона (сервиса), ручное и автоматическое обновление, статическое и динамическое
обновление, оптимизированное обновление для нескольких адресов, управление MX-записью,
использование масок (шаблонов) адресов, предотвращение неправильного использования,
повтор попыток обновления в случае неудачи, отправка состояния обновления службе
syslog или посредством e-mail. В настоящей версии DDclient возможно получение
IP адреса вашего компьютера с любого интерфейса, со служб обнаружения IP адресов,
расположенных в сети интернет, с роутеров Watchguard SOHO, Netopia R910,
широкополосных SMC Barricade, Netgear RT3xx, широкополосных Linksys, MaxGate UGATE-3x00,
ELSA LANCOM DSL/10, Cisco 2610, сетевого модема 3com 3c886a 56k, SOHOWare BroadGuard NBG800,
и практически любого другого роутера с конфигурируемыми пользователем настройками
встроенного сетевого экрана (firewall, см. пример конфигурации etc_ddclient.conf).
Также, настоящая версия DDclient предоставляет полную поддержку протокола NIC2 от DynDNS.org.
Поддержка других служб динамического DNS тоже включена и организуется с помощью
скриптов для совместного использования с DHCP, PPP, и cron; примеры скриптов включены
в пакет. Более детальные сведения находятся в файле README.

%prep
%setup -q
%patch0 -p1
%patch1 -p1
# #%patch2 -p0
install -m 0644 %SOURCE2 ./README_SSL.ALT.txt

%build
%install
mkdir -p %buildroot{%_sbindir,%_sysconfdir/%name,%_initdir}
mkdir -p %buildroot/var/cache/ddclient
mkdir -p %buildroot/var/run/ddclient

install -p ddclient %buildroot%_sbindir
install -p sample-etc_ddclient.conf %buildroot%_sysconfdir/%name/ddclient.conf
touch %buildroot%_sysconfdir/%name/ddclient.cache
install -p -m 0755 %SOURCE1 %buildroot%_initdir/ddclientd

mkdir -p %buildroot/lib/tmpfiles.d
cat <<EOF >%buildroot/lib/tmpfiles.d/ddclient.conf
d /var/run/ddclient 2770 root dyndns -
EOF

%pre
/usr/sbin/groupadd -r -f %privgroup
/usr/sbin/useradd -r -s /dev/null -g %privgroup -d %privpath >/dev/null -c 'DynDNS daemon' %privuser >/dev/null 2>&1 ||:

%post
%post_service ddclientd

%files
%doc sample* README* COPY* Change*
%_sbindir/ddclient
%dir %attr(750,root,dyndns) %_sysconfdir/%name
%attr(600,dyndns,dyndns) %config(noreplace) %_sysconfdir/%name/ddclient.conf
%config(noreplace) %ghost %_sysconfdir/%name/ddclient.cache
%_initdir/ddclientd
/lib/tmpfiles.d/ddclient.conf
%dir %attr(2770,root,dyndns) /var/cache/ddclient
%dir %attr(2770,root,dyndns) /var/run/ddclient

%changelog
