%define _unpackaged_files_terminate_build 1

%define sdkversion 3.1.426
%define coreversion 3.1.32
%define templatesversion 3.1.33

Name: dotnet-bootstrap-3.1
Version: 3.1.32
Release: alt1

Summary: .NET Core SDK binaries

License: MIT
Url: https://github.com/dotnet
Group: Development/Other

# Update from https://www.microsoft.com/net/download/dotnet-core/3.1

# Source-url: https://download.visualstudio.microsoft.com/download/pr/e89c4f00-5cbb-4810-897d-f5300165ee60/027ace0fdcfb834ae0a13469f0b1a4c8/dotnet-sdk-3.1.426-linux-x64.tar.gz
Source: %name-%version.tar

# Source2-url: https://download.visualstudio.microsoft.com/download/pr/79f1cf3e-ccc7-4de4-9f4c-1a6e061cb867/68cab78b3f9a5a8ce2f275b983204376/dotnet-sdk-3.1.426-linux-arm64.tar.gz
Source2: %name-aarch64-%version.tar

ExclusiveArch: x86_64 aarch64

#Requires: /proc
#BuildPreReq: /proc

%set_verify_elf_method textrel=relaxed
AutoReq: no,lib,shell
AutoProv: no

BuildRequires: libunwind >= 1.1
BuildRequires: liblttng-ust >= 2.8.0
BuildRequires: libcurl
BuildRequires: libkrb5

# for System.Security.Cryptography.Native.OpenSsl.so
# but already required by libkrb5
#Requires: libcrypto10 libssl10

# it is not linked directly (need the same version like in libicu-devel)
# there are icu detection in a version range
Requires: libicu

Provides: dotnet-bootstrap-runtime-3.1 = %coreversion
Provides: dotnet-bootstrap-sdk-3.1 = %sdkversion

%description
This package contains full .NET Core SDK binaries, needed for bootstrap build.

https://github.com/dotnet/core/blob/master/release-notes/download-archives/%version-download.md

%prep
%setup
%ifarch aarch64
rm -rf packs/ host/ shared/
tar xfv %SOURCE2

sed -E -i -e "s@CURL_OPENSSL_3@\x0URL_OPENSSL_3@" shared/Microsoft.NETCore.App/%coreversion/System.Net.Http.Native.so
%endif

%install
mkdir -p %buildroot%_libdir/%name/
cp -a * %buildroot%_libdir/%name/

# due missed lldb (TODO)
rm -f %buildroot%_libdir/%name/shared/Microsoft.NETCore.App/*/libsosplugin.so
%__subst "s|libsosplugin.so|libsos.so|g" %buildroot%_libdir/%name/shared/Microsoft.NETCore.App/*/Microsoft.NETCore.App.deps.json

cd %buildroot%_libdir/%name

# See also https://bugzilla.altlinux.org/show_bug.cgi?id=37413
strip \
	shared/Microsoft.NETCore.App/%coreversion/libmscordbi.so \
	shared/Microsoft.NETCore.App/%coreversion/libmscordaccore.so \
	shared/Microsoft.NETCore.App/%coreversion/libhostpolicy.so \
	shared/Microsoft.NETCore.App/%coreversion/libdbgshim.so \
	shared/Microsoft.NETCore.App/%coreversion/libcoreclrtraceptprovider.so \
	shared/Microsoft.NETCore.App/%coreversion/libcoreclr.so \
	shared/Microsoft.NETCore.App/%coreversion/libclrjit.so \
	shared/Microsoft.NETCore.App/%coreversion/createdump \
	shared/Microsoft.NETCore.App/%coreversion/System.Security.Cryptography.Native.OpenSsl.so \
	shared/Microsoft.NETCore.App/%coreversion/System.Net.Security.Native.so \
	shared/Microsoft.NETCore.App/%coreversion/System.Net.Http.Native.so \
	shared/Microsoft.NETCore.App/%coreversion/System.Native.so \
	shared/Microsoft.NETCore.App/%coreversion/System.IO.Compression.Native.so \
	shared/Microsoft.NETCore.App/%coreversion/System.Globalization.Native.so \
	sdk/%sdkversion/AppHostTemplate/apphost \
%ifarch x86_64
	packs/Microsoft.NETCore.App.Host.linux-x64/%coreversion/runtimes/linux-x64/native/libnethost.so \
	packs/Microsoft.NETCore.App.Host.linux-x64/%coreversion/runtimes/linux-x64/native/apphost \
%endif
%ifarch aarch64
	packs/Microsoft.NETCore.App.Host.linux-arm64/%coreversion/runtimes/linux-arm64/native/libnethost.so \
	packs/Microsoft.NETCore.App.Host.linux-arm64/%coreversion/runtimes/linux-arm64/native/apphost \
%endif
	host/fxr/%coreversion/libhostfxr.so \
	dotnet \
	#

%files
%dir %_libdir/%name/
%dir %_libdir/%name/templates/
%_libdir/%name/templates/%templatesversion/
%dir %_libdir/%name/packs/
%dir %_libdir/%name/packs/Microsoft.AspNetCore.App.Ref
%_libdir/%name/packs/Microsoft.AspNetCore.App.Ref/3.1.10/
%ifarch aarch64
%dir %_libdir/%name/packs/Microsoft.NETCore.App.Host.linux-arm64/
%_libdir/%name/packs/Microsoft.NETCore.App.Host.linux-arm64/%coreversion/
%else
%dir %_libdir/%name/packs/Microsoft.NETCore.App.Host.linux-x64/
%_libdir/%name/packs/Microsoft.NETCore.App.Host.linux-x64/%coreversion/
%endif
%dir %_libdir/%name/packs/Microsoft.NETCore.App.Ref/
%_libdir/%name/packs/Microsoft.NETCore.App.Ref/3.1.0/
%dir %_libdir/%name/packs/NETStandard.Library.Ref/
%_libdir/%name/packs/NETStandard.Library.Ref/2.1.0/
%dir %_libdir/%name/host/
%dir %_libdir/%name/host/fxr/
%_libdir/%name/host/fxr/%coreversion/
%dir %_libdir/%name/sdk/
%_libdir/%name/sdk/%sdkversion/
%dir %_libdir/%name/shared/
%dir %_libdir/%name/shared/Microsoft.NETCore.App/
%_libdir/%name/shared/Microsoft.NETCore.App/%coreversion/
# TODO: drop from bootstrap
#dir %_libdir/%name/shared/Microsoft.AspNetCore.All/
%dir %_libdir/%name/shared/Microsoft.AspNetCore.App/
#_libdir/%name/shared/Microsoft.AspNetCore.All/%coreversion/
%_libdir/%name/shared/Microsoft.AspNetCore.App/%coreversion/
#_libdir/%name/store/
%_libdir/%name/LICENSE.txt
%_libdir/%name/ThirdPartyNotices.txt
%_libdir/%name/dotnet

%changelog
