%define _unpackaged_files_terminate_build 1

%define _dotnet_major 3.1
%define _dotnet_corerelease %version
%define commithash %version-%release

%def_with bootstrap
# TODO:
%def_with skipmanaged
%def_with libunwind

%define pre %nil

Name: dotnet-coreclr-%_dotnet_major
Version: 3.1.32
Release: alt1

Summary: .NET Core runtime, called CoreCLR, and the base library, called mscorlib

License: MIT
Url: https://github.com/dotnet/coreclr
Group: Development/Other

# Source-url: https://github.com/dotnet/coreclr/archive/v%version%pre.tar.gz
Source: %name-%version.tar
Patch1: 0001-Add-support-for-building-under-glibc-2.26-13785.patch
Patch2: 0001-fix-build-with-clang6.0.patch
Patch3: dotnet-coreclr-alt-not-supported.patch

ExclusiveArch: aarch64 x86_64

#add_verify_elf_skiplist *.dbg

BuildRequires(pre): rpm-macros-dotnet

BuildRequires: /proc

BuildRequires: clang llvm python3

BuildRequires: cmake libstdc++-devel
%if_with libunwind
BuildRequires: libunwind-devel
%endif
BuildRequires: liblttng-ust-devel liblwp-devel
#BuildRequires: lldb-devel
BuildRequires: libicu-devel libuuid-devel zlib-devel libcurl-devel libkrb5-devel libssl-devel

# it is not linked directly (the same like in libicu-devel)
# there are icu detection in a version range
Requires: libicu

%if_with bootstrap
BuildRequires: dotnet-bootstrap-runtime-%_dotnet_major = %version
%define bootstrapdir %_libdir/dotnet-bootstrap-%_dotnet_major
%else
BuildRequires: dotnet
%define bootstrapdir %_dotnetdir
%endif

Requires: dotnet-common

Conflicts: dotnet-coreclr

%description
This package contains the .NET Core runtime, called CoreCLR,
and the base library, called mscorlib.

It includes the garbage collector, JIT compiler,
base .NET data types and many low-level classes.

.NET Core is a fast, lightweight and modular platform for creating
cross platform applications that work on Linux, Mac and Windows.

%prep
%setup
#patch1 -p1
#patch2 -p1
#patch3 -p2

# Starting with ICU 68 (2020q4), there is no longer TRUE and FALSE defines in public header files
# https://unicode-org.github.io/icu/userguide/dev/codingguidelines.html
#add_optflags -DU_DEFINE_FALSE_AND_TRUE=1
#__subst "s|-DPIC|-DPIC -DU_DEFINE_FALSE_AND_TRUE=1|" src/corefx/System.Globalization.Native/CMakeLists.txt

# replace obsoleted FindPythonInterp with FindPython3
sed -i -e 's|FindPythonInterp|FindPython3|' -e 's|PYTHON_EXECUTABLE|Python3_EXECUTABLE|' \
    src/pal/src/eventprovider/*/CMakeLists.txt src/vm/eventing/CMakeLists.txt \
    src/pal/tests/palsuite/eventprovider/CMakeLists.txt src/vm/eventing/*/CMakeLists.txt

%if_with libunwind
rm -rfv src/pal/src/libunwind/
%endif

# c8 hack
%__subst "s|VERSION 3....|VERSION 3.4.3|" CMakeLists.txt tests/CMakeLists.txt

%build
export DotNetCoreSdkDir=%bootstrapdir
export DotNetBuildToolsDir=%bootstrapdir
bash -x ./build.sh -release -verbose -skipnuget -ignorewarnings -skiprestoreoptdata -cmakeargs -DENABLE_LLDBPLUGIN=0 \
%if_with libunwind
    -cmakeargs -DCLR_CMAKE_USE_SYSTEM_LIBUNWIND=1 \
%endif
%if_with skipmanaged
    -skipmanaged \
%endif
    %nil

# FIXME: possible hack
cat <<EOF >.version
%version-%release
%_dotnet_corerelease
EOF

%install
mkdir -p %buildroot%_dotnet_shared/
# TODO: some publish use?
cp -a bin/Product/Linux.%_dotnet_arch.Release/{System.Globalization.Native.so,lib*.so,createdump,SOS_README.md} %buildroot%_dotnet_shared/

install -D -m644 .version %buildroot%_dotnet_shared/.version

# superpmi mcs
# https://github.com/dotnet/coreclr/tree/master/src/ToolBox/superpmi

# createdump
# verify-elf: ERROR: ./usr/lib64/dotnet/shared/Microsoft.NETCore.App/2.0.0/createdump: RPATH contains illegal entry "/tmp/.private/lav/RPM/BUILD": /tmp/.private/lav/RPM/BUILD/dotnet-coreclr-2.0.0/bin/obj/Linux.x64.Release/src/dlls/mscordac
# ldd: libmscordaccore.so => /tmp/.private/lav/RPM/BUILD/dotnet-coreclr-2.0.0/bin/obj/Linux.x64.Release/src/dlls/mscordac/libmscordaccore.so
#rm -f %buildroot%_libdir/dotnet/shared/Microsoft.NETCore.App/%_dotnet_corerelease/createdump

# TODO
rm -f %buildroot%_dotnet_shared/libsuperpmi-shim-*.so

rm -f %buildroot%_dotnet_shared/libprotononjit.so

mkdir -p %buildroot%_rpmlibdir
cat > %buildroot%_rpmlibdir/%name.filetrigger << EOF
#!/bin/sh
# remove obsoleted empty dirs (see discussion at https://github.com/dotnet/sdk/issues/2772)
rmdir %_dotnetdir/shared/Microsoft.NETCore.App/* 2>/dev/null || :
EOF
chmod 0755 %buildroot%_rpmlibdir/%name.filetrigger


%files
%doc CODE_OWNERS.TXT LICENSE.TXT PATENTS.TXT THIRD-PARTY-NOTICES.TXT README.md CONTRIBUTING.md
%dir %_dotnet_shared/
%_dotnet_shared/.version
%_dotnet_shared/System.Globalization.Native.so

%_dotnet_shared/libclrgc.so
%_dotnet_shared/libclrjit.so
%_dotnet_shared/libcoreclr.so
%_dotnet_shared/libcoreclrtraceptprovider.so
%_dotnet_shared/libdbgshim.so
%_dotnet_shared/libmscordaccore.so
%_dotnet_shared/libmscordbi.so
#ifarch x86_64
#_dotnet_shared/libprotononjit.so
#endif
# moved to dotnet/diagnostics repo
%_dotnet_shared/SOS_README.md
#_dotnet_shared/libsos.so
#_dotnet_shared/libsuperpmi-shim-collector.so
#_dotnet_shared/libsuperpmi-shim-counter.so
#_dotnet_shared/libsuperpmi-shim-simple.so

#_dotnet_shared/corerun
%_dotnet_shared/createdump
#_dotnet_shared/coreconsole
%_rpmlibdir/%name.filetrigger

%changelog
