# BEGIN SourceDeps(oneline):
BuildRequires: libGL-devel libICE-devel libX11-devel pkgconfig(dbus-1) pkgconfig(ecore-x) pkgconfig(libpulse) pkgconfig(xi)
# END SourceDeps(oneline)
Name: e16
Version: 1.0.11
Release: alt4
#Serial: 1

Summary: The Enlightenment DR16 window manager
License: GPL
Group: Graphical desktop/Enlightenment
Url: http://www.enlightenment.org/

Source: %name-%version.tar.gz
Source1: Enlightenment.xpm
Source2: start%name
# Menu method (deprecated!) hack scripts/e_gen_menu instead!
Source3: %name.wmsession

Source5: %name-menu.method
Source6: %name.xpm
Source7: %name-32.xpm

Obsoletes: enlightenment < 1:0.16.9
Provides: enlightenment = 1:0.16.9

# Automatically added by buildreq on Tue Dec 14 2004
BuildRequires: libesd-devel libfreetype-devel imlib2-devel libaudiofile-devel zlib-devel
BuildRequires: libSM-devel libpango-devel libXft-devel libGLU-devel
BuildRequires: libXext-devel libXinerama-devel libXxf86vm-devel
BuildRequires: libXScrnSaver-devel libXrandr-devel libXcomposite-devel
BuildRequires: libXdamage-devel libXfixes-devel libXrender-devel
BuildRequires: xorg-x11-bitmaps

%description
Enlightenment is a window manager for the X Window System that is designed to
be powerful, extensible, configurable and pretty darned good looking! It is one
of the more graphically intense window managers.

Enlightenment goes beyond managing windows by providing a useful and appealing
graphical shell from which to work. It is open in design and instead of
dictating a policy, allows the user to define their own policy, down to every
last detail.

This package will install the Enlightenment window manager.

%prep
%setup -q -n %name-%version

#perl -pi -e 's,/\$\(datadir\),%_datadir,g' po/Makefile.in.in
#perl -pi -e 's,\${prefix}/\${DATADIRNAME}/locale,%_datadir/locale,g' configure

%build
CFLAGS="$CFLAGS -I%_includedir/gnome-1.0" LOCALEDIR=%_datadir/locale %configure \
	--sysconfdir=%_sysconfdir/X11/%name \
	--enable-fsstd \
	--enable-sound \
	--enable-upgrade \
	--enable-pango \
	--enable-glx \
	--enable-zoom \
	--enable-xrandr

%make_build

%install
%make_install install DESTDIR=%buildroot 

# Menu method (deprecated!) hack scripts/e_gen_menu instead!
#install -pD -m755 %SOURCE5 %buildroot%_sysconfdir/menu-methods/%name

# Install icons
install -pD -m644 %SOURCE6 %buildroot%_miconsdir/%name.xpm
install -pD -m644 %SOURCE7 %buildroot%_niconsdir/%name.xpm
install -pD -m644 %SOURCE1 %buildroot%_iconsdir/hicolor/64x64/apps/%name.xpm

install -d %buildroot%_menudir
cat << EOF > %buildroot%_menudir/%name
?package(%name): needs=wm section=Session/Windowmanagers icon=%name.xpm title=E-16 command=%_bindir/%name
EOF

# wmsession.d
install -p -m755 %SOURCE2 %buildroot%_bindir/startE16
install -pD -m644 %SOURCE3 %buildroot%_sysconfdir/X11/wmsession.d/05E16

%find_lang e16

%add_findreq_skiplist %_bindir/*.pl
%add_findreq_skiplist %_datadir/e16/E-docs/*.pl
%add_findreq_skiplist %_datadir/e16/config/*.pl
%add_findreq_skiplist %_datadir/e16/themes/*
%add_findprov_skiplist %_bindir/*.pl
%add_findprov_skiplist %_datadir/%name/E-docs/*.pl
%add_findprov_skiplist %_datadir/%name/config/*.pl
%add_findprov_skiplist %_datadir/%name/themes/*

# kde, gnome deps
%add_findreq_skiplist %_bindir/starte16
%add_findreq_skiplist %_datadir/e16/misc/*

# unpackaged files
rm -f %buildroot/usr/share/applications/e16.desktop \
    %buildroot/usr/share/gnome-session/sessions/e16-gnome.session

%files -f e16.lang
%doc AUTHORS COMPLIANCE ChangeLog
# for old menu-method
#%config(noreplace) %_sysconfdir/menu-methods/*
#%dir %_sysconfdir/X11/%name
#%config(noreplace) %_sysconfdir/X11/%name/menus
%config %_sysconfdir/X11/wmsession.d/*
%_menudir/*
%_iconsdir/*/*/*/*.xpm
%_bindir/*
%_libdir/%name/*.so
%_datadir/e16
%_datadir/xsessions/*
%_man1dir/*
%_datadir/doc/%name

%changelog
