Name: e2fsprogs
Version: 1.47.1.0.10.ad56
Release: alt1.p10.1

Summary: The filesystem utilities for the ext2/ext3 filesystems
License: GPL-2.0-only
Group: System/Kernel and hardware
Url: http://e2fsprogs.sourceforge.net/

# git://git.altlinux.org/gears/e/e2fsprogs.git
Source: %name-%version-%release.tar

%def_enable static
%def_disable libblkid
%def_disable libuuid
%def_disable fsck
%def_with libarchive

Requires: libcom_err = %version-%release
Requires: libe2fs = %version-%release
Requires: libss = %version-%release
%{!?_enable_fsck:Requires: /sbin/fsck}
%{?_enable_libblkid:Requires: libblkid = %version-%release}
%{?_enable_libuuid:Requires: libuuid = %version-%release}

BuildRequires: makeinfo
%{!?_enable_libblkid:BuildRequires: libblkid-devel}
%{!?_enable_libuuid:BuildRequires: libuuid-devel}
%{?_with_libarchive:BuildRequires: libarchive-devel}
%{?!_without_check:%{?!_disable_check:BuildRequires: rpm-build-vm acl}}

%description
This package contains a number of utilities for creating, checking,
modifying and correcting any inconsistencies in EXT2 filesystems.

# libe2p, libext2fs
%package -n libe2fs
Summary: Dynamic ext2/ext3 filesystem libraries
License: LGPL-2.0-only and LGPL-2.1-or-later
Group: System/Libraries
Conflicts: %name < %version-%release
Requires: libcom_err = %version-%release

%description -n libe2fs
This package contains the shared libraries required by
EXT2/EXT3 filesystem-specific programs.

%package -n libe2fs-devel
Summary: Development ext2/ext3 filesystem libraries and include files
License: LGPL-2.0-only and LGPL-2.1-or-later
Group: Development/C
Provides: %name-devel = %version
Obsoletes: %name-devel
Requires: libe2fs = %version-%release
%{?_enable_libblkid:Requires: libblkid-devel = %version-%release}
%{?_enable_libuuid:Requires: libuuid-devel = %version-%release}
Requires: libcom_err-devel = %version-%release
Requires: libss-devel = %version-%release

%description -n libe2fs-devel
This package contains the libraries and include files needed to develop
EXT2/EXT3 filesystem-specific programs.

%package -n libe2fs-devel-static
Summary: Static ext2/ext3 filesystem libraries
License: LGPL-2.0-only and LGPL-2.1-or-later
Group: Development/C
Conflicts: %name-devel < %version
Requires: libe2fs-devel = %version-%release
%{?_enable_libblkid:Requires: libblkid-devel-static = %version-%release}
%{?_enable_libuuid:Requires: libuuid-devel-static = %version-%release}
Requires: libcom_err-devel-static = %version-%release
Requires: libss-devel-static = %version-%release

%description -n libe2fs-devel-static
This package contains the static libraries needed to develop statically
linked EXT2/EXT3 filesystem-specific programs.

# libblkid
%package -n libblkid
Summary: Dynamic block device id library
License: LGPL-2.1-only
Group: System/Libraries
Conflicts: %name < %version-%release, libe2fs < %version-%release
%{?_enable_libuuid:Requires: libuuid = %version-%release}

%description -n libblkid
The blkid library which allows system programs like fsck and mount to
quickly and easily find block devices by filesystem UUID and LABEL.

%package -n libblkid-devel
Summary: Development block device id library and include files
License: LGPL-2.1-only
Group: Development/C
Provides: %name-devel = %version
Obsoletes: %name-devel
Requires: libblkid = %version-%release

%description -n libblkid-devel
This package contains the library and include files needed to develop
libblkid-based software.

%package -n libblkid-devel-static
Summary: Static block device id library
License: LGPL-2.1-only
Group: Development/C
Requires: libblkid-devel = %version-%release
Conflicts: %name-devel < %version, libe2fs-devel < %version-%release
Requires: libuuid-devel-static = %version-%release

%description -n libblkid-devel-static
This package contains the library and include files needed to develop
statically linked libblkid-based software.

# libcom_err
%package -n libcom_err
Summary: Dynamic common error description library
License: MIT
Group: System/Libraries
Conflicts: %name < %version-%release, libe2fs < %version-%release

%description -n libcom_err
The com_err library is an attempt to present a common error-handling
mechanism to manipulate the most common form of error code in a fashion
that does not have the problems identified with mechanisms commonly
in use.

%package -n libcom_err-devel
Summary: Development common error description library and include files
License: MIT
Group: Development/C
Provides: %name-devel = %version
Obsoletes: %name-devel
Requires: libcom_err = %version-%release

%description -n libcom_err-devel
This package contains the library and include files needed to develop
libcom_err-based software.

%package -n libcom_err-devel-static
Summary: Static common error description library
License: MIT
Group: Development/C
Requires: libcom_err-devel = %version-%release
Conflicts: %name-devel < %version, libe2fs-devel < %version-%release

%description -n libcom_err-devel-static
This package contains the library and include files needed to develop
statically linked libcom_err-based software.

# libss
%package -n libss
Summary: Dynamic command-line interface parsing library
License: MIT
Group: System/Libraries
Conflicts: %name < %version-%release, libe2fs < %version-%release
Requires: libcom_err = %version-%release

%description -n libss
This package contains the library that parses a command table to generate
a simple command-line interface parser.

%package -n libss-devel
Summary: Development command-line interface parsing library and include files
License: MIT
Group: Development/C
Provides: %name-devel = %version
Obsoletes: %name-devel
Requires: libss = %version-%release
Requires: libcom_err-devel = %version-%release

%description -n libss-devel
This package contains the library and include files needed to develop
libss-based software.

%package -n libss-devel-static
Summary: Static command-line interface parsing library
License: MIT
Group: Development/C
Conflicts: %name-devel < %version, libe2fs-devel < %version-%release
Requires: libss-devel = %version-%release
Requires: libcom_err-devel-static = %version-%release

%description -n libss-devel-static
This package contains the library and include files needed to develop
statically linked libss-based software.

# libuuid
%package -n libuuid
Summary: Dynamic universally unique id library
License: BSD-3-Clause
Group: System/Libraries
Conflicts: %name < %version-%release, libe2fs < %version-%release

%description -n libuuid
The uuid library generates and parses 128-bit universally unique id's
(UUID's).  See RFC 4122 for more information.

%package -n libuuid-devel
Summary: Development universally unique id library and include files
License: BSD-3-Clause
Group: Development/C
Provides: %name-devel = %version
Obsoletes: %name-devel
Requires: libuuid = %version-%release

%description -n libuuid-devel
This package contains the library and include files needed to develop
libuuid-based software.

%package -n libuuid-devel-static
Summary: Static universally unique id library
License: BSD-3-Clause
Group: Development/C
Requires: libuuid-devel = %version-%release
Conflicts: %name-devel < %version, libe2fs-devel < %version-%release

%description -n libuuid-devel-static
This package contains the library and include files needed to develop
statically linked libuuid-based software.

%prep
%setup -n %name-%version-%release

find -type f -print0 |
	xargs -r0 grep -lZ '^static void usage' -- |
	xargs -r0 sed -i 's/^static void usage/__attribute__ ((noreturn)) &/' --

# Remove these header files just in case.
rm -r include

%build
%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
%add_optflags -D_LARGEFILE64_SOURCE -fno-strict-aliasing
# e2fsprogs's LD=$CC breaks autoconf test
export acl_cv_prog_gnu_ld=yes
autoconf
%configure \
	--sbindir=/sbin \
	--disable-uuidd \
	--enable-nls \
	--enable-elf-shlibs \
	%{subst_enable libblkid} \
	%{subst_enable libuuid} \
	%{subst_enable fsck} \
	%{subst_with libarchive} \
	#

%make_build V=1

%install
mkdir -p %buildroot{/%_lib,%_includedir/e2p}

%makeinstall_std install-libs V=1

ln -snf et/com_err.h %buildroot%_includedir/

sed -i 's,^ET_DIR=.*$,ET_DIR=%_datadir/et,' %buildroot%_bindir/compile_et
sed -i 's,^SS_DIR=.*$,SS_DIR=%_datadir/ss,' %buildroot%_bindir/mk_cmds

mv %buildroot%_libdir/e2initrd_helper %buildroot/sbin/

# Relocate shared libraries from %_libdir/ to /%_lib/.
for f in %buildroot%_libdir/*.so; do
	t=$(readlink "$f")
	ln -snf ../../%_lib/"$t" "$f"
done
mv %buildroot%_libdir/*.so.* %buildroot/%_lib/

# Get rid of duplicate files.
for i in ext2 ext3 ext4 ext4dev; do
	ln -snf e2fsck %buildroot/sbin/fsck.$i
	ln -snf e2fsck.8 %buildroot%_man8dir/fsck.$i.8

	ln -snf mke2fs %buildroot/sbin/mkfs.$i
	ln -snf mke2fs.8 %buildroot%_man8dir/mkfs.$i.8
done

# Prepare docs.
cat -- $(ls doc/RelNotes/*.txt |tac) |xz -9 > NEWS.xz
chmod -R a+rX,go-w %buildroot%_mandir

%find_lang %name

# Ensure that buildroot did not get info installed files.
! grep -F -rl %buildroot %buildroot

%check
%ifarch ppc64le
# This root-only test fails because the expected number of changed sectors is
# 224, but on ppc64le it raises to 640.  This is likely due to a different
# behavior of the tmpfs filesystem, possibly related to huge pages.
# With the increased expected number, the test still ensures that in
# "-E assume_storage_prezeroed=1" mode, mkfs modifies a significantly smaller
# number of sectors.
printf '%s\n' '> 10000' '640' > tests/m_assume_storage_prezeroed/expect
%endif

# The entire test suite is run twice on systems with KVM, but this way we are
# sure that the package is also tested on systems lacking KVM support.
vm-run --kvm=cond --ext4 --sbin %make_build -k check V=1
%make_build -k check V=1 PATH=/sbin:/usr/sbin:/bin:/usr/bin

%set_verify_elf_method strict
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1

%files -f %name.lang
%config(noreplace) %_sysconfdir/*.conf
/sbin/*
%_bindir/*attr
%_man1dir/*attr.*
%if_enabled libuuid
%_bindir/uuidgen
%_man1dir/uuidgen.*
%endif # libuuid
%_man5dir/*
%_man8dir/*
%doc README NEWS*

# libe2p, libext2fs
%files -n libe2fs
/%_lib/libe2p.so.*
/%_lib/libext2fs.so.*

%files -n libe2fs-devel
%_pkgconfigdir/e2p.pc
%_libdir/libe2p.so
%_includedir/e2p
%_pkgconfigdir/ext2fs.pc
%_libdir/libext2fs.so
%_includedir/ext2fs
%_infodir/*.info*

%files -n libe2fs-devel-static
%_libdir/libe2p.a
%_libdir/libext2fs.a

%if_enabled libblkid
# libblkid
%files -n libblkid
/%_lib/libblkid.so.*

%files -n libblkid-devel
%_pkgconfigdir/blkid.pc
%_libdir/libblkid.so
%_includedir/blkid
%_man3dir/libblkid*

%files -n libblkid-devel-static
%_libdir/libblkid.a
%endif # libblkid

# libcom_err
%files -n libcom_err
/%_lib/libcom_err.so.*

%files -n libcom_err-devel
%_pkgconfigdir/com_err.pc
%_libdir/libcom_err.so
%_includedir/et
%_includedir/com_err.h
%_man3dir/com_err*
%_datadir/et
%_bindir/compile_et
%_man1dir/compile_et*

%files -n libcom_err-devel-static
%_libdir/libcom_err.a

# libss
%files -n libss
/%_lib/libss.so.*

%files -n libss-devel
%_pkgconfigdir/ss.pc
%_libdir/libss.so
%_includedir/ss
%_datadir/ss
%_bindir/mk_cmds
%_man1dir/mk_cmds*

%files -n libss-devel-static
%_libdir/libss.a

%if_enabled libuuid
# libuuid
%files -n libuuid
/%_lib/libuuid.so.*
%doc lib/uuid/COPYING

%files -n libuuid-devel
%_pkgconfigdir/uuid.pc
%_libdir/libuuid.so
%_includedir/uuid
%_man3dir/uuid*

%files -n libuuid-devel-static
%_libdir/libuuid.a
%endif # libuuid

%changelog
