%define TOOL_CHAIN_TAG GCC

# More subpackages to come once licensing issues are fixed
Name: edk2-tools
Version: 20250221
Release: alt1
Summary: EFI Development Kit II Tools

#Vcs-Git: https://github.com/tianocore/edk2.git
Source: %name-%version.tar

Source2: openssl.tar
Source3: berkeley-softfloat-3.tar
Source4: Logo.bmp

Patch1: %name-%version.patch

License: BSD-2-Clause-Patent
Group: Emulators
Url: http://www.tianocore.org

ExclusiveArch:  %ix86 x86_64 %arm aarch64 loongarch64

BuildRequires(pre): rpm-build-python3
BuildRequires: iasl nasm gcc-c++
BuildRequires: python3-devel python3-modules-sqlite3
BuildRequires: libuuid-devel
BuildRequires: bc

%description
This package provides tools that are needed to
build EFI executables and ROMs using the GNU tools.

%package python
Summary: EFI Development Kit II Tools
Group: Development/Python3
BuildArch: noarch

%description python
This package provides tools that are needed to build EFI executables
and ROMs using the GNU tools.  You do not need to install this package;
you probably want to install edk2-tools only.

%package doc
Summary: Documentation for EFI Development Kit II Tools
Group: Development/Documentation
BuildArch: noarch

%description doc
This package documents the tools that are needed to
build EFI executables and ROMs using the GNU tools.

%prep
%setup -q
%patch1 -p1

cp -f %SOURCE4 MdeModulePkg/Logo/

# cleanup
find . -name '*.efi' -print0 | xargs -0 rm -f
rm -rf BaseTools/Bin \
        UefiCpuPkg/ResetVector/Vtf0/Bin/*.raw \
        EdkCompatibilityPkg/Other \
        AppPkg \
        DuetPkg/BootSector/bin \
        StdLib/LibC/Main/Ia32/ftol2.obj \
        BeagleBoardPkg/Debugger_scripts/rvi_dummy.axf \
        BaseTools/Source/Python/*/*.pyd \
        BaseTools/Source/Python/UPT/Dll/sqlite3.dll \
        Vlv2TbltDevicePkg/GenBiosId \
        Vlv2TbltDevicePkg/*.exe \
        ArmPkg/Library/GccLto/liblto-*.a

# Ensure old shell and binary packages are not used
rm -rf EdkShellBinPkg
rm -rf EdkShellPkg
rm -rf FatBinPkg
rm -rf ShellBinPkg

# add openssl
mkdir -p CryptoPkg/Library/OpensslLib/openssl
tar -xf %SOURCE2 --strip-components 1 --directory CryptoPkg/Library/OpensslLib/openssl

# add /berkeley-softfloat-3
mkdir -p ArmPkg/Library/ArmSoftFloatLib/berkeley-softfloat-3
tar -xf %SOURCE3 --strip-components 1 --directory ArmPkg/Library/ArmSoftFloatLib/berkeley-softfloat-3

%build
export PYTHON_COMMAND=%__python3
source ./edksetup.sh

# compiler
CC_FLAGS="-t %TOOL_CHAIN_TAG"

# common features
#CC_FLAGS="${CC_FLAGS} --cmd-len=65536 -b DEBUG --hash"
CC_FLAGS="${CC_FLAGS} -b RELEASE"
#CC_FLAGS="${CC_FLAGS} -b DEBUG --hash"
CC_FLAGS="${CC_FLAGS} --cmd-len=65536"
ARM_FLAGS="${CC_FLAGS}"

unset MAKEFLAGS

%make_build \
        -C BaseTools

%install
# install BaseTools
mkdir -p %buildroot%_bindir \
         %buildroot%_datadir/edk2/Conf \
         %buildroot%_datadir/edk2/Scripts

pushd BaseTools
install \
        Source/C/bin/* \
        %buildroot%_bindir

install \
        BinWrappers/PosixLike/LzmaF86Compress \
        %buildroot%_bindir

install \
        BuildEnv \
        %buildroot%_datadir/edk2

install \
        Conf/*.template \
        %buildroot%_datadir/edk2/Conf

install \
        Scripts/GccBase.lds \
        %buildroot%_datadir/edk2/Scripts

cp -R Source/Python %buildroot%_datadir/edk2/Python

find %buildroot%_datadir/edk2/Python -name "*.pyd" | xargs rm -f

for i in BPDG Ecc GenDepex GenFds GenPatchPcdTable PatchPcdValue TargetTool Trim UPT; do
  echo '#!/bin/sh
export PYTHONPATH=%_datadir/edk2/Python
exec python3 '%_datadir/edk2/Python/$i/$i.py' "$@"' > %buildroot%_bindir/$i
  chmod +x %buildroot%_bindir/$i
done

popd

%files
%_bindir/DevicePath
%_bindir/EfiRom
%_bindir/GenCrc32
%_bindir/GenFfs
%_bindir/GenFv
%_bindir/GenFw
%_bindir/GenSec
%_bindir/LzmaCompress
%_bindir/LzmaF86Compress
%_bindir/TianoCompress
%_bindir/VfrCompile
%_bindir/VolInfo
%_datadir/edk2/BuildEnv
%_datadir/edk2/Conf
%_datadir/edk2/Scripts

%files python
%_bindir/BPDG
%_bindir/Ecc
%_bindir/GenDepex
%_bindir/GenFds
%_bindir/GenPatchPcdTable
%_bindir/PatchPcdValue
%_bindir/TargetTool
%_bindir/Trim
%_bindir/UPT
%_datadir/edk2/Python/

%files doc
%doc BaseTools/UserManuals/*.rtf

%changelog
