Name: elinks
Version: 0.15.0
Release: alt2

Summary: Lynx-like text WWW browser with many features
License: GPLv2
Group: Networking/WWW

URL: http://elinks.cz
# https://github.com/rkd77/elinks
Source: %name-%version.tar
Source1: elinks.conf
Patch0: 0001-Make-gcc-happy.patch
Patch1: 0002-less-info-in-user-ag-header.patch
Patch2: 0003-Fix-OpenSSL-1.1-compat.patch
Patch3: 0004-fix-dereference-error.patch
Patch4: 0005-fix-unused-result-errors.patch
Patch5: 0006-fix-address-always-true-error.patch
Patch6: 0007-fix-address-always-true-error.patch

# alternatives
%set_compress_method gzip
%define weight 30
Requires(pre,postun): alternatives >= 0.2.0
BuildPreReq: alternatives >= 0.2.0

Provides: webclient, links
Provides: %_bindir/links
Obsoletes: links

# Automatically added by buildreq on Wed Sep 30 2009
BuildRequires: bzlib-devel docbook-utils libexpat-devel libgpm-devel lua-devel libssl-devel python-modules-encodings xmlto zlib-devel
BuildRequires: python3 gcc-c++


%description
ELinks is advanced text-mode web browser with wide scale of additional
features and extensibility by possibility to plug in own scripts in Lua
language. This project aims to provide feature-rich version of Links,
with more open patches/features inclusion policy.

%prep
%setup
%patch0 -p2
%patch1 -p2
%patch2 -p2
%patch3 -p2
%patch4 -p2
%patch5 -p2
%patch6 -p2

# fix shebang
sed -i 's,/usr/bin/env python,%_bindir/python,' doc/tools/asciidoc/asciidoc.py

# fix old bison behaivour
sed -i '/rm -f \$\*.h/s/^/# /' src/intl/gettext/Makefile

%build
cat config/m4/*.m4 >acinclude.m4
%autoreconf
export ac_cv_prog_HAVE_SMBCLIENT=no
%configure %{subst_enable debug} \
	--sysconfdir=/etc/elinks \
	--without-x \
	--enable-utf-8 \
	--enable-256-colors \
	--enable-cgi \
	--enable-finger \
	--enable-gopher \
	--enable-nntp \
	--disable-smb \
	--disable-leds \
	--without-spidermonkey \
	--without-idn \
	--without-lzma \
	#
touch src/intl/gettext/plural.y
make -C src/intl/gettext V=1 plural.c

%add_optflags -Wno-error=builtin-declaration-mismatch
%add_optflags -fno-strict-aliasing -Wno-pointer-sign -Werror
%ifarch %e2k
# elinks-0.12/src/util/error.h:189 (#define if_assert_failed) => ftbfs on e2k
%add_optflags  -Wno-error=assign-where-compare-meant
# textarea.c:46 (int split_prev:1) => error #108: signed bit field of length 1
%add_optflags -Wno-error=signed-one-bit-field
%endif

make -C src V=1 CFLAGS="%optflags"
make -C doc V=1 features.txt manual.html

%install
%makeinstall_std V=1

mkdir -p %buildroot%_altdir
cat <<__EOF__ >%buildroot%_altdir/elinks
%_bindir/links		%_bindir/elinks		%weight
%_man1dir/links.1.gz	%_man1dir/elinks.1.gz	%_bindir/elinks
__EOF__

install -pD -m644 %SOURCE1 %buildroot/etc/elinks/elinks.conf

%find_lang elinks

%files -f elinks.lang
%_bindir/elinks
%dir /etc/elinks
%config(noreplace) /etc/elinks/elinks.conf
%_man1dir/elinks.*
%_man5dir/elinks*
%_altdir/elinks
%doc AUTHORS COPYING NEWS README THANKS
%doc doc/manual.html

%changelog
