Name: fail2ban
Version: 0.11.2
Release: alt2

Summary: Fail2Ban is an intrusion prevention framework

License: GPL v2
Group: Development/Python
Url: http://www.fail2ban.org

# Source-git: https://github.com/fail2ban/fail2ban.git
Source: %name-%version.tar
Source1: alt-initd
Source2: fail2ban.service
Source3: fail2ban-logrotate
Source4: paths-altlinux.conf
Source5: paths-altlinux-systemd.conf

# CVE-2021-32749
Patch1: 410a6ce5c80dd981c22752da034f2529b5eee844.patch
Patch2: 747d4683221b5584f9663695fb48145689b42ceb.patch
# python 3.10 fix
Patch3: ea26509594a3220b012071604d73bb42d0ecae2c.patch

BuildArch: noarch

BuildRequires: help2man
BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-build-intro
BuildRequires: python3-module-urllib3
BuildRequires: python3-tools

AutoProv: no

# due to /etc/fail2ban/action.d/badips.py
%add_python3_lib_path /etc/fail2ban

# obsoleted
%add_python3_req_skip gamin

# https://bugzilla.altlinux.org/show_bug.cgi?id=31041
%add_python3_req_skip systemd

%description
Fail2Ban is an intrusion prevention framework written in the Python
programming language. It is able to run on POSIX systems that have an
interface to a packet-control system or firewall installed locally
(for example, iptables or TCP Wrapper).

Recommends: python3-module-systemd

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1
%__subst "s|paths-debian.conf|paths-altlinux.conf|g" config/jail.conf
# setuptools>=58 breaks support for use_2to3
%__subst "s|.*use_2to3.*||" setup.py
python3-2to3 -w --no-diffs bin/* fail2ban
%__subst "s|/usr/bin/env python|%__python3|" bin/*

%build
%python3_build
export PYTHONPATH=$PWD
cd man
./generate-man

%install
%python3_install
%python3_prune

mkdir -p %buildroot%_man1dir/
cp man/*.1 %buildroot%_man1dir/
mkdir -p %buildroot%_man5dir/
cp man/*.5 %buildroot%_man5dir/
install -d %buildroot%_var/run/fail2ban

install -pD -m 744 %SOURCE1 %buildroot%_initdir/fail2ban
install -pD -m 644 %SOURCE2 %buildroot%_unitdir/%name.service
install -pD -m 644 %SOURCE3 %buildroot%_logrotatedir/fail2ban
install -pD -m 644 %SOURCE4 %buildroot%_sysconfdir/%name/paths-altlinux.conf
install -pD -m 644 %SOURCE5 %buildroot%_sysconfdir/%name/paths-altlinux-systemd.conf

mkdir -p %buildroot%_tmpfilesdir/
echo "d /var/run/fail2ban 0755 root root -" >%buildroot%_tmpfilesdir/%name.conf

rm -rv %buildroot/%_docdir/%name/
rm -v %buildroot%_sysconfdir/%name/paths-{arch,debian,fedora,freebsd,osx,opensuse}.conf
rm -v %buildroot/usr/bin/fail2ban-testcases

mkdir -p %buildroot%_var/lib/fail2ban/

%post
%post_service %name

%preun
%preun_service %name

%files
%doc ChangeLog README.md THANKS TODO
%python3_sitelibdir/%name/
%python3_sitelibdir/%{name}*.egg-info/
#%_datadir/%name/
%_bindir/%name-python
%_bindir/%name-client
%_bindir/%name-server
%_bindir/%name-regex
%dir %_sysconfdir/%name/
%dir %_sysconfdir/%name/*.d
%dir %_sysconfdir/%name/filter.d/ignorecommands
%config(noreplace) %_sysconfdir/%name/*.conf
%config(noreplace) %_sysconfdir/%name/*.d/*.conf
%config(noreplace) %_sysconfdir/%name/*.d/*.py
%config(noreplace) %_sysconfdir/%name/filter.d/ignorecommands/*
%exclude %_sysconfdir/fail2ban/action.d/__pycache__/
%_var/run/fail2ban/
%_var/lib/fail2ban/
%_initdir/fail2ban
%_unitdir/%name.service
%_man1dir/*
%_man5dir/*
%_tmpfilesdir/%name.conf
%_logrotatedir/%name

%changelog
