%def_enable gfio
%def_enable numa
%def_enable gfapi
%def_enable rdmacm
%ifarch %ix86 %arm %mips32 ppc
%def_disable rbd
%else
%def_enable rbd
%endif
%def_enable http

Name: fio
Version: 3.26
Release: alt1

Summary: IO testing tool
License: GPLv2
Group: System/Kernel and hardware

Url: http://git.kernel.dk/?p=fio.git;a=summary
Source0: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: libaio-devel zlib-devel
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-sphinx

%{?_enable_gfio:BuildRequires: libgtk+2-devel}
%{?_enable_numa:BuildRequires: libnuma-devel }
%{?_enable_rbd:BuildRequires: ceph-devel}
%{?_enable_gfapi:BuildRequires: libglusterfs-devel}
%{?_enable_rdmacm:BuildRequires: librdmacm-devel}
%{?_enable_http:BuildRequires: libcurl-devel libssl-devel}

Conflicts: python3-module-fiona

%description
fio is a tool that will spawn a number of threads or processes doing a
particular type of io action as specified by the user. fio takes a
number of global parameters, each inherited by the thread unless
otherwise parameters given to them overriding that setting is given.
The typical use of fio is to write a job file matching the io load
one wants to simulate.


%package tools
Summary: Analyze tools for %name
Group: System/Kernel and hardware
Requires: %name = %version-%release

%description tools
fio2gnuplot - analyze a set of fio's log files to turn them into a set of graphical traces using gnuplot tool.
fio_generate_plots - Generate plots for Flexible I/O Tester

%package -n gfio
Summary: Gtk frontend for %name
Group: System/Kernel and hardware
Requires: %name = %version-%release

%description -n gfio
fio is a tool that will spawn a number of threads or processes doing a
particular type of io action as specified by the user. fio takes a
number of global parameters, each inherited by the thread unless
otherwise parameters given to them overriding that setting is given.
The typical use of fio is to write a job file matching the io load
one wants to simulate.

This package conteon gtk frontend for %name


%prep
%setup
%patch -p1
find tools -type f | xargs subst "s|/usr/bin/python2.7|%__python3|"

%build
./configure \
	--prefix=%_prefix \
	--disable-optimizations \
	%{subst_enable gfio} \
	--extra-cflags="%optflags"

%make_build V=1 EXTFLAGS="%optflags"
%make_build -C doc html SPHINXBUILD=sphinx-build-3

%install
%make_install DESTDIR=%buildroot install prefix=%_prefix mandir=%_mandir

%files
%doc HOWTO README REPORTING-BUGS examples doc/output/html
%_bindir/genfio
%_bindir/%name
%_man1dir/%name.1.*

%files tools
%_bindir/*
%_datadir/%name
%_man1dir/*
%exclude %_bindir/gfio
%exclude %_bindir/fio
%exclude %_bindir/genfio
%exclude %_man1dir/%name.1.*

%files -n gfio
%_bindir/gfio

%changelog
