%define _unpackaged_files_terminate_build 1

%define major 3.0.7.33374
%define minor 0
%define pkgname Firebird
%define pkgversion %major-%minor
%define fbroot %_libdir/%name

Name: firebird
Version: %major.%minor
Release: alt1
Summary: Firebird SQL Database, fork of InterBase
Group: Databases
License: IPL
Url: https://www.firebirdsql.org/

# https://github.com/FirebirdSQL/firebird.git
Source: %name-%version.tar
Source1: %name.init
Source2: %name.tmpfiles.conf.in

Patch1: %name-3.0.5.33220.0-fedora-obsolete-syslogd.target.patch
Patch2: %name-3.0.5.33220.0-fedora-no-copy-from-icu.patch
Patch3: %name-3.0.5.33220.0-fedora-honour-buildflags.patch
Patch4: %name-3.0.5.33220.0-fedora-cloop-honour-build-flags.patch
Patch5: %name-3.0.5.33220.0-fedora-add-pkgconfig-files.patch
Patch6: %name-3.0.5.33220.0-fedora-Provide-sized-global-delete-operators-when-compiled.patch

Requires: libfbclient = %EVR

BuildPreReq: rpm-build-compat
BuildRequires: libtinfo-devel libicu-devel libedit-devel
BuildRequires: gcc gcc-c++
BuildRequires: autoconf
BuildRequires: automake
BuildRequires: bison
BuildRequires: libtool
BuildRequires: libncurses-devel
BuildRequires: zlib-devel libtommath-devel
BuildRequires: libtomcrypt-devel

Obsoletes: %name-superserver
Conflicts: %name-superserver < %EVR
Provides: %name-superserver = %EVR
Obsoletes: %name-classic
Conflicts: %name-classic < %EVR
Provides: %name-classic = %EVR

%description
This is the Firebird SQL Database shared files.

%package devel
Summary: Development Libraries for Firebird SQL Database
Group: Development/Databases
Requires: %name = %EVR

%description devel
Development libraries for firebird.

%package utils
Summary: Client programs for Firebird SQL Database
Group: Databases
Requires: %name = %EVR
Obsoletes: %name-client-embedded <= 2.0
Obsoletes: %name-utils-superserver
Conflicts: %name-utils-superserver < %EVR
Provides: %name-utils-superserver = %EVR
Obsoletes: %name-utils-classic
Conflicts: %name-utils-classic < %EVR
Provides: %name-utils-classic = %EVR

%description utils
Client access tools for firebird.

%package -n libfbclient
Summary: Multi-threaded, non-local client libraries for Firebird SQL Database
Group: System/Libraries

%description -n libfbclient
Multi-threaded, non-local client libraries for Firebird SQL Database

%package server
Summary: Server for Firebird SQL Database
Group: Databases
Requires: %name = %EVR
Obsoletes: %name-server-superserver
Conflicts: %name-server-superserver < %EVR
Provides: %name-server-superserver = %EVR
Obsoletes: %name-server-classic
Conflicts: %name-server-classic < %EVR
Provides: %name-server-classic = %EVR
Obsoletes: %name-server-common
Conflicts: %name-server-common < %EVR
Provides: %name-server-common = %EVR
%add_findreq_skiplist %_sbindir/changeServerMode.sh

%description server
This is the server for the Firebird SQL Database.
It can also be used as an embedded server, when paired with the
client-embedded package.

It does not include any client access tools, nor does it include the
multi-threaded client library.

%package doc
Summary: Documentation for Firebird SQL server
Group: Databases
Requires: %name-server = %EVR
BuildArch: noarch

%description doc
Documentation for Firebird SQL server.

%package examples
Summary: Examples for Firebird SQL server
Group: Databases
Requires: %name-server = %EVR

%description examples
Examples for Firebird SQL server.

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1

# sed vs patch for portability and addtional location changes
# based on FIREBIRD=%_libdir/firebird
check_sed() {
	MSG="sed of $3, required $2 line(s) modified $1"
	echo "${MSG}"
	[[ $1 -ge $2 ]] || { echo "${MSG}" ; exit -1 ; }
}

check_sed "$(sed -i -e 's:"isql :"isql-fb :w /dev/stdout' \
	src/isql/isql.epp | wc -l)" "1" "src/isql/isql.epp" # 1 line
check_sed "$(sed -i -e 's:isql :isql-fb :w /dev/stdout' \
	src/msgs/history2.sql | wc -l)" "4" "src/msgs/history2.sql" # 4 lines
check_sed "$(sed -i -e 's:--- ISQL:--- ISQL-FB:w /dev/stdout' \
	-e 's:isql :isql-fb :w /dev/stdout' \
	-e 's:ISQL :ISQL-FB :w /dev/stdout' \
	src/msgs/messages2.sql | wc -l)" "6" "src/msgs/messages2.sql" # 6 lines

find . -name \*.sh -exec chmod +x {} + || { echo "chmod failed" ; exit -1 ; }
rm -rf ./extern/{editline,icu,libtomcrypt,libtommath,zlib} || { echo "rm -rf failed" ; exit -1 ;}

%build
%add_optflags -fno-sized-deallocation -fno-delete-null-pointer-checks -I%_includedir/tommath
%add_optflags -fno-strict-aliasing
%add_optflags -Wno-deprecated -Wno-switch

%autoreconf
%configure \
	--prefix=%fbroot \
	--with-system-editline \
	--with-fbbin=%_bindir \
	--with-fbsbin=%_sbindir \
	--with-fbconf=%_sysconfdir/%name \
	--with-fblib=%_libdir \
	--with-fbinclude=%_includedir/%name \
	--with-fbdoc=%_defaultdocdir/%name \
	--with-fbudf=%_libdir/%name/udf \
	--with-fbsample=%_defaultdocdir/%name/sample \
	--with-fbsample-db=%_localstatedir/%name/data/ \
	--with-fbhelp=%_localstatedir/%name/system/ \
	--with-fbintl=%_libdir/%name/intl \
	--with-fbmisc=%_datadir/%name/misc \
	--with-fbsecure-db=%_localstatedir/%name/secdb/ \
	--with-fbmsg=%_localstatedir/%name/system/ \
	--with-fblog=%_logdir/%name \
	--with-fbglock=%_runtimedir/%name \
	--with-fbplugins=%_libdir/%name/plugins \
	--disable-rpath \
	%nil

%make

pushd gen
%make -f Makefile.install buildRoot
chmod -R u+w buildroot%{_docdir}/%{name}
chmod u+rw,a+rx buildroot/usr/include/firebird/firebird/impl
popd

%install
mkdir -p %buildroot
cp -r gen/buildroot/* %buildroot/

# prepare dir
mkdir -p %buildroot%_sysconfdir/xinetd.d
mkdir -p %buildroot%_initdir
mkdir -p %buildroot%fbroot/intl
mkdir -p %buildroot%_datadir/%name
mkdir -p %buildroot%_sysconfdir/profile.d
mkdir -p %buildroot%_localstatedir/%name/backup
mkdir -p %buildroot%_logdir/%name/
mkdir -p %buildroot%_unitdir
mkdir -p %buildroot%_pkgconfigdir
mkdir -p %buildroot%_tmpfilesdir

cp -a src/misc/upgrade %buildroot%_datadir/%name

install -m 0644 gen/install/misc/firebird-superserver.service %buildroot%_unitdir/
install -m 0644 gen/install/misc/firebird-classic@.service %buildroot%_unitdir/
install -m 0644 gen/install/misc/firebird-classic.socket %buildroot%_unitdir/

sed -e "s|@runtimedir@|%_runtimedir|g" -e "s|@name@|%name|g" %SOURCE2 > %buildroot%_tmpfilesdir/%name.conf

cp -v gen/install/misc/*.pc %buildroot%_pkgconfigdir

pushd gen/Release/%name
# intl
cp intl/libfbintl.so %buildroot%fbroot/intl/fbintl.so
cp -a bin/posixLibrary.sh %buildroot%_datadir/%name
# examples
cp -a examples %buildroot%_datadir/%name
popd

mv %buildroot%fbroot/intl/fbintl.conf %buildroot%_sysconfdir/%name/fbintl.conf
ln -sf $(relative %_sysconfdir/%name/fbintl.conf %fbroot/intl/fbintl.conf) %buildroot%fbroot/intl/fbintl.conf
ln -sf fbintl.so %buildroot%fbroot/intl/libfbintl.so
ln -sf $(relative %fbroot/intl/fbintl.so %_sysconfdir/%name/libfbintl.so) %buildroot%_sysconfdir/%name/libfbintl.so

# services
install -m 755 %SOURCE1 %buildroot%_initdir/%name
mv %buildroot%_datadir/%name/misc/%name.xinetd %buildroot%_sysconfdir/xinetd.d/%name

# log
touch %buildroot%_logdir/%name/%name.log

mv %buildroot%_bindir/isql %buildroot%_bindir/isql-fb
mv %buildroot%_bindir/gstat %buildroot%_bindir/gstat-fb
mv %buildroot%_sbindir/fb_config %buildroot%_bindir/fb_config
mv %buildroot%_sysconfdir/%name/README %buildroot%_docdir/%name/
mv %buildroot%_sysconfdir/%name/{WhatsNew,*.txt} %buildroot%_docdir/%name/

rm -f %buildroot%_sbindir/FirebirdUninstall.sh
rm -rf %buildroot%_datadir/%name/misc/upgrade
rm -f %buildroot%_datadir/%name/misc/firebird-classic.socket
rm -f %buildroot%_datadir/%name/misc/firebird-classic@.service
rm -f %buildroot%_datadir/%name/misc/firebird-superserver.service
rm -f %buildroot%_datadir/%name/misc/firebird.init.d.debian
rm -f %buildroot%_datadir/%name/misc/firebird.init.d.generic
rm -f %buildroot%_datadir/%name/misc/firebird.init.d.gentoo
rm -f %buildroot%_datadir/%name/misc/firebird.init.d.mandrake
rm -f %buildroot%_datadir/%name/misc/firebird.init.d.slackware
rm -f %buildroot%_datadir/%name/misc/firebird.init.d.suse
rm -f %buildroot%_datadir/%name/misc/rc.config.firebird

# -----------------------------------------------------------------------------
# server-common scripts
# -----------------------------------------------------------------------------
%post server
if [ ! -f %_sysconfdir/gds_hosts.equiv ]; then
	echo localhost > %_sysconfdir/gds_hosts.equiv
fi
%post_service %name

%preun server
%preun_service %name

%pre server
# Create the firebird group if it doesn't exist
%_sbindir/groupadd -f -r %name 2>/dev/null ||:
%_sbindir/useradd -d %_localstatedir/%name -g %name -s /dev/null -r %name 2>/dev/null ||:

%pre
# Add gds_db to %_sysconfdir/services if needed
FileName=%_sysconfdir/services
newLine="gds_db          3050/tcp  # Firebird SQL Database Remote Protocol"
oldLine=`grep "^gds_db" $FileName`
if [ -z "$oldLine" ]; then
	echo $newLine >> $FileName
fi

%files
%_docdir/%name/IDPLicense.txt
%_docdir/%name/IPLicense.txt
%doc doc/*
%dir %fbroot
%dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/databases.conf
%config(noreplace) %_sysconfdir/%name/fbtrace.conf
%config(noreplace) %_sysconfdir/%name/firebird.conf
%config(noreplace) %_sysconfdir/%name/plugins.conf
%dir %_datadir/%name
%dir %_datadir/%name/upgrade
%_datadir/%name/upgrade/*
%dir %_libdir/%name/plugins
%_libdir/%name/plugins/*
%dir %_datadir/%name/misc
%_datadir/%name/misc/*.sql

%files devel
%attr (0755,root,root) %_bindir/fb_config
%_bindir/gpre
%_includedir/*
%_libdir/libfbclient.so
%_pkgconfigdir/*.pc

%files utils
%_bindir/gbak
%_bindir/gfix
%_bindir/gstat-fb
%_bindir/isql-fb
%_bindir/qli
%_bindir/fbtracemgr

%files -n libfbclient
%_libdir/libfbclient.so.*

%files server
%attr(0644,root,root) %_tmpfilesdir/%name.conf
%dir %attr(2775,root,%name) %_localstatedir/%name
%dir %attr(2775,root,%name) %_localstatedir/%name/secdb
%dir %attr(2775,root,%name) %_localstatedir/%name/system
%dir %attr(2775,root,%name) %_localstatedir/%name/backup
#ghost %_sysconfdir/gds_hosts.equiv
%dir %fbroot/udf
%dir %fbroot/intl
%attr(0660,firebird,firebird) %config(noreplace) %_localstatedir/%name/secdb/security3.fdb
%attr(0664,firebird,firebird) %_localstatedir/%name/system/help.fdb
%attr(0664,firebird,firebird) %_localstatedir/%name/system/firebird.msg
%config(noreplace) %_sysconfdir/%name/fbintl.conf
%_sysconfdir/%name/libfbintl.so
%attr(0755,root,root) %_initdir/%name
#TODO: move xinetd.d config to separate subpackage
%config(noreplace) %attr(640,root,root) %_sysconfdir/xinetd.d/%name
%_unitdir/*
%dir %attr (2770,root,%name) %_logdir/%name
%attr (0660,%name,%name) %_logdir/%name/%name.log
%fbroot/udf/*
%fbroot/intl/*
%_bindir/gsplit
%_bindir/nbackup
%_bindir/gsec
%_bindir/fbsvcmgr
%attr (0755,root,root) %_sbindir/*.sh
%_sbindir/fb_lock_print
%_sbindir/fbguard
%_sbindir/firebird
%_libdir/libib_util.so
%_datadir/%name/*.sh

%files doc
%_docdir/%name
%exclude %_docdir/%name/IDPLicense.txt
%exclude %_docdir/%name/IPLicense.txt
%exclude %_docdir/%name/sample

%files examples
%_docdir/%name/sample
%attr(0660,%name,%name) %_localstatedir/%name/data/employee.fdb
%dir %_datadir/%name/examples
%_datadir/%name/examples/*

%changelog
